const auth = require("../middleware/auth");
const express = require("express");
const app = express();
const userCtrl = require('../controllers/user.controller');

var multer = require("multer");
const { storage } = require("../config/multer.config");
var upload = multer({ storage: storage });


// Retrieve all Users
app.get("/", auth, userCtrl.findAll);
app.get("/owners/list", auth, userCtrl.getOwners);
app.get("/contractors/list", auth, userCtrl.getContractors);
app.get("/inspectors/list", auth, userCtrl.getInspectors);
app.get("/manufacturers/list", auth, userCtrl.getManufacturers);
// app.get("/managers/list", auth, userCtrl.getManagers);
app.get("/foreman/list", auth, userCtrl.getProjectForeman);

// Create a new User
app.post('/add', auth, userCtrl.create);
// Retrieve a single User with userId
app.get('/details/:userId', auth, userCtrl.findOne);
// Update a User with userId
app.put('/update/:userId', auth, userCtrl.update);
// Delete a User with userId
app.delete('/delete/:userId', auth, userCtrl.delete);
// Retrieve a all Projects by contractorId
app.get('/projects/:userId', auth, userCtrl.getProjectsByUserID);

app.post('/upload_company_logo',upload.fields([{ name: "company_logo" }]),userCtrl.uploadCompanyLogo);



// Update logged in user profile details
app.put('/myaccount/update', auth, userCtrl.updateMyAccount);
// change Passowrd - My profile
app.post('/changePassword', auth, userCtrl.changeMyPassword);
// validate OTP - My profile
app.post('/validate-otp', auth, userCtrl.validateOtp);
// update Password- My profile
app.post('/set-password', auth, userCtrl.updatePassword);

app.post('/change-avatar',upload.fields([{ name: "profile_pic" }]), auth, userCtrl.changeProfilePic);

// search user by email
app.post('/findUser', auth, userCtrl.findUserByEmail);

app.post('/resetUserPwd', userCtrl.changeUserPasswordByUserIDViaAdmin);

// Admin Routes
// change user status
app.put('/change-status/:userId', auth, userCtrl.changeStatus);
// Retrieve admin my account details
app.get('/my-details', auth, userCtrl.myDetails);
// change Passowrd - Admin user
app.post('/admin/change-password', auth, userCtrl.changeAdminPassword);

app.get('/admin/testing', userCtrl.testing);

// Retrieve admin my account details
app.get('/test-email',  userCtrl.testEmail);

module.exports = app;