
const auth = require("../middleware/auth");
const express = require("express");
const app = express();
const reportsCtrl = require('../controllers/reports.controller');


var multer = require("multer");
const { storage } = require("../config/multer.config");
var upload = multer({ storage: storage });

// Retrieve all Reports
app.get("/", auth, reportsCtrl.findAll);

// Retrieve all Reports of loggedin user
app.get("/user_reports", auth, reportsCtrl.findMyReports);

// Retrieve all Reports of user by userId
app.get("/byUserId/:id", auth, reportsCtrl.getReportsByUserId);

// Create a new Report
app.post('/add', upload.fields([{ name: "roof_drawings" }, { name: "google_earth" }, { name: 'inspection_photos' }, { name: 'inspection_videos' }, { name: "supporting_documents" }]), auth, reportsCtrl.create);

// Retrieve a single Report with reportId
app.get('/details/:id', auth, reportsCtrl.findOne);

// Update a Reports with reportId
app.put('/update/:id', upload.fields([{ name: "roof_drawings" }, { name: "google_earth" }, { name: 'inspection_photos' }, { name: 'inspection_videos' }, { name: "supporting_documents" }]), auth, reportsCtrl.update);

// Delete a Reports with reportId
app.delete('/delete/:id', auth, reportsCtrl.delete);

// change Report status
app.put('/changeStatus/:reportId', auth, reportsCtrl.changeStatus);

// Retrieve a reports for a project
app.get('/byProject/:id', auth, reportsCtrl.findReportsByProjectId);

// Retrieve a al stakeholders of report by report id
app.get('/stakeholders/:id', auth, reportsCtrl.getProjectStackeholders);

// Send report on email
app.post('/sendReport', auth, reportsCtrl.sendReport);

// download report as pdf
// Retrieve all Reports
app.get("/downloadReport/:reportId", auth, reportsCtrl.downloadReportApp);

var fs = require('fs');
var pdf = require('html-pdf');


app.get("/download/:reportId", auth, reportsCtrl.downloadReport);
app.post("/pdf/remove", auth, reportsCtrl.cleanPdfDocument);


// app.get("/download/:reportId", async (req, res) =>{
//     var html = fs.readFileSync('./public/assets/index-new.html', 'utf8');
//     var options = { format: 'Letter' };
//     pdf.create(htmlReport, options).toFile('./demo2.pdf', function(err, data) {
//         if (err) return console.log(err);
//         console.log(data); // { filename: '/app/businesscard.pdf' }
//         // return res.send(200)
//         res.download(data.filename, (err) => {
//             if (err) {
//               console.log(err); // Check error if you want
//             }
//             fs.unlink(data.filename, function(){
//                 console.log("File was deleted") // Callback
//             });
          
//             // fs.unlinkSync(yourFilePath) // If you don't need callback
//           })
//       });
// })

module.exports = app;
const reportData = {
    "is_error": false,
    "mediaFiles": [
      {
        "_id": "6436d6b04f2c3a7b2a27072e",
        "type": "roof_drawings",
        "mimetype": "application/pdf",
        "extn": "pdf",
        "filename": "roof_drawings-1681315498755-U1NwHo0DMXPGFsdESffX59.pdf",
        "path": "public/uploads/reports/roof_drawings/roof_drawings-1681315498755-U1NwHo0DMXPGFsdESffX59.pdf",
        "ref_id": "6436d6b04f2c3a7b2a27072b",
        "description": "",
        "deleted": false,
        "__v": 0,
        "createdAt": "2023-04-12T16:05:04.892Z",
        "updatedAt": "2023-04-12T16:05:04.892Z"
      },
      {
        "_id": "6436d6b04f2c3a7b2a27072f",
        "type": "inspection_photos",
        "mimetype": "image/png",
        "extn": "png",
        "filename": "inspection_photos-1681315498762-EB0Mhmuvnrx47MYJj9cAoB.png",
        "path": "public/uploads/reports/inspection_photos/inspection_photos-1681315498762-EB0Mhmuvnrx47MYJj9cAoB.png",
        "ref_id": "6436d6b04f2c3a7b2a27072b",
        "description": "This is my first description ffmmf",
        "deleted": false,
        "__v": 0,
        "createdAt": "2023-04-12T16:05:04.893Z",
        "updatedAt": "2023-04-15T09:33:06.578Z"
      },
      {
        "_id": "6436d6b04f2c3a7b2a270730",
        "type": "inspection_photos",
        "mimetype": "image/png",
        "extn": "png",
        "filename": "inspection_photos-1681315498799-8zepn25eZ9kmYkJkErrZVI.png",
        "path": "public/uploads/reports/inspection_photos/inspection_photos-1681315498799-8zepn25eZ9kmYkJkErrZVI.png",
        "ref_id": "6436d6b04f2c3a7b2a27072b",
        "description": "descfmg,ng,dn,f,nfd,n,n,n,",
        "deleted": false,
        "__v": 0,
        "createdAt": "2023-04-12T16:05:04.893Z",
        "updatedAt": "2023-04-15T09:33:06.578Z"
      },
      {
        "_id": "6436d6b04f2c3a7b2a270731",
        "type": "inspection_photos",
        "mimetype": "image/png",
        "extn": "png",
        "filename": "inspection_photos-1681315498803-xiqPjj2qjTMiVIXR4YGb29.png",
        "path": "public/uploads/reports/inspection_photos/inspection_photos-1681315498803-xiqPjj2qjTMiVIXR4YGb29.png",
        "ref_id": "6436d6b04f2c3a7b2a27072b",
        "description": "nnngngngjhehbrgf dfnfnfnffnfnfn",
        "deleted": false,
        "__v": 0,
        "createdAt": "2023-04-12T16:05:04.893Z",
        "updatedAt": "2023-04-15T09:33:06.580Z"
      },
      {
        "_id": "6436d6b04f2c3a7b2a270732",
        "type": "inspection_photos",
        "mimetype": "image/png",
        "extn": "png",
        "filename": "inspection_photos-1681315498837-Af6UyhFcdVfVUeHxlOZIML.png",
        "path": "public/uploads/reports/inspection_photos/inspection_photos-1681315498837-Af6UyhFcdVfVUeHxlOZIML.png",
        "ref_id": "6436d6b04f2c3a7b2a27072b",
        "description": "",
        "deleted": false,
        "__v": 0,
        "createdAt": "2023-04-12T16:05:04.893Z",
        "updatedAt": "2023-04-15T09:33:06.581Z"
      },
      {
        "_id": "6436d6b04f2c3a7b2a270733",
        "type": "inspection_videos",
        "mimetype": "video/mp4",
        "extn": "mp4",
        "filename": "inspection_videos-1681315498841-h4j6f0S8A4gq81yXurM3bM.mp4",
        "path": "public/uploads/reports/inspection_videos/inspection_videos-1681315498841-h4j6f0S8A4gq81yXurM3bM.mp4",
        "ref_id": "6436d6b04f2c3a7b2a27072b",
        "description": "Video-1 description",
        "deleted": false,
        "__v": 0,
        "createdAt": "2023-04-12T16:05:04.894Z",
        "updatedAt": "2023-04-15T09:33:06.581Z"
      },
      {
        "_id": "6436d6b04f2c3a7b2a270734",
        "type": "inspection_videos",
        "mimetype": "video/mp4",
        "extn": "mp4",
        "filename": "inspection_videos-1681315499018-ykKccftKPnHQg2qjkXTErX.mp4",
        "path": "public/uploads/reports/inspection_videos/inspection_videos-1681315499018-ykKccftKPnHQg2qjkXTErX.mp4",
        "ref_id": "6436d6b04f2c3a7b2a27072b",
        "description": "Video-2 description",
        "deleted": false,
        "__v": 0,
        "createdAt": "2023-04-12T16:05:04.894Z",
        "updatedAt": "2023-04-15T09:33:06.581Z"
      },
      {
        "_id": "6436d6b04f2c3a7b2a270735",
        "type": "inspection_videos",
        "mimetype": "video/mp4",
        "extn": "mp4",
        "filename": "inspection_videos-1681315501010-YXmmtOmHCWN465tQVUMtnC.mp4",
        "path": "public/uploads/reports/inspection_videos/inspection_videos-1681315501010-YXmmtOmHCWN465tQVUMtnC.mp4",
        "ref_id": "6436d6b04f2c3a7b2a27072b",
        "description": "Video-3 description",
        "deleted": false,
        "__v": 0,
        "createdAt": "2023-04-12T16:05:04.894Z",
        "updatedAt": "2023-04-15T09:33:06.582Z"
      },
      {
        "_id": "6436d6b04f2c3a7b2a270736",
        "type": "inspection_videos",
        "mimetype": "video/mp4",
        "extn": "mp4",
        "filename": "inspection_videos-1681315501799-G9Oz5fVaPmV4j3FgBzIkNo.mp4",
        "path": "public/uploads/reports/inspection_videos/inspection_videos-1681315501799-G9Oz5fVaPmV4j3FgBzIkNo.mp4",
        "ref_id": "6436d6b04f2c3a7b2a27072b",
        "description": "Lorem Ipsum is simply dummy text of the printing and typesetting industry",
        "deleted": false,
        "__v": 0,
        "createdAt": "2023-04-12T16:05:04.895Z",
        "updatedAt": "2023-04-15T09:33:06.582Z"
      },
      {
        "_id": "6436d6b04f2c3a7b2a270737",
        "type": "supporting_documents",
        "mimetype": "image/png",
        "extn": "png",
        "filename": "supporting_documents-1681315502193-zcwFQVNYPLqknX9XEfj35P.png",
        "path": "public/uploads/reports/supporting_documents/supporting_documents-1681315502193-zcwFQVNYPLqknX9XEfj35P.png",
        "ref_id": "6436d6b04f2c3a7b2a27072b",
        "description": "Lorem Ipsum is simply dummy text of the printing and typesetting industry",
        "deleted": false,
        "__v": 0,
        "createdAt": "2023-04-12T16:05:04.895Z",
        "updatedAt": "2023-04-15T09:33:06.584Z"
      },
      {
        "_id": "6436d6b04f2c3a7b2a270738",
        "type": "supporting_documents",
        "mimetype": "image/png",
        "extn": "png",
        "filename": "supporting_documents-1681315502198-qR5fKCrNjo59N42V9Xnsaa.png",
        "path": "public/uploads/reports/supporting_documents/supporting_documents-1681315502198-qR5fKCrNjo59N42V9Xnsaa.png",
        "ref_id": "6436d6b04f2c3a7b2a27072b",
        "description": "Lorem Ipsum is simply dummy text of the printing and typesetting industry",
        "deleted": false,
        "__v": 0,
        "createdAt": "2023-04-12T16:05:04.896Z",
        "updatedAt": "2023-04-15T09:33:06.585Z"
      },
      {
        "_id": "6436d6b04f2c3a7b2a270739",
        "type": "supporting_documents",
        "mimetype": "image/png",
        "extn": "png",
        "filename": "supporting_documents-1681315502223-U9q2aRtg9SSriknlWLjx8Q.png",
        "path": "public/uploads/reports/supporting_documents/supporting_documents-1681315502223-U9q2aRtg9SSriknlWLjx8Q.png",
        "ref_id": "6436d6b04f2c3a7b2a27072b",
        "description": "nnngngngjhehbrgf dfnfnfnffnfnfn",
        "deleted": false,
        "__v": 0,
        "createdAt": "2023-04-12T16:05:04.896Z",
        "updatedAt": "2023-04-15T09:33:06.585Z"
      },
      {
        "_id": "6436d6b04f2c3a7b2a27073a",
        "type": "supporting_documents",
        "mimetype": "image/png",
        "extn": "png",
        "filename": "supporting_documents-1681315502238-OHS8s9xe0XlGt6nzQz8up4.png",
        "path": "public/uploads/reports/supporting_documents/supporting_documents-1681315502238-OHS8s9xe0XlGt6nzQz8up4.png",
        "ref_id": "6436d6b04f2c3a7b2a27072b",
        "description": "Lorem Ipsum is simply dummy text of the printing and typesetting industry",
        "deleted": false,
        "__v": 0,
        "createdAt": "2023-04-12T16:05:04.896Z",
        "updatedAt": "2023-04-15T09:33:06.585Z"
      },
      {
        "_id": "6436d6b04f2c3a7b2a27073b",
        "type": "supporting_documents",
        "mimetype": "video/mp4",
        "extn": "mp4",
        "filename": "supporting_documents-1681315502240-xNnbI3Tv9brNkdMVbwPM3v.mp4",
        "path": "public/uploads/reports/supporting_documents/supporting_documents-1681315502240-xNnbI3Tv9brNkdMVbwPM3v.mp4",
        "ref_id": "6436d6b04f2c3a7b2a27072b",
        "description": "Video-1 description",
        "deleted": false,
        "__v": 0,
        "createdAt": "2023-04-12T16:05:04.896Z",
        "updatedAt": "2023-04-15T09:33:06.585Z"
      },
      {
        "_id": "6436d6b04f2c3a7b2a27073c",
        "type": "supporting_documents",
        "mimetype": "video/mp4",
        "extn": "mp4",
        "filename": "supporting_documents-1681315502505-7EUQctYtpyNv8m81OC2bvF.mp4",
        "path": "public/uploads/reports/supporting_documents/supporting_documents-1681315502505-7EUQctYtpyNv8m81OC2bvF.mp4",
        "ref_id": "6436d6b04f2c3a7b2a27072b",
        "description": "Video-2 description",
        "deleted": false,
        "__v": 0,
        "createdAt": "2023-04-12T16:05:04.897Z",
        "updatedAt": "2023-04-15T09:33:06.585Z"
      },
      {
        "_id": "6436d6b04f2c3a7b2a27073d",
        "type": "supporting_documents",
        "mimetype": "video/mp4",
        "extn": "mp4",
        "filename": "supporting_documents-1681315504373-ftADUhXnawklL6s3m8Yhxo.mp4",
        "path": "public/uploads/reports/supporting_documents/supporting_documents-1681315504373-ftADUhXnawklL6s3m8Yhxo.mp4",
        "ref_id": "6436d6b04f2c3a7b2a27072b",
        "description": "Video-3 description",
        "deleted": false,
        "__v": 0,
        "createdAt": "2023-04-12T16:05:04.897Z",
        "updatedAt": "2023-04-15T09:33:06.585Z"
      },
      {
        "_id": "6436d6b04f2c3a7b2a27073e",
        "type": "supporting_documents",
        "mimetype": "video/mp4",
        "extn": "mp4",
        "filename": "supporting_documents-1681315504618-ic7CQG1CUe23ETJDXom4LK.mp4",
        "path": "public/uploads/reports/supporting_documents/supporting_documents-1681315504618-ic7CQG1CUe23ETJDXom4LK.mp4",
        "ref_id": "6436d6b04f2c3a7b2a27072b",
        "description": "Lorem Ipsum is simply dummy text of the printing and typesetting industry",
        "deleted": false,
        "__v": 0,
        "createdAt": "2023-04-12T16:05:04.897Z",
        "updatedAt": "2023-04-15T09:33:06.586Z"
      },
      {
        "_id": "6436d6b04f2c3a7b2a27073f",
        "type": "supporting_documents",
        "mimetype": "application/pdf",
        "extn": "pdf",
        "filename": "supporting_documents-1681315504751-fJLTNTzRyEYw57E7w7UhT6.pdf",
        "path": "public/uploads/reports/supporting_documents/supporting_documents-1681315504751-fJLTNTzRyEYw57E7w7UhT6.pdf",
        "ref_id": "6436d6b04f2c3a7b2a27072b",
        "description": "Lorem Ipsum is simply dummy text of the printing and typesetting industry",
        "deleted": false,
        "__v": 0,
        "createdAt": "2023-04-12T16:05:04.898Z",
        "updatedAt": "2023-04-15T09:33:06.586Z"
      },
      {
        "_id": "6436d6b04f2c3a7b2a270740",
        "type": "supporting_documents",
        "mimetype": "application/pdf",
        "extn": "pdf",
        "filename": "supporting_documents-1681315504764-N0dD514ucZQxybomct5T7V.pdf",
        "path": "public/uploads/reports/supporting_documents/supporting_documents-1681315504764-N0dD514ucZQxybomct5T7V.pdf",
        "ref_id": "6436d6b04f2c3a7b2a27072b",
        "description": "Lorem Ipsum is simply dummy text of the printing and typesetting industry",
        "deleted": false,
        "__v": 0,
        "createdAt": "2023-04-12T16:05:04.898Z",
        "updatedAt": "2023-04-15T09:33:06.586Z"
      },
      {
        "_id": "6436d6b04f2c3a7b2a270741",
        "type": "supporting_documents",
        "mimetype": "application/pdf",
        "extn": "pdf",
        "filename": "supporting_documents-1681315504772-JSyn8moGEkZt81XE5bGPWU.pdf",
        "path": "public/uploads/reports/supporting_documents/supporting_documents-1681315504772-JSyn8moGEkZt81XE5bGPWU.pdf",
        "ref_id": "6436d6b04f2c3a7b2a27072b",
        "description": "Lorem Ipsum is simply dummy text of the printing and typesetting industry",
        "deleted": false,
        "__v": 0,
        "createdAt": "2023-04-12T16:05:04.898Z",
        "updatedAt": "2023-04-15T09:33:06.587Z"
      },
      {
        "_id": "6436f3704f2c3a7b2a270a53",
        "type": "google_earth",
        "mimetype": "application/octet-stream",
        "extn": "google_earth-1681322864723-fcinlxbjvqewtahtjinykb",
        "filename": "google_earth-1681322864723-fciNlxbjVQewTahtJiNYKB",
        "path": "public/uploads/reports/google_earth/google_earth-1681322864723-fciNlxbjVQewTahtJiNYKB",
        "ref_id": "6436d6b04f2c3a7b2a27072b",
        "description": "",
        "deleted": false,
        "__v": 0,
        "createdAt": "2023-04-12T18:07:44.810Z",
        "updatedAt": "2023-04-15T09:33:06.578Z"
      }
    ]
  };
const reportDetails ={
    "_id": "6436d6b04f2c3a7b2a27072b",
    "report_title": "Demo report submission By Inspector Portal interface",
    "project_start_date": "2023-02-12T03:52:51.085Z",
    "onsite_material_confirmed": false,
    "inspection_date": "2023-04-12T15:56:43.762Z",
    "weather": "Rainy",
    "crew_size": 120,
    "area_completed_onday": "25000",
    "completion_percentage": 24,
    "forecasted_completion_date": "2023-04-12T15:56:43.762Z",
    "work_description": "This Is my Report description",
    "projectId": {
      "_id": "63e8627a7a7b9874a62ee731",
      "name": "Crawfordsville Square IN",
      "assignedManufacturers": [
        {
          "_id": "61e12531ca0b5adf6d49d871",
          "email": "manu@yopmail.com",
          "role": "MANUFACTURER",
          "company_name": "ABC Consultants",
          "first_name": "Manufacturer",
          "last_name": "Singh"
        },
        {
          "_id": "6227492a289dc9f6a269e36c",
          "first_name": "Shivam",
          "last_name": "Pa",
          "email": "admin@yopmail.com",
          "role": "MANUFACTURER",
          "company_name": "ABC Consultants"
        },
        {
          "_id": "62289325fac838abbf126568",
          "first_name": "shabaz",
          "last_name": "alam ammm",
          "email": "shabaz07@mailinator.com",
          "role": "MANUFACTURER",
          "company_name": "ABC Consultants"
        },
        {
          "_id": "62d11a258079d586ad94d93e",
          "first_name": "Yashpal",
          "last_name": "Yadav",
          "email": "yashpal15thjune@yopmail.com",
          "role": "MANUFACTURER",
          "company_name": "ABC Consultants"
        }
      ],
      "assignedContractor": {
        "_id": "62289b3afac838abbf1265de",
        "first_name": "Shivam",
        "last_name": "Contractor",
        "email": "mynameshivam@gmail.com",
        "role": "CONTRACTOR",
        "company_name": "ABC Consultants"
      },
      "country": "India",
      "state": "MH",
      "city": "Nagpur",
      "zip_code": "284002",
      "address_line": "Surplus, Aldis - 820 Palm Bay Rd., Palm Bay, FL 32905 edited",
      "assignedOwner": {
        "_id": "624f10ab5fc753536d3b582d",
        "email": "abc@gmail.com",
        "first_name": "Shank",
        "last_name": "Casey",
        "role": "OWNER",
        "company_name": "ABC Consultants"
      },
      "assignedManager": [
        {
          "_id": "62cfd94d5829692f560fa3d7",
          "email": "colgateop866@gmail.com",
          "role": "MANAGER",
          "company_name": "ABC Consultants",
          "first_name": "Op",
          "last_name": "Colgatea"
        }
      ]
    },
    "additional_remark": "No Addition remarks , all good so far ",
    "is_deleted": false,
    "inspector_id": {
      "_id": "61c1320f58e81b661c9d997e",
      "first_name": "Report",
      "last_name": "Administrator"
    },
    "created_by": {
      "_id": "61c1320f58e81b661c9d997e",
      "first_name": "Report",
      "last_name": "Administrator"
    },
    "createdAt": "2023-04-12T16:05:04.853Z",
    "updatedAt": "2023-04-15T09:33:06.537Z",
    "__v": 0,
    "updated_by": {
      "_id": "61c1320f58e81b661c9d997e",
      "first_name": "Report",
      "last_name": "Administrator"
    }
  }

const htmlReport = `<!DOCTYPE html>
<html>

<head>
    <title></title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <style type="text/css">
        /* CLIENT-SPECIFIC STYLES */
        body,
        table,
        td,
        a {
            -webkit-text-size-adjust: 100%;
            -ms-text-size-adjust: 100%;
        }

        table,
        td {
            mso-table-lspace: 0pt;
            mso-table-rspace: 0pt;
        }

        img {
            -ms-interpolation-mode: bicubic;
        }

        /* RESET STYLES */
        img {
            border: 0;
            height: auto;
            line-height: 100%;
            outline: none;
            text-decoration: none;
        }

        table {
            border-collapse: collapse !important;
        }

        body {
            height: 100% !important;
            margin: 0 !important;
            padding: 0 !important;
            width: 100% !important;
        }

        /* iOS BLUE LINKS */
        a[x-apple-data-detectors] {
            color: inherit !important;
            text-decoration: none !important;
            font-size: inherit !important;
            font-family: inherit !important;
            font-weight: inherit !important;
            line-height: inherit !important;
        }

        /* MOBILE STYLES */
        @media screen and (max-width:600px) {
            h1 {
                font-size: 32px !important;
                line-height: 32px !important;
            }
        }

        /* ANDROID CENTER FIX */
        div[style*="margin: 16px 0;"] {
            margin: 0 !important;
        }

        .btn {
            display: inline-block;
            font-weight: 400;
            color: #212529;
            text-align: center;
            vertical-align: middle;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none;
            background-color: transparent;
            border: 1px solid transparent;
            border-top-color: transparent;
            border-top-width: 1px;
            border-right-color: transparent;
            border-right-width: 1px;
            border-bottom-color: transparent;
            border-bottom-width: 1px;
            border-left-color: transparent;
            border-left-width: 1px;
            padding: .375rem .75rem;
            font-size: 1rem;
            line-height: 1.5;
            border-radius: .25rem;
            transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
        }

        .btn.btn-flat {
            border-radius: 0;
            border-width: 1px;
            box-shadow: none;
        }

        .btn-dark {
            color: #fff;
            background-color: #343a40;
            border-color: #343a40;
            box-shadow: none;
        }

        .btn-block {
            display: block;
            width: 100%;
        }
    </style>
</head>

<body style="background-color: #f4f4f4; margin: 0 !important; padding: 0 !important;">
    <!-- HIDDEN PREHEADER TEXT -->
    <div
        style="display: none; font-size: 1px; color: #fefefe; line-height: 1px; font-family: 'Lato', Helvetica, Arial, sans-serif; max-height: 0px; max-width: 0px; opacity: 0; overflow: hidden;">
        Project progress report has been submited by inspector</div>
    <table border="0" cellpadding="0" cellspacing="0" width="100%">
        <!-- LOGO -->
        <tr>
            <td bgcolor="#27316f" align="center">
                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                    <tr>
                        <td align="left" valign="top" style="padding: 20px 20px 20px 20px;">
                            <img src="http://cdn.mcauto-images-production.sendgrid.net/0b2eb67a10355746/58d55aef-9e6b-4aa8-8c0b-adae64ab4070/217x80.png"
                                width="150" height="120" style="display: block; border: 0px;" />
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td bgcolor="#e21e25" align="center" style="padding: 0px 10px 0px 10px;">
                <table class="wrapper" role="module" data-type="image" border="0" cellpadding="0" cellspacing="0"
                    width="100%" style="table-layout: fixed;" data-muid="3Ypdby9Xfsf2rN27zTDEfN">
                    <tbody>
                        <tr>
                            <td style="font-size:6px; line-height:10px; padding:0px 0px 0px 0px;" valign="top"
                                align="center">
                            </td>
                        </tr>
                    </tbody>
                </table>
                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                    <tr>
                        <td bgcolor="#ffffff" align="center" valign="top"
                            style="padding: 30px; border-radius: 4px 4px 0px 0px; color: #111111; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 48px; font-weight: 400; letter-spacing: 4px; line-height: 18px;">
                            <h1 style="font-size: 28px; color: #27316f">Daily Progress Report</h1>
                            <p style="font-size:14px">${reportDetails.projectId.name}</p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td bgcolor="#f4f4f4" align="center" style="padding: 0px 10px 0px 10px;">
                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                    <tr>
                        <td bgcolor="#ffffff" align="left"
                            style="padding: 20px 30px 40px 30px; color: #666666; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 14px; font-weight: 400; line-height: 25px;">
                            <p style="margin: 0;">
                                {{{email_message}}}
                            </p>
                            <p style="margin: 0;">
                            ${reportDetails.work_description}
                            </p>
                            <h2>Prepared For :</h2>
                            <ul style="list-style:none">
                                <li>
                                    <strong style="color:#27316f;">Project Name :</strong>
                                    <span style="margin-left:5px">${reportDetails.projectId.name}
                                    </span>
                                </li>
                                <li>
                                    <strong style="color:#27316f;">Start Date :</strong>
                                    <span style="margin-left:5px">
                                    ${reportDetails.project_start_date}
                                    </span>
                                </li>
                                <li>
                                    <strong style="color:#27316f;">Location :</strong>
                                    <span style="margin-left:5px">
                                        {{location}}
                                    </span>
                                </li>
                                <li>
                                    <strong style="color:#27316f;">Project Size :</strong>
                                    <span style="margin-left:5px">
                                        Approximately  ${reportDetails.project_start_date} Square Feet.
                                    </span>
                                </li>
                            </ul>
                            <h2>Inspection Details:</h2>
                            <ul style="list-style:none">
                                <li>
                                    <strong style="color:#27316f;">Inspection Date:</strong>
                                    <span style="margin-left:5px"> ${reportDetails.inspection_date}
                                    </span>
                                </li>
                                <li>
                                    <strong style="color:#27316f;">Material Confirmed Onsite:</strong>
                                    <span style="margin-left:5px">  ${reportDetails.onsite_material_confirmed}.
                                    </span>
                                </li>
                                <li>
                                    <strong style="color:#27316f;">Crew Size :</strong>
                                    <span style="margin-left:5px">
                                    ${reportDetails.crew_size}
                                    </span>
                                </li>
                                <li>
                                    <strong style="color:#27316f;">Area Completed On Day :</strong>
                                    <span style="margin-left:5px">
                                    ${reportDetails.area_completed_onday} Square Feet
                                    </span>
                                </li>
                                <li>
                                    <strong style="color:#27316f;">Weather Condition:</strong>
                                    <span style="margin-left:5px">
                                    ${reportDetails.weather}
                                    </span>
                                </li>
                                <li>
                                    <strong style="color:#27316f;">Total Inspection Documents:</strong>
                                    <span style="margin-left:5px">
                                        {{documents_count}}
                                    </span>
                                </li>
                                <li>
                                    <strong style="color:#27316f;">Total Inspection Photos:</strong>
                                    <span style="margin-left:5px">
                                        {{inspection_photos_count}}
                                    </span>
                                </li>
                                <li>
                                    <strong style="color:#27316f;">Total Inspection Video:</strong>
                                    <span style="margin-left:5px">
                                        {{inspection_video_count}}
                                    </span>
                                </li>
                                <li>
                                    <strong style="color:#27316f;">Completion Progress :</strong>
                                    ${reportDetails.completion_percentage}%
                                </li>
                            </ul>
                            <p><strong>Comments: </strong>{{{remarks}}}</p>
                            <p>View Detailed progress projects report online at
                                <a href="{{report_url}}">{{report_url}}</a>
                            </p>
                            <p style="text-align: center">
                                <a href="{{report_url}}" class="btn btn-flat btn-dark">View Detailed Progres Report</a>
                            </p>
                            <h2>Google Earth Photo :</h2>
                            <img class="max-width" border="0"
                                style="display:block; color:#000000; text-decoration:none; font-family:Helvetica, arial, sans-serif; font-size:16px; max-width:100% !important; width:100%; height:auto !important;"
                                src="{{google_photo_url}}" alt="" width="600" data-responsive="true"
                                data-proportionally-constrained="false">
                            <h2>Inspection Photos :</h2>
                            <ul style="list-style:none;">
                                {{#each inspection_photos}}
                                <li style="float:left; padding:5px; border:0.5px solid #ccc; width:200px; margin:5px">
                                    <img style="display:block;  width:100%; height:200px" src={{{this.path}}}>
                                    <p> {{this.description}}</p>
                                </li>
                                {{/each}}
                            </ul>

                        </td>
                    </tr>
                    <tr>
                    </tr>
                    <tr>
                        <td bgcolor="#ffffff" align="left"
                            style="padding: 0px 30px 20px 30px; color: #666666; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 14px; font-weight: 400; line-height: 25px;">
                            <p style="margin: 0;">If you have any questions, just reply to this email&mdash;we're always
                                happy to help out.</p>
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#ffffff" align="left"
                            style="padding: 0px 30px 40px 30px; border-radius: 0px 0px 4px 4px; color: #666666; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 14px; font-weight: 400; line-height: 25px;">
                            <p style="margin: 0;">Sincerely ,<br>Team Roof Inspections  <br> roofinspections.reports</p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td bgcolor="#f4f4f4" align="center" style="padding: 30px 10px 0px 10px;">
                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                    <tr>
                        <td bgcolor="#fff" align="center"
                            style="padding: 30px 30px 30px 30px; border-radius: 4px 4px 4px 4px; color: #666666; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 18px; font-weight: 400; line-height: 25px;">
                            <h2 style="font-size: 18px; font-weight: 400; color: #27316f; margin: 0;">Need more help?
                            </h2>
                            <p style="margin: 0;"><a href="https://roofinspections.report" target="_blank"
                                    style="color: #e21e25;">We&rsquo;re here to help you out</a></p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td bgcolor="#f4f4f4" align="center" style="padding: 0px 10px 0px 10px;">
                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                    <tr>
                        <td bgcolor="#f4f4f4" align="left"
                            style="text-align: center; padding: 0px 30px 30px 30px; color: #666666; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 14px; font-weight: 400; line-height: 18px;">
                            <br>
                            RoofInspections® is a Registered Trademark of and Copyright© 2023-2024 roofingprojects.com.
                            All Rights Reserved.</p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>

</html>`