
const auth = require("../middleware/auth");
const express = require("express");
const app = express();
const ctrl = require('../controllers/communication_message.controller');
const publicReportsCtrl = require('../controllers/public_web.controller');


// validateReportId
app.get('/validateReportId/:id', publicReportsCtrl.validateReportId);
// Get Inspection details
app.get('/report/details/:id', publicReportsCtrl.findOne);

// Retrieve a reports for a project
app.get('/report/byProject/:id', publicReportsCtrl.findReportsByProjectId);



// Retrieve all communication for a report
app.get('/reports/:id', auth, ctrl.getCommunicationByreportId);

// Retrieve all communication for a report
app.get('/details/:id', auth, ctrl.getMessageDetails);

// Retrieve a al stakeholders of report by report id
app.get('/report/stakeholders/:id', ctrl.getProjectStackeholders);

// Send report on email
app.post('/sendMessage', auth, ctrl.sendMessage);


module.exports = app;