const auth = require("../middleware/auth");
const express = require("express");
const app = express();
const intakeFormCtrl = require('../controllers/intakeForm.controller');

var multer = require("multer");
const { storage } = require("../config/multer.config");
var upload = multer({ storage: storage });

    // Retrieve all Projects
    app.get("/", auth, intakeFormCtrl.findAll);

    // Create a new Project
    app.post('/add', upload.fields([{ name: "project_roof_drawings" },{ name: "project_google_earth" },{ name: "project_images" },{ name: "project_documents" }]), auth, intakeFormCtrl.create);

    // Retrieve a single Project with projectId
    app.get('/details/:id', auth, intakeFormCtrl.findOne);

    // Update a Projects with projectId
    app.put('/update/:id', upload.fields([{ name: "project_roof_drawings" },{ name: "project_google_earth" },{ name: "project_images" },{ name: "project_documents" }]), auth, intakeFormCtrl.update);

    // Delete a Projects with projectId
    app.delete('/delete/:id', auth, intakeFormCtrl.delete);
    
    // change project status
    app.put('/changeStatus/:projectId', auth, intakeFormCtrl.changeStatus);

    app.get("/assigned_projects", auth, intakeFormCtrl.getUserAssignedProjects);

    // Retrieve a all google Earth , roof drawings and specififcations Media with projectId
    app.get('/media_files/:id', auth, intakeFormCtrl.getProjectDocuments);

module.exports = app;