const auth = require("../middleware/auth_contractor");
const express = require("express");
const app = express();
const userCtrl = require('../controllers/user.controller');


const projectCtrl = require('../controllers/contractor/project.controller');
const paymentCtrl = require('../controllers/contractor/opportunity_payment.controller');
const bidFormCtrl = require('../controllers/bidForm.controller');
const bidSubmissionCtrl = require('../controllers/contractor/bid_submission.controller');




const masterProjectDescCtrl = require('../controllers/masterProjectDescription.controller');
const masterLineItemsCtrl = require('../controllers/masterLineItem.controller');
const estimatorAssistanceCtrl = require('../controllers/masterEstimatorAssistance.controller');
const projectestimatoreCtrl = require('../controllers/projectEstimatorAssistance.controller');
const questionAnswerCtrl = require('../controllers/contractor/questionAnswer.controller');


var multer = require("multer");
const { storage } = require("../config/multer.config");
var upload = multer({ storage: storage });


// PROJECT MANAGEMENT ROUTES
app.get("/projects/list", auth, projectCtrl.findAll);
app.get("/projects/purchasedprojects",auth, projectCtrl.myPurchasedProjects);
app.get("/projects/biddenProjects",auth, projectCtrl.myBiddenProjects);

app.get('/projects/details/:id', auth, projectCtrl.findOne);

// BUY PROJECT ROUTES
app.post("/opportunity/payment", paymentCtrl.makePayment);

// PROJECT ESTIMATOR ASSIGNMENT MANAGEMENT ROUTES
app.get('/projectEstimator/list/:project_id', auth, projectestimatoreCtrl.getProjectEstimator);
app.get('/bidForm/list/:project_id', auth, bidFormCtrl.getProjectBidForm);

// app.get('/my_submission/list', auth, bidSubmissionCtrl.myBidSubmissionList);
app.get('/my_submission/details/:project_id', auth, bidSubmissionCtrl.myProjectBidSubmissionDetails);

app.post('/submitMyBid', auth, bidSubmissionCtrl.submitBid);
app.put('/updateMyBid/:id', auth, bidSubmissionCtrl.updateBid);

// Question Answer Management
app.get("/projects/questions/list/:id", auth, questionAnswerCtrl.getProjectSpecificQuestions);
app.get("/projects/myquestions/list/:id", auth,  questionAnswerCtrl.getMyaskedQuestions);

app.post('/projects/questions/submit', auth, questionAnswerCtrl.submitQuestion);
app.delete('/projects/questions/delete/:id', auth, questionAnswerCtrl.delete);


// ######################################################################

// MASTER PROJECT DESCRIPTION MANAGEMENT ROUTES
app.get("/master_description/list", auth, masterProjectDescCtrl.getMasterDescription);
app.post('/master_description/add', auth, masterProjectDescCtrl.addMasterDescription);
app.put('/master_description/update/:id', auth , masterProjectDescCtrl.updateMasterDescription);
app.delete('/master_description/delete/:id', auth, masterProjectDescCtrl.delete);

// MASTER BID LINE ITEMS MANAGEMENT ROUTES
app.get("/master_line_items/list", auth, masterLineItemsCtrl.getMasterLineItems);
app.post('/master_line_items/add', auth, masterLineItemsCtrl.addMasterLineItem);
app.put('/master_line_items/update/:id', auth , masterLineItemsCtrl.updateMasterLineItem);
app.delete('/master_line_items/delete/:id', auth, masterLineItemsCtrl.delete);


// PROJECT BID FORM TEMPLATE MANAGEMENT ROUTES
app.get('/bidForm/list/:project_id', auth, bidFormCtrl.getProjectBidForm);
app.post('/bidForm/add', auth, bidFormCtrl.createBidForm);
app.put('/bidForm/update/:id', auth , bidFormCtrl.updateBidForm);

// MASTER ESTIMATOR ASSISTANCE MANAGEMENT ROUTES
app.get("/estimator_assistance/list", auth, estimatorAssistanceCtrl.getMasterEstimatorAssistance);
app.post('/estimator_assistance/add', auth, estimatorAssistanceCtrl.addMasterEstimatorAssistance);
app.put('/estimator_assistance/update/:id', auth , estimatorAssistanceCtrl.updateMasterEstimatorAssistance);
app.delete('/estimator_assistance/delete/:id', auth, estimatorAssistanceCtrl.delete);







// Update logged in user profile details
app.put('/myaccount/update', auth, userCtrl.updateMyAccount);
// change Passowrd - My profile
app.post('/changePassword', auth, userCtrl.changeMyPassword);
// validate OTP - My profile
app.post('/validate-otp', auth, userCtrl.validateOtp);
// update Password- My profile
app.post('/set-password', auth, userCtrl.updatePassword);

app.post('/change-avatar',upload.fields([{ name: "profile_pic" }]), auth, userCtrl.changeProfilePic);

// search user by email
app.post('/findUser', auth, userCtrl.findUserByEmail);

app.post('/resetUserPwd', userCtrl.changeUserPasswordByUserIDViaAdmin);

// Admin Routes
// change user status
app.put('/change-status/:userId', auth, userCtrl.changeStatus);
// Retrieve admin my account details
app.get('/my-details', auth, userCtrl.myDetails);
// change Passowrd - Admin user
app.post('/admin/change-password', auth, userCtrl.changeAdminPassword);

app.get('/admin/testing', userCtrl.testing);

// Retrieve admin my account details
app.get('/test-email',  userCtrl.testEmail);

module.exports = app;