
const auth = require("../middleware/auth");
const express = require("express");
const app = express();
const ctrl = require('../controllers/communication_message.controller');

// Retrieve all communication for a report
app.get('/reports/:id', auth, ctrl.getCommunicationByreportId);

// Retrieve all communication for a report
app.get('/details/:id', auth, ctrl.getMessageDetails);

// Retrieve a al stakeholders of report by report id
app.get('/stakeholders/:id', auth, ctrl.getProjectStackeholders);

// Send report on email
app.post('/sendMessage', auth, ctrl.sendMessage);


module.exports = app;