const User = require("../model/user");
const OTPModel = require("../model/otp");

const helper = require('../middleware/_helper');
const bcrypt = require("bcrypt");
const jwt = require("jsonwebtoken");
const auth = require("../middleware/auth");
const otpGenerator = require('otp-generator');
var moment = require('moment'); // require
const emailCtrl = require('../controllers/email.controller');
const email_templates = require('../config/email_template_ids');

const contractorCtrl = require('../controllers/contractor.controller');


var multer = require("multer");
const { storage } = require("../config/multer.config");
var upload = multer({ storage: storage });

const express = require("express");
const app = express();


app.post("/login", async (req, res) => {
  // Our login logic starts here
  try {
    // Get user input
    const { email, password } = req.body;
    // Validate user input
    if (!(email && password)) {
      res.status(400).send({ "is_error": true, "message": "All input is required" });
    } else {
      // Validate if user exist in our database
      const { email, password } = req.body;
      // get user along with assign modules and same orders
      const user = await User.findOne({ email: email.toLowerCase() });
      console.log("Found user", user)
      if (!user || user.deleted)
      return res.status(409).send({ "is_error": true, "message": "User not found! Invalid credentials." });


      let passwordIsValid = bcrypt.compareSync(password, user.password);
      console.log("passwordIsValid", passwordIsValid)
      // const newpassword = bcrypt.hashSync('root@123', 16);
      // const newpassword= await bcrypt.hash(password, 10);
      // console.log("New Password",newpassword)
      if (passwordIsValid) {
        // check if active
        if (!user.status)
        return res.status(409).send({ "is_error": true, "message": "Your Account is Inactive. Please contact Administrator." });

        // START: map assign modules in order which aranged while assign permissions from front-end request

        //this need to be udated with populate
        let accesses = [];
        if (user.role === "ADMIN" || user.role === "RPC_MANAGER") {
          // const permissions = await UserPermission.findOne({ user_id: user._id }).exec();

          // accesses = Array.isArray(permissions.module) ? [...permissions.module] : []
        }
        const token = jwt.sign(
          {
            _id: user._id,
            _role_name: user.role,
          },
          process.env.TOKEN_KEY,
          {
            expiresIn: '24h',
          }
        );
         // response send to UI
         const responseSendToUI = {
          message: "Login Successfully.",
          status: 'SUCCESS',
          code:200,
          data: {
            "_id": user._id,
            "first_name": user.first_name,
            "last_name": user.last_name,
            "email": user.email,
            "role": user.role,
            "is_admin": user.is_admin,
            "status": user.status,
            "password_change_required": user.password_change_required,
            "profileImage": user.profileImage,
            "token": token
  
          }
         }
         
        user.token = token;
        
        return res.status(200).json(responseSendToUI);
      } else {
        return res.status(400).send({ "is_error": true, "message": "Invalid Credentials." });
      }
    }
  } catch (err) {
    console.log(err);
  }
  // Our Login logic ends here
});

app.post('/register',upload.fields([{ name: "company_logo" }]),contractorCtrl.addContractor);


app.post("/inspector/login", async (req, res) => {
  // Our login logic starts here
  try {
    // Get user input
    const { email, password } = req.body;
    // Validate user input
    if (!(email && password)) {
      res.status(400).send({ "is_error": true, "message": "All input is required" });
    } else {
      // Validate if user exist in our database
      const user = await User.findOne({ email: email.toLowerCase() });
      if (user && (await bcrypt.compare(password, user.password))) {
        if (!user.is_active) {
          return res.status(409).send({ "is_error": true, "message": "Your Account is Inactive. Please contact Administrator." });
        }
        if (user.role != 'INSPECTOR') {
          return res.status(409).send({ "is_error": true, "message": "Invalid Credentials. Please make sure to use correct details of your Inspector account." });
        }
        // Create token
        const token = jwt.sign(
          { user_id: user._id, email, role: user.role },
          process.env.TOKEN_KEY,
          {
            expiresIn: "2h",
          }
        );
        // save user token to DB
        // const updatedUserData = await User.findByIdAndUpdate(user.id, { token: token }, { new: true });
        // response send to UI
        const responseSendToUI = {
          "_id": user._id,
          "first_name": user.first_name,
          "last_name": user.last_name,
          "email": user.email,
          "is_admin": user.is_admin,
          "is_active": user.is_active,
          "profileImage": user.profileImage,
          "role": user.role,
          "token": token

        }
        user.token = token;
        // Saving Device Token to DB for FCM notifications
        const deviceToken = req.headers["rgd-token"];
        const deviceType = req.headers["device_type"];

        if (deviceToken) {
          const deviceTokenData = new deviceTokenModel({
            registrationToken: deviceToken,
            user_id: user._id,
            deviceType: deviceType
          });
          // Save device token in the database
          deviceTokenData.save()
            .then(data => {
              return res.status(200).json(responseSendToUI);
            }).catch(err => {
              return res.status(200).json(responseSendToUI);
            });
        } else {
          return res.status(200).json(responseSendToUI);
        }

      } else {
        return res.status(400).send({ "is_error": true, "message": "Invalid Credentials." });
      }
    }
  } catch (err) {
    console.log(err);
  }
  // Our Login logic ends here
});

app.get('/logout', auth, async (req, res) => {
  const token = req.body.token || req.query.token || req.headers["x-access-token"];
  const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
  User.updateOne({ "token": token }, { $unset: { token: 1 } })
    .then(async data => {

      // Delete device token from collection on logout
      const deviceToken = req.headers["rgd-token"];
      console.log("logged out user Data", deviceToken)
      deviceTokenModel.deleteMany({ registrationToken: deviceToken })
        .then(devicetokenresponse => {
          console.log('SUccess device tolken delete', devicetokenresponse);
          res.send({ "is_error": false, "message": "Logged out successfully." });

        }).catch(err => {
          return res.status(200).json(responseSendToUI);
        });

    }).catch(err => {
      res.status(500).send({
        message: err.message || "Some error occurred while Logout."
      });
    });
});

// Forgot Password
app.post("/forgot-password", async (req, res) => {
  console.log("body Payload", req.body);
  // Our logic starts here
  try {
    // Get user input
    const { email } = req.body;

    // Validate user input
    if (!(email)) {
      res.status(400).send({ "is_error": true, "message": "Please provide user email." });
    } else {
      // Validate if user exist in our database
      const user = await User.findOne({ email: email.toLowerCase() });

      if (user) {
        const user = await User.findOne({ email });

        const OTP = otpGenerator.generate(6, { digits: true, lowerCaseAlphabets: false, upperCaseAlphabets: false, specialChars: false });
        const expireTime = moment(new Date(), "DD-MM-YYYY hh:mm:ss")
          .add(1, 'minutes')
          .format('DD/MM/YYYY hh:mm:ss');

        // const textMsg = 'Dear' + user.first_name + ' ' + user.last_name + ', Your OTP verification code is ' + OTP + ' Thanks , Team LifeStampR Support.';
        // const htmlTextMsg = '<h6> Dear ' + user.first_name + ' ' + user.last_name + ',</h6><p> Your OTP verification code is </br> <strong>' + OTP + '</strong></p> </br> Thanks, </br> Team LifeStampR Support.'
        const emailData = {
          msg: {
            to: user.email,
            from: process.env.SUPPORT_EMAIL, // Use the email address or domain you verified above
            template_id: email_templates.CHANGE_PASSWORD_EMIL_TEMPLATE_ID,
            dynamic_template_data: {
              "subject": "OTP-Change Password Request",
              "first_name": user.first_name,
              "last_name": user.last_name,
              "OTP": OTP
            }
          },
          userDetails: user
        }

        const OTP_Payload = {
          user_id: user._id,
          email: user.email,
          otpvalue: OTP
        };
        let OTP_data = await OTPModel.findOneAndUpdate({ email: user.email, user_id: user._id }, OTP_Payload, {
          new: true,
          upsert: true // Make this update into an upsert
        });
        if (OTP_data) {
          // send Email to User with OTP
          emailCtrl.sendEmail(emailData);
          res.send({ is_error: false, data: {}, message: "OTP has been sent to email . Please verify the OTP." });

        } else {
          res.status(400).send({ "is_error": true, "message": "Error occured. Please try after some time." });
        }
      } else {
        res.status(400).send({ "is_error": true, "message": "Invalid Details" });
      }
    }
  } catch (err) {
    console.log(err);
  }
  // Our logic ends here
});

// validate OTP
app.post("/validate-otp", async (req, res) => {
  console.log("body Payload", req.body);
  // Our logic starts here
  try {
    // Get user input
    const { otp, email } = req.body;

    // Validate user input
    if (!(otp && email)) {
      res.status(400).send({ "is_error": true, "message": "Please provide OTP." });
    } else {

      // Validate if otp exist in our database
      const user = await OTPModel.findOne({ 'email': email.toLowerCase(), 'otpvalue': req.body.otp });

      if (user) {

        // Find note and update it with the request body
        OTPModel.findByIdAndUpdate(user._id, { otp_verfied: true })
          .then(otpData => {
            if (!otpData) {
              return res.status(404).send({
                is_error: true,
                message: "Invalid OTP ! Either you have entered wrong OTP or your OTP has been expired."
              });
            }
            res.send({
              is_error: false,
              message: "OTP has been verified successfully."
            });
          }).catch(err => {
            if (err.kind === 'ObjectId') {
              return res.status(404).send({
                is_error: true,
                message: "Invalid OTP ! Either you have entered wrong OTP or your OTP has been expired."
              });
            }
            return res.status(500).send({
              is_error: true,
              message: "Invalid OTP! Either you have entered wrong OTP or your OTP has been expired."
            });
          });

      } else {
        res.status(400).send({ "is_error": true, "message": "Invalid OTP ! Either you have entered wrong OTP or your OTP has been expired." });
      }
    }
  } catch (err) {
    console.log(err);
  }
  // Our logic ends here
});

// change Password
app.post("/change-password", async (req, res) => {
  // Our logic starts here
  try {
    // Get user input
    const { password, email, otp } = req.body;

    // Validate user input
    if (!(password && email)) {
      res.status(400).send({ "is_error": true, "message": "Please provide passowrd" });
    } else {

      // Validate if user exist in our database
      const user = await User.findOne({ 'email': email.toLowerCase() });
      // Validate if otp exist in our database
      const OTPfound = await OTPModel.findOne({ 'email': email.toLowerCase(), 'otpvalue': req.body.otp });

      if (user && OTPfound && OTPfound.otp_verfied) {
        //Encrypt user password
        encryptedPassword = await bcrypt.hash(password, 10);

        // delete otp entry from DB
        OTPModel.findByIdAndRemove(OTPfound._id)
          .then(otpData => {
            if (!otpData) {
              return res.status(404).send({
                is_error: true,
                message: "Invalid OTP ! Either you have entered wrong OTP or your OTP has been expired."
              });
            }
            // Find user and update password
            User.findByIdAndUpdate(user._id, {
              password: encryptedPassword,
            })
              .then(userData => {
                if (!userData) {
                  return res.status(404).send({
                    is_error: true,
                    message: "Error while updating password."
                  });
                }
                res.send({
                  is_error: false,
                  message: "Password changed successfully."
                });
              }).catch(err => {
                if (err.kind === 'ObjectId') {
                  return res.status(404).send({
                    is_error: true,
                    message: "Error while updating Password."
                  });
                }
                return res.status(500).send({
                  is_error: true,
                  message: "Error while updating Password."
                });
              });
          }).catch(err => {
            if (err.kind === 'ObjectId' || err.name === 'NotFound') {
              return res.status(404).send({
                is_error: true,
                message: "Invalid OTP ! Either you have entered wrong OTP or your OTP has been expired."
              });
            }
            return res.status(500).send({
              is_error: true,
              message: "Invalid OTP ! Either you have entered wrong OTP or your OTP has been expired."
            });
          });

      } else {
        res.status(400).send({ "is_error": true, "message": "Error while updating Password.Invalid OTP ! Either you have entered wrong OTP or your OTP has been expired." });
      }
    }
  } catch (err) {
    console.log(err);
  }
  // Our logic ends here
});

// Admin forgot password- step-1
app.post("/verify_admin_email", async (req, res) => {
  console.log("body Payload", req.body);
  // Our admin reset password logic starts here
  try {
    // Get user input
    // Validate user input
    if (!(req.body.email)) {
      res.status(400).send({ "is_error": true, "message": "Please provide Email." });
    } else {
      // Validate if user exist in our database
      const user = await User.findOne({ email: req.body.email.toLowerCase(), is_admin: true });
      console.log("Found User Data", user);

      if (user) {
        const user = await User.findOne({ email: req.body.email.toLowerCase(), is_admin: true });

        const OTP = otpGenerator.generate(6, { digits: true, lowerCaseAlphabets: false, upperCaseAlphabets: false, specialChars: false });

        const textMsg = 'Dear' + user.first_name + ' ' + user.last_name + ', Your OTP verification code is ' + OTP + ' Thanks , Team LifeStampR Support.';
        const htmlTextMsg = '<h6> Dear ' + user.first_name + ' ' + user.last_name + ',</h6><p> Your OTP verification code is </br> <strong>' + OTP + '</strong></p> </br> Thanks, </br> Team LifeStampR Support.'
        const emailData = {
          msg: {
            to: [user.email],
            from: process.env.SUPPORT_EMAIL, // Use the email address or domain you verified above
            template_id: email_templates.FORGOT_PASSWORD_OTP_TEMPLATE_ID,
            dynamic_template_data: {
              "first_name": user.first_name,
              "last_name": user.last_name,
              "OTP": OTP
            }
          },
          userDetails: user
        }

        const OTP_Payload = {
          user_id: user._id,
          email: user.email,
          otpvalue: OTP
        };
        let OTP_data = await OTPModel.findOneAndUpdate({ email: user.email, user_id: user._id }, OTP_Payload, {
          new: true,
          upsert: true // Make this update into an upsert
        });
        if (OTP_data) {
          // send Email to Admin user with OTP
          emailCtrl.sendEmail(emailData);
          res.send({ is_error: false, data: {}, message: "OTP has been sent to email . Please verify the OTP." });

        } else {
          res.status(400).send({ "is_error": true, "message": "Error while validating details. Please try after some time." });
        }

      } else {
        return res.status(400).send({ "is_error": true, "message": "Invalid Credentials." });
      }
    }
  } catch (err) {
    console.log(err);
  }
  // Our admin reset password logic ends here
});

// Admin change Password
app.post("/change_admin_password", async (req, res) => {
  // Our logic starts here
  try {
    // Get user input
    const { password, email, otp } = req.body;

    // Validate user input
    if (!(password && email && otp)) {
      res.status(400).send({ "is_error": true, "message": "Please provide passowrd & OTP" });
    } else {

      // Validate if user exist in our database
      const user = await User.findOne({ 'email': email.toLowerCase(), is_admin: true });
      // Validate if otp exist in our database
      const OTPfound = await OTPModel.findOne({ 'email': email.toLowerCase(), 'otpvalue': req.body.otp });

      if (user && OTPfound) {
        //Encrypt user password
        encryptedPassword = await bcrypt.hash(password, 10);

        // delete otp entry from DB
        OTPModel.findByIdAndRemove(OTPfound._id)
          .then(otpData => {
            if (!otpData) {
              return res.status(404).send({
                is_error: true,
                message: "Invalid OTP ! Either you have entered wrong OTP or your OTP has been expired."
              });
            }
            // Find user and update password
            User.findByIdAndUpdate(user._id, {
              password: encryptedPassword,
            })
              .then(userData => {
                if (!userData) {
                  return res.status(404).send({
                    is_error: true,
                    message: "Error while updating password."
                  });
                }
                res.send({
                  is_error: false,
                  message: "Password changed successfully."
                });
              }).catch(err => {
                if (err.kind === 'ObjectId') {
                  return res.status(404).send({
                    is_error: true,
                    message: "Error while updating Password."
                  });
                }
                return res.status(500).send({
                  is_error: true,
                  message: "Error while updating Password."
                });
              });
          }).catch(err => {
            if (err.kind === 'ObjectId' || err.name === 'NotFound') {
              return res.status(404).send({
                is_error: true,
                message: "Invalid OTP ! Either you have entered wrong OTP or your OTP has been expired."
              });
            }
            return res.status(500).send({
              is_error: true,
              message: "Invalid OTP ! Either you have entered wrong OTP or your OTP has been expired."
            });
          });

      } else {
        res.status(400).send({ "is_error": true, "message": "Error while updating Password.Invalid OTP ! Either you have entered wrong OTP or your OTP has been expired." });
      }
    }
  } catch (err) {
    console.log(err);
  }
  // Our logic ends here
});

module.exports = app;