const auth = require("../middleware/auth");
const express = require("express");
const app = express();
const userCtrl = require('../controllers/user.controller');

const rpcCtrl = require('../controllers/rpc.controller');
const ownerCtrl = require('../controllers/owner.controller');
const contractorCtrl = require('../controllers/contractor.controller');
const manufacturerCtrl = require('../controllers/manufacturer.controller');
const ownerTypeCtrl = require('../controllers/ownerType.controller');
const buildingTypeCtrl = require('../controllers/buildingType.controller');
const buildingCtrl = require('../controllers/building.controller');
const projectCtrl = require('../controllers/project.controller');
const masterProjectDescCtrl = require('../controllers/masterProjectDescription.controller');
const masterLineItemsCtrl = require('../controllers/masterLineItem.controller');
const bidFormCtrl = require('../controllers/bidForm.controller');
const estimatorAssistanceCtrl = require('../controllers/masterEstimatorAssistance.controller');
const projectestimatoreCtrl = require('../controllers/projectEstimatorAssistance.controller');
const bidSubmissionCtrl = require('../controllers/bid_submission_summary.controller');
const faqCtrl = require('../controllers/faq.controller');
const questionAnswerCtrl = require('../controllers/questionAnswer.controller');


var multer = require("multer");
const { storage } = require("../config/multer.config");
var upload = multer({ storage: storage });

// RPC MANAGER ROUTES
app.get("/rpcmanagers/list", auth, rpcCtrl.getRpcManagers);
app.post('/rpcmanagers/add', auth, upload.fields([{ name: "company_logo" }]),rpcCtrl.addRpcManager);
app.get('/rpcmanagers/details/:userId', auth, rpcCtrl.findOne);
app.put('/rpcmanagers/update/:userId', auth, upload.fields([{ name: "company_logo" }]), rpcCtrl.updateRpcManager);


// OWNERS ROUTES
app.get("/owners/list", auth, ownerCtrl.getOwners);
app.post('/owners/add', auth, upload.fields([{ name: "company_logo" }]),ownerCtrl.addOwner);
app.get('/owners/details/:userId', auth, ownerCtrl.findOne);
app.put('/owners/update/:userId', auth, upload.fields([{ name: "company_logo" }]), ownerCtrl.updateOwner);

// CONTRACTOR ROUTES
app.get("/contractors/list", auth, contractorCtrl.getContractors);
app.post('/contractors/add', auth, upload.fields([{ name: "company_logo" }]),contractorCtrl.addContractor);
app.get('/contractors/details/:userId', auth, contractorCtrl.findOne);
app.put('/contractors/update/:userId', auth, upload.fields([{ name: "company_logo" }]), contractorCtrl.updateContractor);
app.get('/contractors/purchasedProjects/:userId', auth, projectCtrl.contractorPurchasedProjects);
app.get('/contractors/biddenProjects/:userId', auth, projectCtrl.contractorBiddenProjects);


// MANUFACTURER ROUTES
app.get("/manufacturers/list", auth, manufacturerCtrl.getManufacturers);
app.post('/manufacturers/add', auth, upload.fields([{ name: "company_logo" }]),manufacturerCtrl.addManufacturer);
app.get('/manufacturers/details/:userId', auth, manufacturerCtrl.findOne);
app.put('/manufacturers/update/:userId', auth, upload.fields([{ name: "company_logo" }]), manufacturerCtrl.updateManufacturer);


// OWNER TYPE MANAGEMENT ROUTES
app.get("/ownerType/list", auth, ownerTypeCtrl.getOwnerTypes);
app.post('/ownerType/add', auth, ownerTypeCtrl.addOwnerType);
app.put('/ownerType/update/:id', auth , ownerTypeCtrl.updateOwnerType);
app.delete('/ownerType/delete/:id', auth , ownerTypeCtrl.delete);

// BUILDING TYPE MANAGEMENT ROUTES
app.get("/buildingType/list", auth, buildingTypeCtrl.getBuildingTypes);
app.post('/buildingType/add', auth, buildingTypeCtrl.addBuildingType);
app.put('/buildingType/update/:id', auth , buildingTypeCtrl.updateBuildingType);
app.delete('/buildingType/delete/:id', auth , buildingTypeCtrl.delete);

// BUILDING MANAGEMENT ROUTES
app.get("/buildings/list", auth, buildingCtrl.getBuildings);
app.post('/buildings/add', auth, upload.fields([{ name: "building_videos" }, { name: "building_images" }, { name: "building_documents" }]),buildingCtrl.addBuilding);
app.get('/buildings/details/:id', auth, buildingCtrl.findOne);
app.get('/buildings/detailsView/:id', auth, buildingCtrl.getBuildingDetails);
app.put('/buildings/update/:id', auth, upload.fields([{ name: "building_videos" }, { name: "building_images" }, { name: "building_documents" }]), buildingCtrl.updateBuilding);

// PROJECT MANAGEMENT ROUTES
app.get("/project/list", auth, projectCtrl.findAll);
app.get("/project/standardAvailable/list", auth, projectCtrl.getAllNotAssignedStdProjects);
app.post('/project/add', auth, upload.fields([{ name: "project_roof_drawings" }, { name: "project_roof_photos" }, { name: "standard_contract" }, { name: "insurance" }, { name: "project_videos" }, { name: "detail_drawings" }, { name: "specifications" }]),projectCtrl.create);
app.get('/project/details/:id', auth, projectCtrl.findOne);
app.put('/project/update/:id', auth, upload.fields([{ name: "project_roof_drawings" }, { name: "project_roof_photos" }, { name: "standard_contract" }, { name: "insurance" }, { name: "project_videos" }, { name: "detail_drawings" }, { name: "specifications" }]), projectCtrl.update);

app.get("/project/listByPropertyId/:id", auth, projectCtrl.findAllByPropertyId);

app.put('/media/update/:id', auth, projectCtrl.updateMediaDescription);


// MASTER PROJECT DESCRIPTION MANAGEMENT ROUTES
app.get("/master_description/list", auth, masterProjectDescCtrl.getMasterDescription);
app.post('/master_description/add', auth, masterProjectDescCtrl.addMasterDescription);
app.put('/master_description/update/:id', auth , masterProjectDescCtrl.updateMasterDescription);
app.delete('/master_description/delete/:id', auth, masterProjectDescCtrl.delete);

// MASTER BID LINE ITEMS MANAGEMENT ROUTES
app.get("/master_line_items/list", auth, masterLineItemsCtrl.getMasterLineItems);
app.post('/master_line_items/add', auth, masterLineItemsCtrl.addMasterLineItem);
app.put('/master_line_items/update/:id', auth , masterLineItemsCtrl.updateMasterLineItem);
app.delete('/master_line_items/delete/:id', auth, masterLineItemsCtrl.delete);


// PROJECT BID FORM TEMPLATE MANAGEMENT ROUTES
app.get('/bidForm/list/:project_id', auth, bidFormCtrl.getProjectBidForm);
app.post('/bidForm/add', auth, bidFormCtrl.createBidForm);
app.put('/bidForm/update/:id', auth , bidFormCtrl.updateBidForm);

// MASTER ESTIMATOR ASSISTANCE MANAGEMENT ROUTES
app.get("/estimator_assistance/list", auth, estimatorAssistanceCtrl.getMasterEstimatorAssistance);
app.post('/estimator_assistance/add', auth, estimatorAssistanceCtrl.addMasterEstimatorAssistance);
app.put('/estimator_assistance/update/:id', auth , estimatorAssistanceCtrl.updateMasterEstimatorAssistance);
app.delete('/estimator_assistance/delete/:id', auth, estimatorAssistanceCtrl.delete);


// PROJECT ESTIMATOR ASSIGNMENT MANAGEMENT ROUTES
app.get('/projectEstimator/list/:project_id', auth, projectestimatoreCtrl.getProjectEstimator);
app.post('/projectEstimator/add', auth, projectestimatoreCtrl.createProjectEstimator);
app.put('/projectEstimator/update/:id', auth , projectestimatoreCtrl.updateProjectEstimator);


// PROJECT BID SUBMISSIONS LIST ROUTES
app.get('/bidSubmission/list/:project_id', auth, bidSubmissionCtrl.getProjectBidSubmission);

// FAQs MANAGEMENT ROUTES
app.get("/faq/list", auth, faqCtrl.getFAQs);
app.post('/faq/add', auth, faqCtrl.addFAQs);
app.put('/faq/update/:id', auth , faqCtrl.updateFAQs);
app.delete('/faq/delete/:id', auth, faqCtrl.delete);
app.get('/faq/details/:id', auth, faqCtrl.findOne);

// PROJECT QUESTION ANSWER MANGEMENT ROUTES
app.get("/project/questions/list/:id", auth, questionAnswerCtrl.getProjectSpecificQuestions);
app.post('/project/questions/add', auth, questionAnswerCtrl.addQuestion);
app.put('/project/questions/update/:id', auth , questionAnswerCtrl.updateQuestion);
app.put('/project/answer/update/:id', auth , questionAnswerCtrl.updateAnswerOnly);
app.delete('/project/questions/delete/:id', auth, questionAnswerCtrl.delete);
app.get('/project/questions/details/:id', auth, questionAnswerCtrl.findOne);




// ########### OLD Routes Below here ############## Needs to clean at last
// Retrieve all Users
app.get("/", auth, userCtrl.findAll);
app.get("/owners/list", auth, userCtrl.getOwners);
app.get("/contractors/list", auth, userCtrl.getContractors);
app.get("/inspectors/list", auth, userCtrl.getInspectors);
app.get("/manufacturers/list", auth, userCtrl.getManufacturers);
app.get("/foreman/list", auth, userCtrl.getProjectForeman);

// Create a new User
app.post('/add', auth, userCtrl.create);
// Retrieve a single User with userId
app.get('/details/:userId', auth, userCtrl.findOne);
// Update a User with userId
app.put('/update/:userId', auth, userCtrl.update);
// Delete a User with userId
app.delete('/delete/:userId', auth, userCtrl.delete);
// Retrieve a all Projects by contractorId
app.get('/projects/:userId', auth, userCtrl.getProjectsByUserID);

app.post('/upload_company_logo',upload.fields([{ name: "company_logo" }]),userCtrl.uploadCompanyLogo);



// Update logged in user profile details
app.put('/myaccount/update', auth, userCtrl.updateMyAccount);
// change Passowrd - My profile
app.post('/changePassword', auth, userCtrl.changeMyPassword);
// validate OTP - My profile
app.post('/validate-otp', auth, userCtrl.validateOtp);
// update Password- My profile
app.post('/set-password', auth, userCtrl.updatePassword);

app.post('/change-avatar',upload.fields([{ name: "profile_pic" }]), auth, userCtrl.changeProfilePic);

// search user by email
app.post('/findUser', auth, userCtrl.findUserByEmail);

app.post('/resetUserPwd', userCtrl.changeUserPasswordByUserIDViaAdmin);

// Admin Routes
// change user status
app.put('/change-status/:userId', auth, userCtrl.changeStatus);
// Retrieve admin my account details
app.get('/my-details', auth, userCtrl.myDetails);
// change Passowrd - Admin user
app.post('/admin/change-password', auth, userCtrl.changeAdminPassword);

app.get('/admin/testing', userCtrl.testing);

// Retrieve admin my account details
app.get('/test-email',  userCtrl.testEmail);

module.exports = app;