const mongoose = require("mongoose");

const userSchema = new mongoose.Schema({
  first_name: {type: String,required: true,trim: true,default: ''},
  last_name: {type: String,trim: true,default: ''},
  email: {type: String,required: true,trim: true,unique: true},
  role: { type : String }, // role: OWNER,CONTRACTOR, MANUFACTURER , RPC_MANAGER , INSPECTOR, ADMIN
  phone: { type: String },
  country: { type: String },
  state: { type: String },
  city: { type: String },
  zip_code: { type: String },
  address_line: {type: String},
  address_line2: {type: String},
  company_name: { type: String, required:true, trim:true },
  password: { type: String },
  is_admin: { type: Boolean, default: false },
  status: { type: Boolean, default: true },
  password_change_required: { type: Boolean, default: true },
  token: { type: String },
  profileImage: { type: String, default: '' },
  company_logo: { type: String, default: '' },
  owner_type: { type: mongoose.Types.ObjectId, ref: 'owner_type'}
}, {
  timestamps: true
});

module.exports = mongoose.model("user", userSchema);