const mongoose = require("mongoose");

const transactionSchema = new mongoose.Schema({
  transaction_id: {type: String , required:true, unique: true},
  amount: {type : Number, required: true},
  currency: {type : String, required: true},
  paid: {type : String, required: true},
  payment_status: { type : String , required: true},
  payment_method: {type: String , required:true},
  payment_method_details: {}, //hold card details if payment made through card
  user_id: { type: mongoose.Schema.Types.ObjectId, ref: 'user' },
  gateway_response: {}, // this will hold complete API response data.
  receipt_url: {type: String , required:true},
  billing_details: {}
}, {
  timestamps: true
});

module.exports = mongoose.model("transaction", transactionSchema);