const mongoose = require("mongoose");

const reportSchema = new mongoose.Schema({
  report_title: { type: String, required: true, trim: true , unique: true }, // mostly will b ename of project
  project_start_date: { type: Date },
  onsite_material_confirmed: { type: Boolean , default: true },
  inspection_date: { type: Date },
  weather: { type: String , default:''},
  crew_size: { type: Number , required: true },
  area_completed_onday: { type: String , default: 'Sq.Ft.' },
  completion_percentage: { type: Number , required: true },
  forecasted_completion_date: { type: Date },
  work_description: { type: String , required: true, trim: true },
  projectId: { type: mongoose.ObjectId, ref: 'projects' },
  additional_remark: { type: String },
  is_deleted: {type: Boolean , default: false},
  inspector_id: { type: mongoose.Schema.Types.ObjectId, ref: 'user' , required: true},
  created_by: { type: mongoose.Schema.Types.ObjectId, ref: 'user' , required: true},
  updated_by: { type: mongoose.Schema.Types.ObjectId, ref: 'user' },
  is_archived: {type: Boolean , default: false},
}, {
  timestamps: true
});

module.exports = mongoose.model("report", reportSchema);