const mongoose = require("mongoose");

const questionAnswersSchema = new mongoose.Schema(
  {
    question_text: {type:String, required:true, trim: true},
    answer_text: {type:String, default:"", trim: true},
    created_by: { type: mongoose.Schema.Types.ObjectId, ref: "user"},
    replied_by: { type: mongoose.Schema.Types.ObjectId, ref: "user"},
    replied_user_role: {type:String, default:"", trim: true},
    publish_status: { type: Boolean , default: false},
    project_id: { type: mongoose.Schema.Types.ObjectId, ref: "projects" , required:true}
},
{
    versionKey: false,
    timestamps: true,
    collation: { locale: 'en' }, //mongoose 4.5 caseSensitive it will help to search & sort.
    toObject: { virtuals: true },
    toJSON: { virtuals: true },
});

module.exports = mongoose.model("question_answers", questionAnswersSchema);