const mongoose = require("mongoose");

const projectSchema = new mongoose.Schema({
  parent_id: { type: mongoose.Schema.Types.ObjectId, ref: 'projects' , default:null},
  owner_id: { type: mongoose.Schema.Types.ObjectId, ref: 'user' , required: true},
  building_id: { type: mongoose.Schema.Types.ObjectId, ref: 'building' , required: true},
  name: { type: String, required: true, trim: true , unique: true},
  description: { type: String , required: true, trim: true },
  start_date: { type: Date },
  end_date: { type: Date },
  total_size: {type: Number , required: true},
  size_unit: {type: String , default: 'Sq.Ft.'},
  total_cost: {type: Number , required: true, default: 0},
  country: { type: String, required: true },
  state: { type: String , required: true},
  city: { type: String , required: true},
  zip_code: { type: String },
  address_line: {type: String},
  address_line2: {type: String},
  project_notes: { type: String },
  project_status: {type: Boolean , default: false}, // this one is for project Status , By default all project will be un published
  status: {type: Boolean , default: true}, // this one is for BID Status
  is_deleted: {type: Boolean , default: false},
  bannerImage: { type: String, default: '' },
  assignedManufacturers: [{
    type: mongoose.ObjectId,
    ref: 'user'
  }],
  opportunityBuyers: [{
    type: mongoose.ObjectId,
    ref: 'user'
  }],
  projectDescription:[],
  bid_type: { type: String, default: 'STANDARD' }, //CONSOLIDATED
  bid_start_date : { type: Date },
  bid_end_date : { type: Date },
  bidder_fees: { type: Number },
  bid_allowed_from: {type: [] },
  associatedProjects: [{
    type: mongoose.ObjectId,
    ref: 'projects'
  }],
  created_by: { type: mongoose.Schema.Types.ObjectId, ref: 'user' , required: true},
  updated_by: { type: mongoose.Schema.Types.ObjectId, ref: 'user' },

}, {
  timestamps: true,
  toObject: { virtuals: true },
  toJSON: { virtuals: true },
});

projectSchema.virtual('media', {
  ref: 'projectMedia_file',
  localField: '_id',
  foreignField: 'ref_id'
});

projectSchema.virtual('buyers', {
  ref: 'opportunity_payment',
  localField: '_id',
  foreignField: 'project_id'
});

module.exports = mongoose.model("projects", projectSchema);