const mongoose = require("mongoose");

const projectEstimatorSchema = new mongoose.Schema({
  project_id: { type: mongoose.Schema.Types.ObjectId, ref: "projects" , required:true, unique:true},
    line_items:[{
      title: {type: String, required:true , trim:true},
      description: {type: String, default:''}
    }], 
},  {
  timestamps: true,
  collation: { locale: 'en' }, //mongoose 4.5 caseSensitive it will help to search & sort.
  toObject: { virtuals: true },
  toJSON: { virtuals: true }
});

module.exports = mongoose.model("project_estimator_assistance", projectEstimatorSchema);