const mongoose = require("mongoose");

const projectBidSubmissionSchema = new mongoose.Schema({
    project_id: { type: mongoose.Schema.Types.ObjectId, ref: "projects" , required:true},
    line_items:[{
      title: {type: String, required:true , trim:true},
      description: {type: String, default:''},
      default_value: {type: Number, default: 0},
      contractor_value: {type: Number, default: 0},
      allowed_in_words:{type: Boolean , default:false},
    }], 
    submitted_by: { type: mongoose.Schema.Types.ObjectId, ref: "user" , required:true},
    selected_manufacturer: { type: mongoose.Schema.Types.ObjectId, ref: "user" , required:true},
    line_items_total: {type: Number, default: 0} ,
    // lumpsum_bid_amount: {type: Number, required: true , default: 0},
    total_bid_amount: {type: Number, required: true , default: 0},
    total_bid_amount_in_words: {type: String , default: ''},
    expected_start_date: {type: Date },
    days_to_complete: {type: Number},
    bid_status: {type:String , default: 'OPEN'}, // OPEN, CLOSED,
    is_bid_winner : {type: Boolean , default:false},
    is_draft: {type: Boolean , default:true}
},  {
  timestamps: true,
  collation: { locale: 'en' }, //mongoose 4.5 caseSensitive it will help to search & sort.
  toObject: { virtuals: true },
  toJSON: { virtuals: true }
});

module.exports = mongoose.model("project_bids_submission", projectBidSubmissionSchema);