const mongoose = require("mongoose");

const paymentIntentSchema = new mongoose.Schema({
  payment_intent: {type: String},
  uuid: {type: String , required:true, unique:true}, // generated unique uuid
  project_id: { type: mongoose.Types.ObjectId, ref: "projects", required: true},
  userId: { type: mongoose.Schema.Types.ObjectId, ref: 'user' , required: true},
  metaDataObj: {} ,// this will hold all details
  isCompleted:{type:Boolean , default : false},
  amount: {type: Number},
}, {
  timestamps: true
});

module.exports = mongoose.model("paymentIntent", paymentIntentSchema);
