const mongoose = require("mongoose");

const OpportunityPayment = new mongoose.Schema({
  project_id: { type: mongoose.Types.ObjectId, ref: "projects", required: true},
  // session_id: {type: String,required: true},
  purchasedBy: { type: mongoose.Types.ObjectId, ref: "user", required: true },
  
  // transaction_id: {type: String,required: true},
  // client_reference_id: {type: String,required: true},

  amount: {type: Number, required: true},
  currency: {type : String, required: true},
  // mode: {type: String, required: true},
  payment_status: { type: String , required: true },

  // metadata : { type: Object , required: true },
  // gateway_response: { type: Object, required: true }
  bid_submitted: { type: Boolean , default: false},


}, {
  timestamps: true,
  toObject: { virtuals: true },
  toJSON: { virtuals: true },
});

module.exports = mongoose.model("opportunity_payment", OpportunityPayment);