const mongoose = require("mongoose");

const MasterLineItemsSchema = new mongoose.Schema({
  title: {type: String, required:true , trim:true},
  description: {type: String, default:''},
  default_value: {type: Number, default: 0},
  status: {type: Boolean,default: true}
},  {
  timestamps: true,
  collation: { locale: 'en' }, //mongoose 4.5 caseSensitive it will help to search & sort.
  toObject: { virtuals: true },
  toJSON: { virtuals: true }
});

module.exports = mongoose.model("master_line_item", MasterLineItemsSchema);