const mongoose = require("mongoose");

const intakeFormSchema = new mongoose.Schema({

  project_name: { type: String, required: true, trim: true , unique: true},
  total_size: {type: Number , required: true},
  total_cost: {type: Number , required: true},
  no_of_bidders: {type: Number , required: true},
  roof_consultant_name: {
    type: mongoose.ObjectId,
    ref: 'user'
  },
  internet_bid: {type: Boolean , default: false},
  bid_result_date: { type: Date },
  bidding_qtr: {type: Number , required: true},
  region: { type: String },
  insurance_claim: {type: Boolean , default: false},
  is_union_shop: {type: Boolean , default: false},
  property_specifications: {type: Boolean , default: true},
  manufacturer_materials: [{
    type: mongoose.ObjectId,
    ref: 'manufacturer_material'
  }],

  assignedOwner: {
    type: mongoose.ObjectId,
    ref: 'user'
  },
  assignedContractor: {
    type: mongoose.ObjectId,
    ref: 'user'
  },
  assignedInspector: {
    type: mongoose.ObjectId,
    ref: 'user'
  },
  assignedManager: [{
    type: mongoose.ObjectId,
    ref: 'user'
  }],
  country: { type: String, required: true },
  state: { type: String , required: true},
  city: { type: String , required: true},
  zip_code: { type: String },
  address_line: {type: String},
  is_active: {type: Boolean , default: true},
  created_by: { type: mongoose.Schema.Types.ObjectId, ref: 'user' , required: true},
  updated_by: { type: mongoose.Schema.Types.ObjectId, ref: 'user' },

}, {
  timestamps: true
});

module.exports = mongoose.model("intakeForm", intakeFormSchema);