const mongoose = require("mongoose");

const messageSchema = new mongoose.Schema({
  sender_name: { type: String, trim: true, default: '' },
  sender_email: { type: String, required: true, trim: true},
  senderId: { type: mongoose.ObjectId, ref: 'user' },
  toUserIds: [{
    type: mongoose.ObjectId,
    ref: 'user'
  }],
  reportId: { type: mongoose.ObjectId, ref: 'report' },
  message_title: { type: String, required: true, trim: true },
  message_description: { type: String, trim: true, required: true },
  is_archived: { type: Boolean, default: false }
}, {
  timestamps: true
});

module.exports = mongoose.model("communication_message", messageSchema);