const mongoose = require("mongoose");

const buildingSchema = new mongoose.Schema({
  name: { type: String, required:true, trim:true},
  owner_id: { type: mongoose.Schema.Types.ObjectId, ref: 'user' },
  building_type: { type: mongoose.Schema.Types.ObjectId, ref: 'building_type' },
  total_size: {type: Number , required: true},
  country: { type: String },
  state: { type: String },
  city: { type: String },
  zip_code: { type: String },
  address_line: {type: String},
  address_line2: {type: String},
  status: { type: Boolean, default: true },
  slug: { type: String, required:true, unique:true},
}, {
  timestamps: true,
  toObject: { virtuals: true },
  toJSON: { virtuals: true },
});

buildingSchema.virtual('media', {
  ref: 'buildingMedia_file',
  localField: '_id',
  foreignField: 'ref_id'
});

module.exports = mongoose.model("building", buildingSchema);