const jwt = require("jsonwebtoken");

const config = process.env;

const verifyToken = (req, res, next) => {
  const token =
    req.body.token || req.query.token || req.headers["x-access-token"];

  if (!token) {
    return res.status(403).send({is_error: true, message:"Access denied."});
  }
  try {
    const decoded = jwt.verify(token, config.TOKEN_KEY);
    req.user = decoded;
    console.log("middleware auth verified", decoded);
  } catch (err) {
    return res.status(401).send({is_error: true, message:"Invalid Token"});
  }
  return next();
};

module.exports = verifyToken;