const jwt = require("jsonwebtoken");
const User = require("../model/user");

const config = process.env;

const verifyToken = async (req, res, next) => {
 
    // const tokenHeader = req.body.token || req.query.token || req.headers["Authorization"];
    
    const authHeader = req.headers.authorization;
    const token = authHeader.split("Bearer ")[1];

    console.log("middleware", token);

    if (!token) {
      return res.status(403).send({is_error: true, message:"Access denied."});
    }

    // if (authHeader && req.heademiddleware/auth_contractor.jsrs.authorization.includes("Bearer ")) {
    //     let token = authHeader.split("Bearer ")[1];
    //     if (!token) {
    //       return res.status(403).send({is_error: true, message:"Access denied."});
    //     }
    // }
 
  try {
    const decoded = jwt.verify(token, config.TOKEN_KEY);
    req.user = decoded;
    console.log("middleware auth verified", decoded);
    if (decoded._role_name != 'CONTRACTOR') {
      return res.status(403).send({is_error: true, message:"Access denied."});
    }
    const user = await User.findOne({_id: decoded._id , role: decoded._role_name });
    // console.log("user with token data", user)
    if (user && !user.status) {
      // throw new Error({"is_error": true , "message": "Your Account is Inactive. Please contact Administrator." })
      return res.status(409).send({"type":"PROFILE_INACTIVE","is_error": true , "message": "Your Account is Inactive. Please contact Administrator." });
      // throw new Error('BROKEN')
    }
  } catch (err) {
    return res.status(401).send({is_error: true, message:"Invalid Token"});
  }
  return next();
};

module.exports = verifyToken;