const otpGenerator = require('otp-generator');
var moment = require('moment'); // require
const path = require("path");
var fs = require("fs");
const fse = require('fs-extra')
const bcrypt = require("bcrypt");
const helper = require('../middleware/_helper');

const User = require('../model/user');
const ProjectModel = require('../model/projects');
const OTPModel = require("../model/otp");
const email_templates = require('../config/email_template_ids');
const emailCtrl = require('./email.controller');
const mediaUtils = require("../config/unlinkMedia");

// Retrieve and return all users from the database.
exports.findAll = async (req, res) => {
    try {
        const user = await User.find({is_admin: false}).select("-password -__v").sort([["updatedAt",-1]]);
        return res.send({"is_error":false , data:user})
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured" + error });
    }
};

// Find a single user with a userId
// exports.findOne = async (req, res) => {
//     User.findById(req.params.userId).select("-password -__v")
//         // .populate({
//         //     path:'assigned_projects'
//         // })
//         .then(userData => {
//             if (!userData) {
//                 return res.status(404).send({
//                     is_error: true,
//                     message: "User not found with id " + req.params.userId
//                 });
//             }
//             res.send({ is_error: false, data: userData });
//         }).catch(err => {
//             console.log("err", err)
//             if (err.kind === 'ObjectId') {
//                 return res.status(404).send({
//                     is_error: true,
//                     message: "User not found with id " + req.params.userId
//                 });
//             }
//             return res.status(500).send({
//                 is_error: true,
//                 message: "Error retrieving user with id " + req.params.userId
//             });
//         });
// };

// Update a user identified by the userId in the request
exports.update = async (req, res) => {
    console.log("req.body", req.body);
    console.log("req.params", req.params)
    // Validate Request
    if (!(req.body.email && req.body.first_name)) {
        return res.status(400).send({ "is_error": true, "message": "All inputs are required." });
    }
    // check if user already exist
    // Validate if user exist in our database
    const oldUser = await User.find({ email: req.body.email.toLowerCase(), _id: { $ne: req.params.userId } });
    console.log("old user", oldUser)
    if (oldUser.length > 0) {
        return res.status(409).send({ "is_error": true, "message": "User already exist with this email" });
    }
    // Find note and update it with the request body
    await User.findByIdAndUpdate(req.params.userId, {
        first_name: req.body.first_name,
        last_name: req.body.last_name,
        email: req.body.email.toLowerCase(), //sanitize convert to lowercase
        role: req.body.role,
        phone: req.body.phone,
        company_name: req.body.company_name,
        address_line: req.body.address_line,
        country: req.body.country,
        state: req.body.state,
        city: req.body.city,
        zip_code: req.body.zip_code
    }, { new: true })
        .then(userData => {
            if (!userData) {
                return res.status(404).send({
                    is_error: true,
                    message: "User details not found."
                });
            }
            res.send({
                is_error: false,
                data: userData
            });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "User details not found with provided Id."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating the account details."
            });
        });
};

// Delete a userData with the specified userId in the request
exports.delete = async (req, res) => {
    
    User.findByIdAndRemove(req.params.userId)
        .then(async userData => {
            if (!userData) {
                return res.status(404).send({
                    is_error: true,
                    message: "User not found with id " + req.params.userId
                });
            }
            // Delete User's created templates
            await templateModel.deleteMany({created_by:req.params.userId});
            // Delete User's device tokens
            await deviceTokenModel.deleteMany({user_id:req.params.userId});
            // Delete all images and documents for the event
            let imageLocation = path.resolve("./public/assets/images/" + req.params.userId);
            console.log('imageLocation', imageLocation)
            fse.remove(imageLocation, err => {
                if (err) return console.error(err)
                res.send({
                    is_error: false,
                    message: "User deleted successfully!"
                });
            })
            
        }).catch(err => {
            if (err.kind === 'ObjectId' || err.name === 'NotFound') {
                return res.status(404).send({
                    is_error: true,
                    message: "User not found with id " + req.params.userId
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Could not delete User with id " + req.params.userId
            });
        });
};


//   RPC Manager Functions
exports.getRpcManagers = async (req, res) => {
    try {
        const user = await User.find({is_admin: false,role: 'RPC_MANAGER'}).select("-password -__v").sort([["updatedAt",-1]]);
        
        return res.send({"is_error":false , data:user})
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured" + error });
    }
};

// Create New RPC Manager
exports.addRpcManager = async (req, res) => {
console.log("req.body", req.body)
    // Our Add user logic starts here
    try {
        // Get user input
        const { first_name, last_name, email, phone, company_name, address_line,address_line2, country, state, city, zip_code } = req.body;

        // For Company Logo
        if (req?.files?.company_logo) {
            req.body.company_logo = "public/uploads/company_logo/" + req.files.company_logo[0].filename;
        }

        // Validate user input
        if (!(email && first_name)) {
            if (req?.files?.company_logo) {
                mediaUtils.unlink(req.body.company_logo); // remove uploaded compony logo on error
            }
            return res.status(400).send({ "is_error": true, "message": "All input ( Email, first & last name) is required" });
        }

        // check if user already exist
        // Validate if user exist in our database
        const oldUser = await User.findOne({ email: req.body.email.toLowerCase() });

        if (oldUser) {
            if (req?.files?.company_logo) {
                mediaUtils.unlink(req.body.company_logo); // remove uploaded compony logo on error
            }
            return res.status(409).send({ "is_error": true, "message": "User Already Exist." });
        }

        const tempPassword = otpGenerator.generate(7);
        console.log(tempPassword,'Temporary Password');
        //Encrypt user password
        encryptedPassword = await bcrypt.hash(tempPassword, 10);

        // Create user in our database
        const user = await User.create({
            first_name,
            last_name,
            email: email.toLowerCase(), // sanitize: convert email to lowercase
            role: 'RPC_MANAGER',
            password: encryptedPassword,
            phone,
            company_name,
            address_line,
            address_line2,
            country,
            state,
            city,
            zip_code,
            status: req.body.status,
            company_logo: req.body.company_logo
        });

        const emailData = {
            msg: {
                to: email,
                from: process.env.SUPPORT_EMAIL, // Use the email address or domain you verified above
                template_id: email_templates.USER_ONBOARDING_EMAIL_TEMPLATE_ID,
                dynamic_template_data:{
                  "first_name": user.first_name,
                  "last_name": user.last_name,
                  "password": tempPassword
                }
              },
            userDetails: user
        }
        // check if Role is inspector then only send email
        if(req.body.role === 'INSPECTOR'){

            // send Email to User with OTP
            emailCtrl.sendEmail(emailData);
        }

        // return new user
        res.status(200).json({ is_error: false, data: user });
    } catch (err) {
        console.log(err);
        if (req?.files?.company_logo) {
            mediaUtils.unlink(req.body.company_logo); // remove uploaded compony logo on error
          }
        res.status(500).json({ is_error: true, data: {}, message:"Error While Creating user.Please try again."+ err});

    }
    // Our Add user logic ends here

};

exports.findOne = async (req, res) => {
    User.findById(req.params.userId).select("-password -__v")
        .then(userData => {
            if (!userData) {
                return res.status(404).send({
                    is_error: true,
                    message: "User not found with id " + req.params.userId
                });
            }
            res.send({ is_error: false, data: userData });
        }).catch(err => {
            console.log("err", err)
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "User not found with id " + req.params.userId
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving user with id " + req.params.userId
            });
        });
};

exports.updateRpcManager = async (req, res) => {
    console.log("req.body", req.body);
    console.log("req.params", req.params)
    // For Company Logo
    if (req?.files?.company_logo) {
        req.body.company_logo = "public/uploads/company_logo/" + req.files.company_logo[0].filename;
    }
      
    // Validate Request
    if (!(req.body.email && req.body.first_name)) {
        if (req?.files?.company_logo) {
            mediaUtils.unlink(req.body.company_logo); // remove uploaded compony logo on error
        }
        return res.status(400).send({ "is_error": true, "message": "All inputs are required." });
    }
    // check if user already exist
    // Validate if user exist in our database
    const oldUser = await User.find({ email: req.body.email.toLowerCase(), _id: { $ne: req.params.userId } });
    console.log("old user", oldUser)
    if (oldUser.length > 0) {
        if (req?.files?.company_logo) {
            mediaUtils.unlink(req.body.company_logo); // remove uploaded compony logo on error
          }
        return res.status(409).send({ "is_error": true, "message": "User already exist with this email" });
    }
    // Find user and update it with the request body
    await User.findByIdAndUpdate(req.params.userId, {
        first_name: req.body.first_name,
        last_name: req.body.last_name,
        email: req.body.email.toLowerCase(), //sanitize convert to lowercase
        phone: req.body.phone,
        company_name: req.body.company_name,
        address_line: req.body.address_line,
        address_line2: req.body.address_line2,
        country: req.body.country,
        state: req.body.state,
        city: req.body.city,
        zip_code: req.body.zip_code,
        status: req.body.status,
        company_logo: req.body.company_logo
    }, { new: true })
        .then(userData => {
            if (!userData) {
                if (req?.files?.company_logo) {
                    mediaUtils.unlink(req.body.company_logo); // remove uploaded compony logo on error
                  }
                return res.status(404).send({
                    is_error: true,
                    message: "User details not found."
                });
            }
            res.send({
                is_error: false,
                data: userData
            });
        }).catch(err => {
            if (req?.files?.company_logo) {
                mediaUtils.unlink(req.body.company_logo); // remove uploaded compony logo on error
              }
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "User details not found with provided Id."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating the account details."
            });
        });
};