const reportModel = require('../model/reports');
const mediaModel = require('../model/reportsMedia');
const projectModel = require('../model/projects');

const emailCtrl = require('../controllers/email.controller');
const email_templates = require('../config/email_template_ids');

const helper = require('../middleware/_helper');
const mediaUtils = require("../config/unlinkMedia");
const moment = require('moment');
const path = require('path');


var fs = require('fs');
var pdf = require('html-pdf');


// Create and Save a new project
exports.create = (req, res) => {
    console.log("reports Body data", req.body)

    const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
    if(!(req.body.filesMetaData && req.files)){
        // delete all uploaded report media files from directory
        const mediaRootPath = "public/uploads/reports/";
        const mediaKey = Object.keys(req.files);
        mediaKey.forEach(async key => {
            if (req.files[key].length && req.files[key].length > 0) {
                // multiple files
                const projectMediaFiles = req.files[key];
                await projectMediaFiles.forEach(async mediaFile => {
                    // call util method to remove file from location
                    mediaUtils.unlink(mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename);
                })
            }
        })
        return res.status(400).send({ "is_error": true, "message": "Please choose files & provide files meta data" });
    }
    if(req.body.filesMetaData && JSON.parse(req.body.filesMetaData).length == 0){
        // delete all uploaded report media files from directory
        const mediaRootPath = "public/uploads/reports/";
        const mediaKey = Object.keys(req.files);
        mediaKey.forEach(async key => {
            if (req.files[key].length && req.files[key].length > 0) {
                // multiple files
                const projectMediaFiles = req.files[key];
                await projectMediaFiles.forEach(async mediaFile => {
                    // call util method to remove file from location
                    mediaUtils.unlink(mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename);
                })
            }
        })
        return res.status(400).send({ "is_error": true, "message": "Please provide files meta data. Data cannot be empty" });
    }
    // Create report payload
    const reportObj = new reportModel(
      {
        report_title: req.body.report_title,
        project_start_date: req.body.project_start_date,
        onsite_material_confirmed: req.body.onsite_material_confirmed,
        inspection_date: req.body.inspection_date,
        weather: req.body.weather,
        crew_size: req.body.crew_size,
        area_completed_onday: req.body.area_completed_onday,
        completion_percentage: req.body.completion_percentage,
        forecasted_completion_date: req.body.forecasted_completion_date,
        work_description: req.body.work_description,
        projectId: req.body.projectId,
        additional_remark: req.body.additional_remark ? req.body.additional_remark : '',
        is_deleted: false,
        inspector_id: loggedInUser.data.user_id,
        created_by: loggedInUser.data.user_id,
      
      });
      const filesMetaData = req.body.filesMetaData ? JSON.parse(req.body.filesMetaData) : [];
      console.log("Report Add filesMetaData",filesMetaData)
    // Save Reports in the database
    reportObj.save()
    .then(async data => {
        let media = [];
        const mediaRootPath = "public/uploads/reports/";
        const mediaKey = Object.keys(req.files);
        mediaKey.forEach(async key => {
            if (req.files[key].length && req.files[key].length > 0) {
                // multiple files
                const projectMediaFiles = req.files[key];
                await projectMediaFiles.forEach(async mediaFile => {
                 const filedesc = await filesMetaData.filter (item => { return item.customFile === mediaFile.originalname })
                 let dataToPush = {
                    path: mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename,
                    filename: mediaFile.filename,
                    userGivenName: filedesc.length > 0 ? filedesc[0].userGivenName : mediaFile.filename,
                    ref_id: data._id,
                    type: mediaFile.fieldname,
                    mimetype: mediaFile.mimetype,
                    description: filedesc.length > 0 ? filedesc[0].description : '',
                    extn: (mediaFile.filename.split('.').pop()).toLowerCase(),
                    secquence: (filedesc.length > 0 && filedesc[0].secquence) ? filedesc[0].secquence : 0
                };
                
                 media.push(dataToPush);
                })

            } else {
                console.log("Else condition block")
            }
        })
        if(!data) {
            // remove all recently uploaded images from directory
            media.forEach(element => {
                mediaUtils.unlink(element.path);
            });
            return res.status(404).send({
                is_error : true,
                message: "Error while submitting the Report."
            });
        }
        console.log("media object", media)
        // store all images,documents and videos
        await mediaModel.insertMany(media);

        res.send({is_error : false, data: data });
    }).catch(err => {
        // delete all uploaded report media files from directory
        const mediaRootPath = "public/uploads/reports/";
        const mediaKey = Object.keys(req.files);
        mediaKey.forEach(async key => {
            if (req.files[key].length && req.files[key].length > 0) {
                // multiple files
                const projectMediaFiles = req.files[key];
                await projectMediaFiles.forEach(async mediaFile => {
                    // call util method to remove file from location
                    mediaUtils.unlink(mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename);
                })
            }
        })
        return res.status(500).send({
            is_error : true,
            message: err.message || "Some error occurred while saving report."
        });
    });
};

// Retrieve and return all reports from the database.
exports.findAll = async (req, res) => {
    try {
        let q = {
            is_deleted: false
        }
        if(req.query && req.query.dateFilter && req.query.dateFilter!=''){
            q['createdAt'] = {
                $gte: moment(req.query.dateFilter,'MM/DD/YYYY').startOf('day').toDate(),
                $lte: moment(req.query.dateFilter, 'MM/DD/YYYY').endOf('day').toDate()
              }
        }
        console.log("query", q)
        const report = await reportModel.find(q)
        .populate([ {
            path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line'],
            populate: [{ path: 'assignedManufacturers', select:['first_name','last_name','company_name','email','role'] }, 
            { path: 'assignedContractor', select:['first_name','last_name','company_name','email','role','company_logo'] },
            { path: 'assignedOwner', select:['first_name','last_name','company_name','email','role','company_logo'] },
            { path: 'assignedManager', select:['first_name','last_name','company_name','email','role','company_logo'] },
            {path:'assignedForeman', select:['first_name','last_name','company_name', 'email','phone','company_logo']}
        ]
        }])
        .populate([{path:'inspector_id', select:['first_name','last_name']}])
        .populate([{path:'created_by', select:['first_name','last_name']}])
        .populate([{path:'updated_by', select:['first_name','last_name']}])
        .sort([["createdAt",-1]]);
        res.send({is_error : false, data: report});
    } catch (error) {
        console.log(error);
        return res.send({"is_error": true , "message": "An error occured : " + error});
    }
  };

// Retrieve and return all reports for a project.
exports.findReportsByProjectId = async (req, res) => {
    try {
        const report = await reportModel.find({is_deleted: false , projectId: req.params.id})
        .populate([{
            path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line'],
            populate: [{ path: 'assignedManufacturers', select:['first_name','last_name','company_name','email','role','company_logo'] }, 
            { path: 'assignedContractor', select:['first_name','last_name','company_name','email','role','company_logo'] },
            { path: 'assignedOwner', select:['first_name','last_name','company_name','email','role','company_logo'] },
            {path:'assignedForeman', select:['first_name','last_name','company_name', 'email','phone','company_logo']}
            ]
        }])
        .populate([{path:'inspector_id', select:['first_name','last_name']}])
        .populate([{path:'created_by', select:['first_name','last_name']}])
        .populate([{path:'updated_by', select:['first_name','last_name']}])
        .sort([["createdAt",-1]]);
        res.send({is_error : false, data: report});
    } catch (error) {
        console.log(error);
        return res.send({"is_error": true , "message": "An error occured : " + error});
    }
  };

// Retrieve and return all reports for logged in user
exports.findMyReports = async (req, res) => {
    try {
        const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
        console.log("loggedInUser", loggedInUser)
        // find all assigned projects of loggedin user
        // let query = {is_deleted: false, 
        //     $or: [
        //         { 'assignedInspector': loggedInUser.data.user_id },
        //         {'assignedManufacturers': loggedInUser.data.user_id},
        //         {'assignedContractor': loggedInUser.data.user_id},
        //         {'assignedOwner': loggedInUser.data.user_id},
        //         {'created_by': loggedInUser.data.user_id }
        // ] } ;
        // console.log("final Query", query)
      
        const projects = await projectModel.find({is_deleted: false})
        var projectIds = await projects.map(function (item) {
            return item['_id'];
          });
        if(projectIds && projectIds.length != 0){

            if (req.query.limit) {
                const limitCount = parseInt(req.query.limit);
                const currentpage = (req.query.page && req.query.page !='' )? parseInt(req.query.page) : 1 ;
                let q = {
                    is_deleted: false,
                    projectId: {$in:projectIds}
                }
                if(req.query && req.query.archived && req.query.archived==='true'){
                    q['is_archived'] = true ;
                }
                if(req.query && req.query.dateFilter && req.query.dateFilter!=''){
                    q['inspection_date'] = {
                        $gte: moment(req.query.dateFilter,'MM/DD/YYYY').startOf('day').toDate(),
                        $lte: moment(req.query.dateFilter, 'MM/DD/YYYY').endOf('day').toDate()
                      }
                }
                console.log("q",JSON.stringify(q))
                const recordsCount = await reportModel.find(q).count();
                const report = await reportModel.find(q)
                .populate([{
                    path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line'],
                    populate: [{ path: 'assignedManufacturers', select:['first_name','last_name','company_name','email','role','company_logo'] }, 
                    { path: 'assignedContractor', select:['first_name','last_name','company_name','email','role','company_logo'] },
                    { path: 'assignedOwner', select:['first_name','last_name','company_name','email','role','company_logo'] }]
                }])
                .populate([{path:'inspector_id', select:['first_name','last_name']}])
                .populate([{path:'created_by', select:['first_name','last_name']}])
                .populate([{path:'updated_by', select:['first_name','last_name']}])
                .sort([["createdAt",-1]])
                .skip((+currentpage - 1) * limitCount)
                .limit(limitCount);
                const nextPage = parseInt(currentpage) + 1 ;
                const totalPages =  Math.ceil(recordsCount/limitCount);
              
                res.send({is_error : false, data: report, metaData: {totalRecords: recordsCount , currentPage:currentpage , nextPage:nextPage , totalPage: totalPages }});
            }
            else {
                let q = {
                    is_deleted: false,
                    projectId: {$in:projectIds}
                }
                if(req.query && req.query.archived && req.query.archived==='true'){
                    q['is_archived'] = true ;
                }
                if(req.query && req.query.dateFilter && req.query.dateFilter!=''){
                    q['inspection_date'] = {
                        $gte: moment(req.query.dateFilter,'MM/DD/YYYY').startOf('day').toDate(),
                        $lte: moment(req.query.dateFilter, 'MM/DD/YYYY').endOf('day').toDate()
                      }
                }
                console.log("q",JSON.stringify(q))
                const recordsCount = await reportModel.find(q).count();

                const report = await reportModel.find(q)
                .populate([{
                    path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line'],
                    populate: [{ path: 'assignedManufacturers', select:['first_name','last_name','company_name','email','role','company_logo'] }, 
                    { path: 'assignedContractor', select:['first_name','last_name','company_name','email','role','company_logo'] },
                    { path: 'assignedOwner', select:['first_name','last_name','company_name','email','role','company_logo'] },
                    {path:'assignedForeman', select:['first_name','last_name','company_name', 'email','phone','company_logo']}
                    ]
                }])
                .populate([{path:'inspector_id', select:['first_name','last_name']}])
                .populate([{path:'created_by', select:['first_name','last_name']}])
                .populate([{path:'updated_by', select:['first_name','last_name']}])
                .sort([["createdAt",-1]]);
                res.send({is_error : false, data: report, metaData: {totalRecords: recordsCount , currentPage:1 , nextPage:'' , totalPage: 1 }});
            }
        }else{
            res.send({is_error : false, data: []});
        }
    } catch (error) {
        console.log(error);
        return res.send({"is_error": true , "message": "An error occured : " + error});
    }
  };

// Retrieve and return all reports by user id
exports.getReportsByUserId = async (req, res) => {
    try {
        // find all assigned projects of loggedin user
        let query = {is_deleted: false, 
            $or: [
                { 'assignedInspector': req.params.id },
                {'assignedManufacturers': req.params.id},
                {'assignedContractor': req.params.id},
                {'assignedOwner': req.params.id},
                {'created_by': req.params.id }
        ] } ;
        console.log("final Query", query)
        const projects = await projectModel.find(query)
        var projectIds = await projects.map(function (item) {
            return item['_id'];
          });
        if(projectIds && projectIds.length != 0){
            const report = await reportModel.find({is_deleted: false , projectId: {$in:projectIds}})
            .populate([{
                path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line'],
                populate: [{ path: 'assignedManufacturers', select:['first_name','last_name','company_name','email','role','company_logo'] }, 
                { path: 'assignedContractor', select:['first_name','last_name','company_name','email','role','company_logo'] },
                { path: 'assignedOwner', select:['first_name','last_name','company_name','email','role','company_logo'] },
                {path:'assignedForeman', select:['first_name','last_name','company_name', 'email','phone','company_logo']}
            ]
            }])
            .populate([{path:'inspector_id', select:['first_name','last_name']}])
            .populate([{path:'created_by', select:['first_name','last_name']}])
            .populate([{path:'updated_by', select:['first_name','last_name']}])
            .sort([["createdAt",-1]]);
            res.send({is_error : false, data: report});
        }else{
            res.send({is_error : false, data: []});
        }
    } catch (error) {
        console.log(error);
        return res.send({"is_error": true , "message": "An error occured : " + error});
    }
  };

// Find a single report details
exports.findOne = async (req, res) => {
    reportModel.findOne({_id:req.params.id, is_deleted:false})
    .populate([
        {
            path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line'],
            populate: [
            { path: 'assignedManufacturers', select:['first_name','last_name','company_name','email','role','company_logo'] }, 
            { path: 'assignedContractor', select:['first_name','last_name','company_name','email','role','company_logo'] },
            { path: 'assignedOwner', select:['first_name','last_name','company_name','email','role','company_logo'] },
            { path: 'assignedManager', select:['first_name','last_name','company_name','email','role','company_logo'] },
            {path:'assignedForeman', select:['first_name','last_name','company_name', 'email','phone','company_logo']}
        ],
            // populate: { path: 'assignedContractor', select:['first_name','last_name','company_name'] },
            // populate: { path: 'assignedOwner', select:['first_name','last_name','company_name'] }
        }
    ])
    .populate([{path:'inspector_id', select:['first_name','last_name']}])
    .populate([{path:'created_by', select:['first_name','last_name']}])
    .populate([{path:'updated_by', select:['first_name','last_name']}])
    .then(async response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.id
            });            
        }
        const projectMedia = await mediaModel.find({ref_id: req.params.id, deleted: false});
        // console.log("projectMedia", projectMedia);
        response.mediaFiles = projectMedia ;
        res.send({is_error : false, data: response, mediaFiles: projectMedia });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving report details with id " + req.params.id
        });
    });
};

// Update a Report Details
exports.update = (req, res) => {
    // console.log("req.body", req.files);
    // console.log("req.body", req.body)
    const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);

    if(!(req.body.existingFilesData)){
        // delete all uploaded report media files from directory
        const mediaRootPath = "public/uploads/reports/";
        const mediaKey = Object.keys(req.files);
        mediaKey.forEach(async key => {
            if (req.files[key].length && req.files[key].length > 0) {
                // multiple files
                const projectMediaFiles = req.files[key];
                await projectMediaFiles.forEach(async mediaFile => {
                    // call util method to remove file from location
                    mediaUtils.unlink(mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename);
                })
            }
        })
        return res.status(400).send({ "is_error": true, "message": "Please provide exiting files data." });
    }
    if(req.files && req.files.length != 0){
        if(!req.body.filesMetaData){
            // delete all uploaded report media files from directory
            const mediaRootPath = "public/uploads/reports/";
            const mediaKey = Object.keys(req.files);
            mediaKey.forEach(async key => {
                if (req.files[key].length && req.files[key].length > 0) {
                    // multiple files
                    const projectMediaFiles = req.files[key];
                    await projectMediaFiles.forEach(async mediaFile => {
                        // call util method to remove file from location
                        mediaUtils.unlink(mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename);
                    })
                }
            })
            return res.status(400).send({ "is_error": true, "message": "Please choose files & provide files meta data" });
        }
    }
    const payload = {
      report_title: req.body.report_title,
      onsite_material_confirmed: req.body.onsite_material_confirmed,
      inspection_date: req.body.inspection_date,
      weather: req.body.weather,
      crew_size: req.body.crew_size,
      area_completed_onday: req.body.area_completed_onday,
      completion_percentage: req.body.completion_percentage,
      forecasted_completion_date: req.body.forecasted_completion_date,
      work_description: req.body.work_description,
      additional_remark: req.body.additional_remark ? req.body.additional_remark : '',
      inspector_id: loggedInUser.data.user_id,
      updated_by: loggedInUser.data.user_id,
    };
    const filesMetaData = JSON.parse(req.body.filesMetaData);
    const existingFilesData = JSON.parse(req.body.existingFilesData);

     console.log("filesMetaData",filesMetaData);
     console.log("existingFilesData", existingFilesData)
    // Find report and update it with the request body
    reportModel.findByIdAndUpdate(req.params.id, payload , {new: true})
    .then(async response => {
        let media = [];
        const mediaRootPath = "public/uploads/reports/";
        const mediaKey = Object.keys(req.files);
        mediaKey.forEach(async key => {
            if (req.files[key].length && req.files[key].length > 0) {
                // multiple files
                const projectMediaFiles = req.files[key];
                await projectMediaFiles.forEach(async mediaFile => {
                 const filedesc = await filesMetaData.filter (item => { return item.customFile === mediaFile.originalname })
                    media.push({
                        path: mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename,
                        filename: mediaFile.filename,
                        userGivenName: filedesc.length > 0 ? filedesc[0].userGivenName : mediaFile.filename,
                        ref_id: response._id,
                        type: mediaFile.fieldname,
                        mimetype: mediaFile.mimetype,
                        description: filedesc.length > 0 ? filedesc[0].description : '',
                        extn: (mediaFile.filename.split('.').pop()).toLowerCase(),
                        secquence: (filedesc.length > 0 && filedesc[0].secquence) ? filedesc[0].secquence : 0

                    });
                })

            } else {
                console.log("Else condition block")
            }
        })

        if(!response) {
            // remove all recently uploaded images from directory
            media.forEach(element => {
                mediaUtils.unlink(element.path);
            });
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.id
            });
        }
        // store all images,documents and videos
        await mediaModel.insertMany(media);
        // Remove all the removed media from directory and Media Collection
        if (req.body.existingFilesData) {
            const filesTobeRemoved = JSON.parse(req.body.existingFilesData);
            await filesTobeRemoved.forEach(element => {
                if(element.deleted){
                    mediaUtils.unlink(element.path);
                    // delete record from Media collection
                    mediaModel.findByIdAndUpdate(element._id,element).exec();
                }else{
                    // only update the records with updated data of description
                    mediaModel.findByIdAndUpdate(element._id,element).exec();
                }
            });
        }
        res.send( { is_error : false, data: response });
    }).catch(err => {
        // delete all uploaded project media files from directory
        const mediaRootPath = "public/uploads/reports/";
        const mediaKey = Object.keys(req.files);
        mediaKey.forEach(async key => {
            if (req.files[key].length && req.files[key].length > 0) {
                // multiple files
                const projectMediaFiles = req.files[key];
                await projectMediaFiles.forEach(async mediaFile => {
                    // call util method to remove file from location
                    mediaUtils.unlink(mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename);
                })
            }
        })

        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error updating Report details with id " + err
        });
    });
};

// Delete a report with the specified id in the request
exports.delete = (req, res) => {
    // reportModel.findByIdAndRemove(req.params.id)
    reportModel.findByIdAndUpdate(req.params.id, {is_deleted: true})
    .then(responseData => {
        if(!responseData) {
            return res.status(404).send({
                is_error : true,
                message: "Report Details not found with id " + req.params.id
            });
        }
        res.send({is_error : false, message: "Report deleted successfully!"});
    }).catch(err => {
        if(err.kind === 'ObjectId' || err.name === 'NotFound') {
            return res.status(404).send({
                is_error : true,
                message: "Report Details not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Could not delete Report with id " + req.params.id
        });
    });
};

// Change project status
exports.changeStatus = async (req, res) => {
    const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);

    await reportModel.findByIdAndUpdate(req.params.projectId, {
        is_active: req.body.is_active,
        updated_by: loggedInUser.data.user_id
    }, { new: true })
        .then(projectData => {
            if (!projectData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Invalid Project Details."
                });
            }
            const notifyMsg = req.body.is_active ? 'Opened' : 'Closed';
            res.send({'message': 'Project has been marked as' +' '+ notifyMsg });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Project details not found with provided Id."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating the project status."
            });
        });
};


// Email Report to Selected users
exports.sendReport = async (req, res) => {
    console.log("req.body", req.body)
    if(!req.body.id){
        return res.status(400).send({ "is_error": true, "message": "Please select the correct report." });
    }
    if(req.body.to_users && req.body.to_users.length == 0){
        return res.status(400).send({ "is_error": true, "message": "Please select the email recipient" });
    }
    reportModel.findOne({_id:req.body.id})
    .populate([
        {
            path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line','total_size'],
            populate: { path: 'assignedOwner', select:['first_name','last_name','company_name','company_logo'] }
        }
    ])
    .populate([{path:'inspector_id', select:['first_name','last_name']}])
    .populate([{path:'created_by', select:['first_name','last_name']}])
    .populate([{path:'updated_by', select:['first_name','last_name']}])
    .then(async response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.body.id
            });            
        }
    let inspection_photos = await mediaModel.find({ref_id: req.body.id, deleted: false,type:'inspection_photos' });
    let inspection_videos = await mediaModel.find({ref_id: req.body.id, deleted: false,type:'inspection_videos' });
    let inspection_documents = await mediaModel.find({ref_id: req.body.id, deleted: false,type:'supporting_documents'});
    const google_earth = await mediaModel.find({ref_id: req.body.id, deleted: false,type:'google_earth'});

    inspection_photos =  inspection_photos.map(item=>{
        item.path = process.env.PUBLIC_BASE_URL+ '/' + item.path ;
        return item ;
    })
    inspection_videos =  inspection_videos.map(item=>{
        item.path = process.env.PUBLIC_BASE_URL+ '/' + item.path ;
        return item ;
    })
    inspection_documents =  inspection_documents.map(item=>{
        item.path = process.env.PUBLIC_BASE_URL+ '/' + item.path ;
        return item ;
    })

    var userEmails = await req.body.to_users.map(function (user) {
        return user['email'];
      });
    userEmails.push('shivam201065@gmail.com')
    console.log("userEmails", userEmails)
    //  Write code to send email to users 
    const mailTemplateContent = {
        // "subject":"OPM Report-"+ response.projectId.name + '- ' + moment(response.inspection_date).format('DD/MM/YYYY'),
        "subject": req.body.email_subject,
        "email_message": req.body.email_message ? (req.body.email_message).replace(/(?:\r\n|\r|\n)/g, '<br>') : '',
        "report_name": response.report_title,
        "inspection_date": moment(response.inspection_date).format('MM/DD/YYYY'),
        "material_confirmed": response.onsite_material_confirmed ? 'CONFIRMED' : 'UNCONFIRMED',
        "crew_size":response.crew_size,
        "area_completed_onday": parseInt(response.area_completed_onday).toLocaleString(),
        "weather_condition":response.weather,
        "percentage_completion":response.completion_percentage,
        "report_description": response.work_description,
        "remarks":response.additional_remark,
        "documents_count":inspection_documents.length,
        "inspection_photos_count": inspection_photos.length,
        "inspection_video_count": inspection_videos.length,
        "google_photo_url":google_earth.length >0 ? process.env.PUBLIC_BASE_URL + '/' + google_earth[0].path : '',
        "project_id":response.projectId._id,
        "project_name": response.projectId.name,
        "location": response.projectId.address_line + '  ' + response.projectId.city +  '  ' + response.projectId.state ,
        "project_size":parseInt(response.projectId.total_size).toLocaleString() ,
        "start_date": moment(response.project_start_date).format('MM/DD/YYYY'),
        "inspection_photos": inspection_photos ,
        "inspection_videos": inspection_videos,
        "inspection_documents": inspection_documents,
        "report_url": process.env.WEBSITE_URL + '/inspection/details/'+  response.projectId?._id,
        "communication_message_link": process.env.WEBSITE_URL + '/inspection/communication/' + response._id
        // "google_photo_url":'https://roofinspections.report:30003/public/uploads/reports/google_earth/google_earth-1681492025695-zVYdppoVDEzuYJ8elEKAJ1'
    }
 console.log("mailTemplateContent ", mailTemplateContent)
    const emailData = {
        msg: {
            to: userEmails,
            from: process.env.SUPPORT_EMAIL, // Use the email address or domain you verified above
            template_id: email_templates.REPORT_PROGRESS_SUMMARY,
            dynamic_template_data: mailTemplateContent
          },
        userDetails: {}
    }
    // send Email to User with report details.
    emailCtrl.sendEmail(emailData);
    // Update report to archived list
    const querySucess = await reportModel.updateOne({_id:req.body.id}, {$set:{is_archived: true}}, { timestamps: false }).exec();

    res.send({is_error : false, data: response });
    }).catch(err => {
        console.log("error", err)
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.body.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving report details with id " + req.body.id
        });
    });
};

exports.getProjectStackeholders = async ( req, res) => {
    reportModel.findOne({_id:req.params.id, is_deleted:false})
    .populate([
        {
            path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line'],
            populate: [
                { path: 'assignedManufacturers', select:['first_name','last_name','company_name','email','role','company_logo'] }, 
                { path: 'assignedContractor', select:['first_name','last_name','company_name','email','role','company_logo'] },
                { path: 'assignedOwner', select:['first_name','last_name','company_name','email','role','company_logo'] },
                { path: 'assignedManager', select:['first_name','last_name','company_name','email','role','company_logo'] },
                {path:'assignedForeman', select:['first_name','last_name','company_name', 'email','phone','company_logo']}
            ],
        }
    ])
    .then(async response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.id
            });            
        }
        const ownerList = (response && response.projectId) ? response.projectId.assignedOwner : null;
        const contractorList = (response && response.projectId) ? response.projectId.assignedContractor : null;
        const manufacturerList = (response && response.projectId) ? response.projectId.assignedManufacturers : [];
        const managerList = (response && response.projectId && response.projectId.assignedManager ) ? response.projectId.assignedManager : [];
        let allStakeholderList = [...manufacturerList];
        if(ownerList != null){allStakeholderList.push(ownerList);}
        if(contractorList != null){allStakeholderList.push(contractorList);}
        console.log("allStakeholderList", allStakeholderList)
        res.send({is_error : false, data: allStakeholderList });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving report details with id " + req.params.id
        });
    });
}

// Download report as PDF

exports.downloadReport = async (req, res) => {
    console.log("req.body", req.body)
    if(!req.params.reportId){
        return res.status(400).send({ "is_error": true, "message": "Please select the correct report." });
    }

    reportModel.findOne({_id:req.params.reportId})
    .populate([
        {
            path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line','total_size'],
            populate: { path: 'assignedOwner', select:['first_name','last_name','company_name'] }
        }
    ])
    .populate([{path:'inspector_id', select:['first_name','last_name']}])
    .populate([{path:'created_by', select:['first_name','last_name']}])
    .populate([{path:'updated_by', select:['first_name','last_name']}])
    .then(async response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.reportId
            });            
        }
    let inspection_photos = await mediaModel.find({ref_id: req.params.reportId, deleted: false,type:'inspection_photos' });
    let inspection_videos = await mediaModel.find({ref_id: req.params.reportId, deleted: false,type:'inspection_videos' });
    let inspection_documents = await mediaModel.find({ref_id: req.params.reportId, deleted: false,type:'supporting_documents'});
    const google_earth = await mediaModel.find({ref_id: req.params.reportId, deleted: false,type:'google_earth'});

    inspection_photos = await inspection_photos.map(item=>{
        // item.path = process.env.PUBLIC_BASE_URL+ '/' + item.path ;
        item['base64Image'] = "data:image/gif;base64,"+fs.readFileSync('./' + item.path, 'base64')
        return item ;
    })
    inspection_videos =  await inspection_videos.map(item=>{
        item.path = process.env.PUBLIC_BASE_URL+ '/' + item.path ;
        return item ;
    })
    inspection_documents =  await inspection_documents.map(item=>{
        item.path = process.env.PUBLIC_BASE_URL+ '/' + item.path ;
        return item ;
    })

    console.log("Inspection Photos base64 data", inspection_photos)
    //  Write code to send email to users 
    const mailTemplateContent = {
        "inspection_date": moment(response.inspection_date).format('MM/DD/YYYY'),
        "material_confirmed": response.onsite_material_confirmed ? 'CONFIRMED' : 'UNCONFIRMED',
        "crew_size":response.crew_size,
        "area_completed_onday": parseInt(response.area_completed_onday).toLocaleString(),
        "weather_condition":response.weather,
        "percentage_completion":response.completion_percentage,
        "report_description": response.work_description,
        "remarks":response.additional_remark,
        "documents_count":inspection_documents.length,
        "inspection_photos_count": inspection_photos.length,
        "inspection_video_count": inspection_videos.length,
        "google_photo_url":google_earth.length >0 ? "data:image/gif;base64,"+fs.readFileSync('./' + google_earth[0].path, 'base64') : '',
        "project_id":response.projectId._id,
        "project_name": response.projectId.name,
        "location": response.projectId.address_line + '  ' + response.projectId.city +  '  ' + response.projectId.state ,
        "project_size":parseInt(response.projectId.total_size).toLocaleString() ,
        "start_date": moment(response.project_start_date).format('MM/DD/YYYY'),
        "inspection_photos": inspection_photos ,
        "inspection_videos": inspection_videos,
        "inspection_documents": inspection_documents,
        "report_url": process.env.WEBSITE_URL,
        "report_title": response.report_title
    }
    
    console.log("mailTemplateContent ", mailTemplateContent)
    const htmlReportTemplate = `
    <html>
        <head>
            <title></title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
            <meta name="viewport" content="width=device-width, initial-scale=1">
                <meta http-equiv="X-UA-Compatible" content="IE=edge" />
                <style type="text/css">
                /* CLIENT-SPECIFIC STYLES */
                    body,
                    table,
                    td,
                    a {
                        -webkit - text - size - adjust: 100%;
                    -ms-text-size-adjust: 100%;
                }

                    table,
                    td {
                        mso - table - lspace: 0pt;
                    mso-table-rspace: 0pt;
                }

                    img {
                        -ms - interpolation - mode: bicubic;
                }

                    /* RESET STYLES */
                    img {
                        border: 0;
                    height: auto;
                    line-height: 100%;
                    outline: none;
                    text-decoration: none;
                }

                    table {
                        border - collapse: collapse !important;
                }

                    body {
                        height: 100% !important;
                    margin: 0 !important;
                    padding: 0 !important;
                    width: 100% !important;
                }

                    /* iOS BLUE LINKS */
                    a[x-apple-data-detectors] {
                        color: inherit !important;
                    text-decoration: none !important;
                    font-size: inherit !important;
                    font-family: inherit !important;
                    font-weight: inherit !important;
                    line-height: inherit !important;
                }

                    /* MOBILE STYLES */
                    @media screen and (max-width:600px) {
                        h1 {
                        font - size: 32px !important;
                    line-height: 32px !important;
                    }
                }

                    /* ANDROID CENTER FIX */
                    div[style*="margin: 16px 0;"] {
                        margin: 0 !important;
                }

                    .btn {
                        display: inline-block;
                    font-weight: 400;
                    color: #212529;
                    text-align: center;
                    vertical-align: middle;
                    -webkit-user-select: none;
                    -moz-user-select: none;
                    -ms-user-select: none;
                    user-select: none;
                    background-color: transparent;
                    border: 1px solid transparent;
                    border-top-color: transparent;
                    border-top-width: 1px;
                    border-right-color: transparent;
                    border-right-width: 1px;
                    border-bottom-color: transparent;
                    border-bottom-width: 1px;
                    border-left-color: transparent;
                    border-left-width: 1px;
                    padding: .375rem .75rem;
                    font-size: 1rem;
                    line-height: 1.5;
                    border-radius: .25rem;
                    transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
                }

                    .btn.btn-flat {
                        border - radius: 0;
                    border-width: 1px;
                    box-shadow: none;
                }

                    .btn-dark {
                        color: #fff;
                    background-color: #343a40;
                    border-color: #343a40;
                    box-shadow: none;
                }

                    .btn-block {
                        display: block;
                    width: 100%;
                }
                </style>
        </head>
        <body style="background-color: #f4f4f4; margin: 0 !important; padding: 0 !important;">
            <!-- HIDDEN PREHEADER TEXT -->
            <div
                style="display: none; font-size: 1px; color: #fefefe; line-height: 1px; font-family: 'Lato', Helvetica, Arial, sans-serif; max-height: 0px; max-width: 0px; opacity: 0; overflow: hidden;">
                Project progress report has been submited by inspector</div>
            <table border="0" cellpadding="0" cellspacing="0" width="100%">
                <!-- LOGO -->
                <tr>
                    <td bgcolor="#27316f" align="center">
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tr>
                                <td align="left" valign="top" style="padding: 10px 10px 10px 10px;">
                                    <img src="http://cdn.mcauto-images-production.sendgrid.net/0b2eb67a10355746/58d55aef-9e6b-4aa8-8c0b-adae64ab4070/217x80.png"
                                        width="100" height="90" style="display: block; border: 0px;" />
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td bgcolor="#e21e25" align="center" style="padding: 0px 10px 0px 10px;">
                        <table class="wrapper" role="module" data-type="image" border="0" cellpadding="0" cellspacing="0"
                            width="100%" style="table-layout: fixed;" data-muid="3Ypdby9Xfsf2rN27zTDEfN">
                            <tbody>
                                <tr>
                                    <td style="font-size:6px; line-height:10px; padding:0px 0px 0px 0px;" valign="top"
                                        align="center">
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tr>
                                <td bgcolor="#ffffff" align="center" valign="top"
                                    style="padding: 30px; border-radius: 4px 4px 0px 0px; color: #111111; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 20px; font-weight: 400; letter-spacing: 4px; line-height: 5px;">
                                    <h1 style="font-size: 22px; color: #27316f">${mailTemplateContent.report_title}</h1>
                                    <p style="font-size:14px">${mailTemplateContent.project_name}</p>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td bgcolor="#f4f4f4" align="center" style="padding: 0px 10px 0px 10px;">
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tr>
                                <td bgcolor="#ffffff" align="left"
                                    style="padding: 20px 30px 40px 30px; color: #666666; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 14px; font-weight: 400; line-height: 25px;">

                                    <p style="margin: 0;">
                                        ${mailTemplateContent.report_description}
                                    </p>
                                    <h5>Prepared For :</h5>
                                    <ul style="list-style:none">
                                        <li>
                                            <strong style="color:#27316f;">Project Name :</strong>
                                            <span style="margin-left:5px">${mailTemplateContent.project_name}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Start Date :</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.start_date}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Location :</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.location}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Project Size :</strong>
                                            <span style="margin-left:5px">
                                                Approximately  ${mailTemplateContent.project_size} Square Feet.
                                            </span>
                                        </li>
                                    </ul>
                                    <h5>Inspection Details:</h5>
                                    <ul style="list-style:none">
                                        <li>
                                            <strong style="color:#27316f;">Inspection Date:</strong>
                                            <span style="margin-left:5px"> ${mailTemplateContent.inspection_date}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Specified Material on Site:</strong>
                                            <span style="margin-left:5px">  ${mailTemplateContent.material_confirmed}.
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Crew Size :</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.crew_size}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Project Area Completed during Inspection :</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.area_completed_onday} Square Feet
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Weather Condition:</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.weather_condition}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Completion Progress :</strong>
                                            ${mailTemplateContent.percentage_completion}%
                                        </li>
                                    </ul>
                                    <p><strong>Comments: </strong>${mailTemplateContent.remarks}</p>
                                    <p>View Detailed progress projects report online at
                                        <a href="${mailTemplateContent.report_url}">${mailTemplateContent.report_url}</a>
                                    </p>
                                    <p style="text-align: center">
                                        <a href="${mailTemplateContent.report_url}" class="btn btn-flat btn-dark">View Detailed Progres Report</a>
                                    </p>
                                    <h5>Google Earth Photo :</h5>
                                    <img class="max-width" border="0"
                                        style="display:block; color:#000000; text-decoration:none; font-family:Helvetica, arial, sans-serif; font-size:16px; max-width:100% !important; width:100%; height:auto !important;"
                                        src="${mailTemplateContent.google_photo_url}" alt="" width="600" data-responsive="true"
                                        data-proportionally-constrained="false" />
                                    <h5>Inspection Photos :</h5>
                                    <ul style="list-style:none;">
                                        ${mailTemplateContent.inspection_photos.map(item =>
                                            `<li style="float:left; padding:5px; border:0.5px solid #ccc; width:200px; margin:5px">
                                                    <img style="display:block;  width:100%; height:200px" src=${item.base64Image}>
                                                    <p> ${item.description}</p>
                                                </li>`
                                        )}
                                    </ul>
                                </td>
                            </tr>
                            <tr>
                            </tr>
                        </tr>
                        <tr>
                            <td bgcolor="#f4f4f4" align="center" style="padding: 30px 10px 0px 10px;">
                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <tr>
                                        <td bgcolor="#fff" align="center"
                                            style="padding: 30px 30px 30px 30px; border-radius: 4px 4px 4px 4px; color: #666666; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 18px; font-weight: 400; line-height: 25px;">
                                            <h2 style="font-size: 18px; font-weight: 400; color: #27316f; margin: 0;">Need more help?
                                            </h2>
                                            <p style="margin: 0;"><a href="https://roofinspections.report" target="_blank"
                                                style="color: #e21e25;">We&rsquo;re here to help you out</a></p>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td bgcolor="#f4f4f4" align="center" style="padding: 0px 10px 0px 10px;">
                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <tr>
                                        <td bgcolor="#f4f4f4" align="left"
                                            style="text-align: center; padding: 0px 30px 30px 30px; color: #666666; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 14px; font-weight: 400; line-height: 18px;">
                                            <br>
                                                RoofInspections® is a Registered Trademark of and Copyright© 2023-2024 roofingprojects.com.
                                                All Rights Reserved.</p>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </body>

    </html>
   `;
    const fileNamePrefix = Date.now();       
    var options = { format: 'Letter' };
    pdf.create(htmlReportTemplate, options).toFile('./'+fileNamePrefix+ '_reports.pdf', function(err, data) {
        if (err) return console.log(err);
        console.log(data); // { filename: '/app/businesscard.pdf' }
        // return res.send(200)
        res.download(data.filename, (err) => {
            if (err) {
              console.log(err); // Check error if you want
            }
            fs.unlink(data.filename, function(){
                console.log("File was deleted") // Callback
            });
          })
      });
    }).catch(err => {
        console.log("error", err)
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.reportId
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving report details with id " + req.params.reportId
        });
    });
};

exports.downloadReportApp = async (req, res) => {
    console.log("req.body", req.body)
    if(!req.params.reportId){
        return res.status(400).send({ "is_error": true, "message": "Please select the correct report." });
    }

    reportModel.findOne({_id:req.params.reportId})
    .populate([
        {
            path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line','total_size'],
            populate: { path: 'assignedOwner', select:['first_name','last_name','company_name'] }
        }
    ])
    .populate([{path:'inspector_id', select:['first_name','last_name']}])
    .populate([{path:'created_by', select:['first_name','last_name']}])
    .populate([{path:'updated_by', select:['first_name','last_name']}])
    .then(async response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.reportId
            });            
        }
    let inspection_photos = await mediaModel.find({ref_id: req.params.reportId, deleted: false,type:'inspection_photos' });
    let inspection_videos = await mediaModel.find({ref_id: req.params.reportId, deleted: false,type:'inspection_videos' });
    let inspection_documents = await mediaModel.find({ref_id: req.params.reportId, deleted: false,type:'supporting_documents'});
    const google_earth = await mediaModel.find({ref_id: req.params.reportId, deleted: false,type:'google_earth'});

    inspection_photos = await inspection_photos.map(item=>{
        // item.path = process.env.PUBLIC_BASE_URL+ '/' + item.path ;
        item['base64Image'] = "data:image/gif;base64,"+fs.readFileSync('./' + item.path, 'base64')
        return item ;
    })
    inspection_videos =  await inspection_videos.map(item=>{
        item.path = process.env.PUBLIC_BASE_URL+ '/' + item.path ;
        return item ;
    })
    inspection_documents =  await inspection_documents.map(item=>{
        item.path = process.env.PUBLIC_BASE_URL+ '/' + item.path ;
        return item ;
    })

    //  Write code to send email to users 
    const mailTemplateContent = {
        "inspection_date": moment(response.inspection_date).format('MM/DD/YYYY'),
        "material_confirmed": response.onsite_material_confirmed ? 'CONFIRMED' : 'UNCONFIRMED',
        "crew_size":response.crew_size,
        "area_completed_onday": parseInt(response.area_completed_onday).toLocaleString(),
        "weather_condition":response.weather,
        "percentage_completion":response.completion_percentage,
        "report_description": response.work_description,
        "remarks":response.additional_remark,
        "documents_count":inspection_documents.length,
        "inspection_photos_count": inspection_photos.length,
        "inspection_video_count": inspection_videos.length,
        "google_photo_url":google_earth.length >0 ? "data:image/gif;base64,"+fs.readFileSync('./' + google_earth[0].path, 'base64') : '',
        "project_id":response.projectId._id,
        "project_name": response.projectId.name,
        "location": response.projectId.address_line + '  ' + response.projectId.city +  '  ' + response.projectId.state ,
        "project_size":parseInt(response.projectId.total_size).toLocaleString() ,
        "start_date": moment(response.project_start_date).format('MM/DD/YYYY'),
        "inspection_photos": inspection_photos ,
        "inspection_videos": inspection_videos,
        "inspection_documents": inspection_documents,
        "report_url": process.env.WEBSITE_URL,
        "report_title": response.report_title
    }
    
    console.log("mailTemplateContent ", mailTemplateContent)
    const htmlReportTemplate = `
    <html>
        <head>
            <title></title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
            <meta name="viewport" content="width=device-width, initial-scale=1">
                <meta http-equiv="X-UA-Compatible" content="IE=edge" />
                <style type="text/css">
                /* CLIENT-SPECIFIC STYLES */
                    body,
                    table,
                    td,
                    a {
                        -webkit - text - size - adjust: 100%;
                    -ms-text-size-adjust: 100%;
                }

                    table,
                    td {
                        mso - table - lspace: 0pt;
                    mso-table-rspace: 0pt;
                }

                    img {
                        -ms - interpolation - mode: bicubic;
                }

                    /* RESET STYLES */
                    img {
                        border: 0;
                    height: auto;
                    line-height: 100%;
                    outline: none;
                    text-decoration: none;
                }

                    table {
                        border - collapse: collapse !important;
                }

                    body {
                        height: 100% !important;
                    margin: 0 !important;
                    padding: 0 !important;
                    width: 100% !important;
                }

                    /* iOS BLUE LINKS */
                    a[x-apple-data-detectors] {
                        color: inherit !important;
                    text-decoration: none !important;
                    font-size: inherit !important;
                    font-family: inherit !important;
                    font-weight: inherit !important;
                    line-height: inherit !important;
                }

                    /* MOBILE STYLES */
                    @media screen and (max-width:600px) {
                        h1 {
                        font - size: 32px !important;
                    line-height: 32px !important;
                    }
                }

                    /* ANDROID CENTER FIX */
                    div[style*="margin: 16px 0;"] {
                        margin: 0 !important;
                }

                    .btn {
                        display: inline-block;
                    font-weight: 400;
                    color: #212529;
                    text-align: center;
                    vertical-align: middle;
                    -webkit-user-select: none;
                    -moz-user-select: none;
                    -ms-user-select: none;
                    user-select: none;
                    background-color: transparent;
                    border: 1px solid transparent;
                    border-top-color: transparent;
                    border-top-width: 1px;
                    border-right-color: transparent;
                    border-right-width: 1px;
                    border-bottom-color: transparent;
                    border-bottom-width: 1px;
                    border-left-color: transparent;
                    border-left-width: 1px;
                    padding: .375rem .75rem;
                    font-size: 1rem;
                    line-height: 1.5;
                    border-radius: .25rem;
                    transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
                }

                    .btn.btn-flat {
                        border - radius: 0;
                    border-width: 1px;
                    box-shadow: none;
                }

                    .btn-dark {
                        color: #fff;
                    background-color: #343a40;
                    border-color: #343a40;
                    box-shadow: none;
                }

                    .btn-block {
                        display: block;
                    width: 100%;
                }
                </style>
        </head>
        <body style="background-color: #f4f4f4; margin: 0 !important; padding: 0 !important;">
            <!-- HIDDEN PREHEADER TEXT -->
            <div
                style="display: none; font-size: 1px; color: #fefefe; line-height: 1px; font-family: 'Lato', Helvetica, Arial, sans-serif; max-height: 0px; max-width: 0px; opacity: 0; overflow: hidden;">
                Project progress report has been submited by inspector</div>
            <table border="0" cellpadding="0" cellspacing="0" width="100%">
                <!-- LOGO -->
                <tr>
                    <td bgcolor="#27316f" align="center">
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tr>
                                <td align="left" valign="top" style="padding: 10px 10px 10px 10px;">
                                    <img src="http://cdn.mcauto-images-production.sendgrid.net/0b2eb67a10355746/58d55aef-9e6b-4aa8-8c0b-adae64ab4070/217x80.png"
                                    width="100" height="90" style="display: block; border: 0px;" />
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td bgcolor="#e21e25" align="center" style="padding: 0px 10px 0px 10px;">
                        <table class="wrapper" role="module" data-type="image" border="0" cellpadding="0" cellspacing="0"
                            width="100%" style="table-layout: fixed;" data-muid="3Ypdby9Xfsf2rN27zTDEfN">
                            <tbody>
                                <tr>
                                    <td style="font-size:6px; line-height:10px; padding:0px 0px 0px 0px;" valign="top"
                                        align="center">
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tr>
                                <td bgcolor="#ffffff" align="center" valign="top"
                                    style="padding: 30px; border-radius: 4px 4px 0px 0px; color: #111111; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 48px; font-weight: 400; letter-spacing: 4px; line-height: 18px;">
                                    <h1 style="font-size: 20px; color: #27316f">${mailTemplateContent.report_title}</h1>
                                    <p style="font-size:14px">${mailTemplateContent.project_name}</p>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td bgcolor="#f4f4f4" align="center" style="padding: 0px 10px 0px 10px;">
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tr>
                                <td bgcolor="#ffffff" align="left"
                                    style="padding: 20px 30px 40px 30px; color: #666666; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 14px; font-weight: 400; line-height: 25px;">

                                    <p style="margin: 0;">
                                        ${mailTemplateContent.report_description}
                                    </p>
                                    <h5>Prepared For :</h5>
                                    <ul style="list-style:none">
                                        <li>
                                            <strong style="color:#27316f;">Project Name :</strong>
                                            <span style="margin-left:5px">${mailTemplateContent.project_name}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Start Date :</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.start_date}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Location :</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.location}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Project Size :</strong>
                                            <span style="margin-left:5px">
                                                Approximately  ${mailTemplateContent.project_size} Square Feet.
                                            </span>
                                        </li>
                                    </ul>
                                    <h5>Inspection Details:</h5>
                                    <ul style="list-style:none">
                                        <li>
                                            <strong style="color:#27316f;">Inspection Date:</strong>
                                            <span style="margin-left:5px"> ${mailTemplateContent.inspection_date}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Specified Material on Site:</strong>
                                            <span style="margin-left:5px">  ${mailTemplateContent.material_confirmed}.
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Crew Size :</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.crew_size}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Project Area Completed during Inspection :</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.area_completed_onday} Square Feet
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Weather Condition:</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.weather_condition}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Completion Progress :</strong>
                                            ${mailTemplateContent.percentage_completion}%
                                        </li>
                                    </ul>
                                    <p><strong>Comments: </strong>${mailTemplateContent.remarks}</p>
                                    <p>View Detailed progress projects report online at
                                        <a href="${mailTemplateContent.report_url}">${mailTemplateContent.report_url}</a>
                                    </p>
                                    <p style="text-align: center">
                                        <a href="${mailTemplateContent.report_url}" class="btn btn-flat btn-dark">View Detailed Progres Report</a>
                                    </p>
                                    <h5>Google Earth Photo :</h5>
                                    <img class="max-width" border="0"
                                        style="display:block; color:#000000; text-decoration:none; font-family:Helvetica, arial, sans-serif; font-size:16px; max-width:100% !important; width:100%; height:auto !important;"
                                        src="${mailTemplateContent.google_photo_url}" alt="" width="600" data-responsive="true"
                                        data-proportionally-constrained="false" />
                                    <h5>Inspection Photos :</h5>
                                    <ul style="list-style:none;">
                                        ${mailTemplateContent.inspection_photos.map(item =>
                                            `<li style="float:left; padding:5px; border:0.5px solid #ccc; width:200px; margin:5px">
                                                    <img style="display:block;  width:100%; height:200px" src=${item.base64Image}>
                                                    <p> ${item.description}</p>
                                                </li>`
                                        )}
                                    </ul>
                                </td>
                            </tr>
                            <tr>
                            </tr>
                        <tr>
                            <td bgcolor="#f4f4f4" align="center" style="padding: 30px 10px 0px 10px;">
                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <tr>
                                        <td bgcolor="#fff" align="center"
                                            style="padding: 30px 30px 30px 30px; border-radius: 4px 4px 4px 4px; color: #666666; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 18px; font-weight: 400; line-height: 25px;">
                                            <h2 style="font-size: 18px; font-weight: 400; color: #27316f; margin: 0;">Need more help?
                                            </h2>
                                            <p style="margin: 0;"><a href="https://roofinspections.report" target="_blank"
                                                style="color: #e21e25;">We&rsquo;re here to help you out</a></p>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td bgcolor="#f4f4f4" align="center" style="padding: 0px 10px 0px 10px;">
                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <tr>
                                        <td bgcolor="#f4f4f4" align="left"
                                            style="text-align: center; padding: 0px 30px 30px 30px; color: #666666; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 14px; font-weight: 400; line-height: 18px;">
                                            <br>
                                                RoofInspections® is a Registered Trademark of and Copyright© 2023-2024 roofingprojects.com.
                                                All Rights Reserved.</p>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </body>

    </html>
   `;
    
    const fileNamePrefix = Date.now();    
    const fileDir = path.resolve('./public/uploads/reportPdf/' + fileNamePrefix + '_reports.pdf') 

    var options = { format: 'Letter' };
    pdf.create(htmlReportTemplate, options).toFile(fileDir, function(err, data) {
        if (err) return console.log(err);
        console.log(data); // { filename: '/app/businesscard.pdf' }
        return res.send(
            {
            is_error : false, 
            basePath: data.filename ,
            path: process.env.PUBLIC_BASE_URL+ '/public/uploads/reportPdf/'+ fileNamePrefix + '_reports.pdf'});
      });
    }).catch(err => {
        console.log("error", err)
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.reportId
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving report details with id " + req.params.reportId
        });
    });
};

exports.cleanPdfDocument = async( req, res)=>{
    mediaUtils.unlink(req.body.basePath);
    return res.send({is_error:false , message: " Report document deleted successfully"})
}


exports.validateReportId = async (req, res) => {
    reportModel.findOne({_id:req.params.id, is_deleted:false})
    .then(async response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.id
            });            
        }
        
        res.send({is_error : false, data: response});
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving report details with id " + req.params.id
        });
    });
};