var mongoose = require('mongoose');

const reportModel = require('../model/reports');
const mediaModel = require('../model/reportsMedia');
const projectModel = require('../model/projects');

const emailCtrl = require('./email.controller');
const email_templates = require('../config/email_template_ids');

const helper = require('../middleware/_helper');
const mediaUtils = require("../config/unlinkMedia");
const moment = require('moment');
const path = require('path');


var fs = require('fs');
var pdf = require('html-pdf');

// Retrieve and return all reports for a project.
exports.findReportsByProjectId = async (req, res) => {
    try {
        // const report = await reportModel.find({is_deleted: false , projectId: req.params.id})
        // .populate([{
        //     path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line'],
        //     populate: [{ path: 'assignedManufacturers', select:['first_name','last_name','company_name','email','role','company_logo'] }, 
        //     { path: 'assignedContractor', select:['first_name','last_name','company_name','email','role','company_logo'] },
        //     { path: 'assignedOwner', select:['first_name','last_name','company_name','email','role','company_logo'] },
        //     {path:'assignedForeman', select:['first_name','last_name','company_name', 'email','phone','company_logo']}
        //     ]
        // }])
        // .populate([{path:'inspector_id', select:['first_name','last_name']}])
        // .populate([{path:'created_by', select:['first_name','last_name']}])
        // .populate([{path:'updated_by', select:['first_name','last_name']}])
        // .sort([["createdAt",-1]]);

        const report = await reportModel.aggregate([
            { $match: {is_deleted: false , projectId: mongoose.Types.ObjectId(req.params.id)} },
            {$sort: {"createdAt": -1}},
            {
            $lookup: {
                from: 'reportmedia_files',
                localField: '_id',
                foreignField: 'ref_id',
                // pipeline:[{"$match":{"deleted":false}}],
                as: 'media'
            },}
        ]);
        console.log("reports", report)
        res.send({is_error : false, data: report});
    } catch (error) {
        console.log(error);
        return res.send({"is_error": true , "message": "An error occured : " + error});
    }
  };

// Find a single report details
exports.findOne = async (req, res) => {
    reportModel.findOne({_id:req.params.id, is_deleted:false})
    .populate([
        {
            path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line'],
            populate: [
            { path: 'assignedManufacturers', select:['first_name','last_name','company_name','email','role','company_logo'] }, 
            { path: 'assignedContractor', select:['first_name','last_name','company_name','email','role','company_logo'] },
            { path: 'assignedOwner', select:['first_name','last_name','company_name','email','role','company_logo'] },
            { path: 'assignedManager', select:['first_name','last_name','company_name','email','role','company_logo'] },
            {path:'assignedForeman', select:['first_name','last_name','company_name', 'email','phone','company_logo']}
        ],
            // populate: { path: 'assignedContractor', select:['first_name','last_name','company_name'] },
            // populate: { path: 'assignedOwner', select:['first_name','last_name','company_name'] }
        }
    ])
    .populate([{path:'inspector_id', select:['first_name','last_name']}])
    .populate([{path:'created_by', select:['first_name','last_name']}])
    .populate([{path:'updated_by', select:['first_name','last_name']}])
    .then(async response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.id
            });            
        }
        const projectMedia = await mediaModel.find({ref_id: req.params.id, deleted: false});
        // console.log("projectMedia", projectMedia);
        response.mediaFiles = projectMedia ;
        res.send({is_error : false, data: response, mediaFiles: projectMedia });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving report details with id " + req.params.id
        });
    });
};

exports.getProjectStackeholders = async ( req, res) => {
    reportModel.findOne({_id:req.params.id, is_deleted:false})
    .populate([
        {
            path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line'],
            populate: [
                { path: 'assignedManufacturers', select:['first_name','last_name','company_name','email','role','company_logo'] }, 
                { path: 'assignedContractor', select:['first_name','last_name','company_name','email','role','company_logo'] },
                { path: 'assignedOwner', select:['first_name','last_name','company_name','email','role','company_logo'] },
                { path: 'assignedManager', select:['first_name','last_name','company_name','email','role','company_logo'] },
                {path:'assignedForeman', select:['first_name','last_name','company_name', 'email','phone','company_logo']}
            ],
        }
    ])
    .then(async response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.id
            });            
        }
        const ownerList = (response && response.projectId) ? response.projectId.assignedOwner : null;
        const contractorList = (response && response.projectId) ? response.projectId.assignedContractor : null;
        const manufacturerList = (response && response.projectId) ? response.projectId.assignedManufacturers : [];
        const managerList = (response && response.projectId && response.projectId.assignedManager ) ? response.projectId.assignedManager : [];
        let allStakeholderList = [...manufacturerList];
        if(ownerList != null){allStakeholderList.push(ownerList);}
        if(contractorList != null){allStakeholderList.push(contractorList);}
        console.log("allStakeholderList", allStakeholderList)
        res.send({is_error : false, data: allStakeholderList });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving report details with id " + req.params.id
        });
    });
}

// Download report as PDF

exports.downloadReport = async (req, res) => {
    console.log("req.body", req.body)
    if(!req.params.reportId){
        return res.status(400).send({ "is_error": true, "message": "Please select the correct report." });
    }

    reportModel.findOne({_id:req.params.reportId})
    .populate([
        {
            path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line','total_size'],
            populate: { path: 'assignedOwner', select:['first_name','last_name','company_name'] }
        }
    ])
    .populate([{path:'inspector_id', select:['first_name','last_name']}])
    .populate([{path:'created_by', select:['first_name','last_name']}])
    .populate([{path:'updated_by', select:['first_name','last_name']}])
    .then(async response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.reportId
            });            
        }
    let inspection_photos = await mediaModel.find({ref_id: req.params.reportId, deleted: false,type:'inspection_photos' });
    let inspection_videos = await mediaModel.find({ref_id: req.params.reportId, deleted: false,type:'inspection_videos' });
    let inspection_documents = await mediaModel.find({ref_id: req.params.reportId, deleted: false,type:'supporting_documents'});
    const google_earth = await mediaModel.find({ref_id: req.params.reportId, deleted: false,type:'google_earth'});

    inspection_photos = await inspection_photos.map(item=>{
        // item.path = process.env.PUBLIC_BASE_URL+ '/' + item.path ;
        item['base64Image'] = "data:image/gif;base64,"+fs.readFileSync('./' + item.path, 'base64')
        return item ;
    })
    inspection_videos =  await inspection_videos.map(item=>{
        item.path = process.env.PUBLIC_BASE_URL+ '/' + item.path ;
        return item ;
    })
    inspection_documents =  await inspection_documents.map(item=>{
        item.path = process.env.PUBLIC_BASE_URL+ '/' + item.path ;
        return item ;
    })

    console.log("Inspection Photos base64 data", inspection_photos)
    //  Write code to send email to users 
    const mailTemplateContent = {
        "inspection_date": moment(response.inspection_date).format('MM/DD/YYYY'),
        "material_confirmed": response.onsite_material_confirmed ? 'CONFIRMED' : 'UNCONFIRMED',
        "crew_size":response.crew_size,
        "area_completed_onday": parseInt(response.area_completed_onday).toLocaleString(),
        "weather_condition":response.weather,
        "percentage_completion":response.completion_percentage,
        "report_description": response.work_description,
        "remarks":response.additional_remark,
        "documents_count":inspection_documents.length,
        "inspection_photos_count": inspection_photos.length,
        "inspection_video_count": inspection_videos.length,
        "google_photo_url":google_earth.length >0 ? "data:image/gif;base64,"+fs.readFileSync('./' + google_earth[0].path, 'base64') : '',
        "project_id":response.projectId._id,
        "project_name": response.projectId.name,
        "location": response.projectId.address_line + '  ' + response.projectId.city +  '  ' + response.projectId.state ,
        "project_size":parseInt(response.projectId.total_size).toLocaleString() ,
        "start_date": moment(response.project_start_date).format('MM/DD/YYYY'),
        "inspection_photos": inspection_photos ,
        "inspection_videos": inspection_videos,
        "inspection_documents": inspection_documents,
        "report_url": process.env.WEBSITE_URL,
    }
    
    console.log("mailTemplateContent ", mailTemplateContent)
    const htmlReportTemplate = `
    <html>
        <head>
            <title></title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
            <meta name="viewport" content="width=device-width, initial-scale=1">
                <meta http-equiv="X-UA-Compatible" content="IE=edge" />
                <style type="text/css">
                /* CLIENT-SPECIFIC STYLES */
                    body,
                    table,
                    td,
                    a {
                        -webkit - text - size - adjust: 100%;
                    -ms-text-size-adjust: 100%;
                }

                    table,
                    td {
                        mso - table - lspace: 0pt;
                    mso-table-rspace: 0pt;
                }

                    img {
                        -ms - interpolation - mode: bicubic;
                }

                    /* RESET STYLES */
                    img {
                        border: 0;
                    height: auto;
                    line-height: 100%;
                    outline: none;
                    text-decoration: none;
                }

                    table {
                        border - collapse: collapse !important;
                }

                    body {
                        height: 100% !important;
                    margin: 0 !important;
                    padding: 0 !important;
                    width: 100% !important;
                }

                    /* iOS BLUE LINKS */
                    a[x-apple-data-detectors] {
                        color: inherit !important;
                    text-decoration: none !important;
                    font-size: inherit !important;
                    font-family: inherit !important;
                    font-weight: inherit !important;
                    line-height: inherit !important;
                }

                    /* MOBILE STYLES */
                    @media screen and (max-width:600px) {
                        h1 {
                        font - size: 32px !important;
                    line-height: 32px !important;
                    }
                }

                    /* ANDROID CENTER FIX */
                    div[style*="margin: 16px 0;"] {
                        margin: 0 !important;
                }

                    .btn {
                        display: inline-block;
                    font-weight: 400;
                    color: #212529;
                    text-align: center;
                    vertical-align: middle;
                    -webkit-user-select: none;
                    -moz-user-select: none;
                    -ms-user-select: none;
                    user-select: none;
                    background-color: transparent;
                    border: 1px solid transparent;
                    border-top-color: transparent;
                    border-top-width: 1px;
                    border-right-color: transparent;
                    border-right-width: 1px;
                    border-bottom-color: transparent;
                    border-bottom-width: 1px;
                    border-left-color: transparent;
                    border-left-width: 1px;
                    padding: .375rem .75rem;
                    font-size: 1rem;
                    line-height: 1.5;
                    border-radius: .25rem;
                    transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
                }

                    .btn.btn-flat {
                        border - radius: 0;
                    border-width: 1px;
                    box-shadow: none;
                }

                    .btn-dark {
                        color: #fff;
                    background-color: #343a40;
                    border-color: #343a40;
                    box-shadow: none;
                }

                    .btn-block {
                        display: block;
                    width: 100%;
                }
                </style>
        </head>
        <body style="background-color: #f4f4f4; margin: 0 !important; padding: 0 !important;">
            <!-- HIDDEN PREHEADER TEXT -->
            <div
                style="display: none; font-size: 1px; color: #fefefe; line-height: 1px; font-family: 'Lato', Helvetica, Arial, sans-serif; max-height: 0px; max-width: 0px; opacity: 0; overflow: hidden;">
                Project progress report has been submited by inspector</div>
            <table border="0" cellpadding="0" cellspacing="0" width="100%">
                <!-- LOGO -->
                <tr>
                    <td bgcolor="#27316f" align="center">
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tr>
                                <td align="left" valign="top" style="padding: 20px 20px 20px 20px;">
                                    <img src="http://cdn.mcauto-images-production.sendgrid.net/0b2eb67a10355746/58d55aef-9e6b-4aa8-8c0b-adae64ab4070/217x80.png"
                                        width="150" height="120" style="display: block; border: 0px;" />
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td bgcolor="#e21e25" align="center" style="padding: 0px 10px 0px 10px;">
                        <table class="wrapper" role="module" data-type="image" border="0" cellpadding="0" cellspacing="0"
                            width="100%" style="table-layout: fixed;" data-muid="3Ypdby9Xfsf2rN27zTDEfN">
                            <tbody>
                                <tr>
                                    <td style="font-size:6px; line-height:10px; padding:0px 0px 0px 0px;" valign="top"
                                        align="center">
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tr>
                                <td bgcolor="#ffffff" align="center" valign="top"
                                    style="padding: 30px; border-radius: 4px 4px 0px 0px; color: #111111; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 48px; font-weight: 400; letter-spacing: 4px; line-height: 18px;">
                                    <h1 style="font-size: 28px; color: #27316f">Daily Progress Report</h1>
                                    <p style="font-size:14px">${mailTemplateContent.project_name}</p>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td bgcolor="#f4f4f4" align="center" style="padding: 0px 10px 0px 10px;">
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tr>
                                <td bgcolor="#ffffff" align="left"
                                    style="padding: 20px 30px 40px 30px; color: #666666; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 14px; font-weight: 400; line-height: 25px;">

                                    <p style="margin: 0;">
                                        ${mailTemplateContent.report_description}
                                    </p>
                                    <h2>Prepared For :</h2>
                                    <ul style="list-style:none">
                                        <li>
                                            <strong style="color:#27316f;">Project Name :</strong>
                                            <span style="margin-left:5px">${mailTemplateContent.project_name}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Start Date :</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.start_date}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Location :</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.location}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Project Size :</strong>
                                            <span style="margin-left:5px">
                                                Approximately  ${mailTemplateContent.project_size} Square Feet.
                                            </span>
                                        </li>
                                    </ul>
                                    <h2>Inspection Details:</h2>
                                    <ul style="list-style:none">
                                        <li>
                                            <strong style="color:#27316f;">Inspection Date:</strong>
                                            <span style="margin-left:5px"> ${mailTemplateContent.inspection_date}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Specified Material on Site:</strong>
                                            <span style="margin-left:5px">  ${mailTemplateContent.material_confirmed}.
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Crew Size :</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.crew_size}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Project Area Completed during Inspection :</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.area_completed_onday} Square Feet
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Weather Condition:</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.weather_condition}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Total Inspection Documents:</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.documents_count}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Total Inspection Photos:</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.inspection_photos_count}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Total Inspection Video:</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.inspection_video_count}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Completion Progress :</strong>
                                            ${mailTemplateContent.percentage_completion}%
                                        </li>
                                    </ul>
                                    <p><strong>Comments: </strong>${mailTemplateContent.remarks}</p>
                                    <p>View Detailed progress projects report online at
                                        <a href="${mailTemplateContent.report_url}">${mailTemplateContent.report_url}</a>
                                    </p>
                                    <p style="text-align: center">
                                        <a href="${mailTemplateContent.report_url}" class="btn btn-flat btn-dark">View Detailed Progres Report</a>
                                    </p>
                                    <h2>Google Earth Photo :</h2>
                                    <img class="max-width" border="0"
                                        style="display:block; color:#000000; text-decoration:none; font-family:Helvetica, arial, sans-serif; font-size:16px; max-width:100% !important; width:100%; height:auto !important;"
                                        src="${mailTemplateContent.google_photo_url}" alt="" width="600" data-responsive="true"
                                        data-proportionally-constrained="false" />
                                    <h2>Inspection Photos :</h2>
                                    <ul style="list-style:none;">
                                        ${mailTemplateContent.inspection_photos.map(item =>
                                            `<li style="float:left; padding:5px; border:0.5px solid #ccc; width:200px; margin:5px">
                                                    <img style="display:block;  width:100%; height:200px" src=${item.base64Image}>
                                                    <p> ${item.description}</p>
                                                </li>`
                                        )}
                                    </ul>
                                </td>
                            </tr>
                            <tr>
                            </tr>
                        </tr>
                        <tr>
                            <td bgcolor="#f4f4f4" align="center" style="padding: 30px 10px 0px 10px;">
                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <tr>
                                        <td bgcolor="#fff" align="center"
                                            style="padding: 30px 30px 30px 30px; border-radius: 4px 4px 4px 4px; color: #666666; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 18px; font-weight: 400; line-height: 25px;">
                                            <h2 style="font-size: 18px; font-weight: 400; color: #27316f; margin: 0;">Need more help?
                                            </h2>
                                            <p style="margin: 0;"><a href="https://roofinspections.report" target="_blank"
                                                style="color: #e21e25;">We&rsquo;re here to help you out</a></p>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td bgcolor="#f4f4f4" align="center" style="padding: 0px 10px 0px 10px;">
                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <tr>
                                        <td bgcolor="#f4f4f4" align="left"
                                            style="text-align: center; padding: 0px 30px 30px 30px; color: #666666; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 14px; font-weight: 400; line-height: 18px;">
                                            <br>
                                                RoofInspections® is a Registered Trademark of and Copyright© 2023-2024 roofingprojects.com.
                                                All Rights Reserved.</p>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </body>

    </html>
   `;
    const fileNamePrefix = Date.now();       
    var options = { format: 'Letter' };
    pdf.create(htmlReportTemplate, options).toFile('./'+fileNamePrefix+ '_reports.pdf', function(err, data) {
        if (err) return console.log(err);
        console.log(data); // { filename: '/app/businesscard.pdf' }
        // return res.send(200)
        res.download(data.filename, (err) => {
            if (err) {
              console.log(err); // Check error if you want
            }
            fs.unlink(data.filename, function(){
                console.log("File was deleted") // Callback
            });
          })
      });
    }).catch(err => {
        console.log("error", err)
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.reportId
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving report details with id " + req.params.reportId
        });
    });
};

exports.downloadReportApp = async (req, res) => {
    console.log("req.body", req.body)
    if(!req.params.reportId){
        return res.status(400).send({ "is_error": true, "message": "Please select the correct report." });
    }

    reportModel.findOne({_id:req.params.reportId})
    .populate([
        {
            path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line','total_size'],
            populate: { path: 'assignedOwner', select:['first_name','last_name','company_name'] }
        }
    ])
    .populate([{path:'inspector_id', select:['first_name','last_name']}])
    .populate([{path:'created_by', select:['first_name','last_name']}])
    .populate([{path:'updated_by', select:['first_name','last_name']}])
    .then(async response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.reportId
            });            
        }
    let inspection_photos = await mediaModel.find({ref_id: req.params.reportId, deleted: false,type:'inspection_photos' });
    let inspection_videos = await mediaModel.find({ref_id: req.params.reportId, deleted: false,type:'inspection_videos' });
    let inspection_documents = await mediaModel.find({ref_id: req.params.reportId, deleted: false,type:'supporting_documents'});
    const google_earth = await mediaModel.find({ref_id: req.params.reportId, deleted: false,type:'google_earth'});

    inspection_photos = await inspection_photos.map(item=>{
        // item.path = process.env.PUBLIC_BASE_URL+ '/' + item.path ;
        item['base64Image'] = "data:image/gif;base64,"+fs.readFileSync('./' + item.path, 'base64')
        return item ;
    })
    inspection_videos =  await inspection_videos.map(item=>{
        item.path = process.env.PUBLIC_BASE_URL+ '/' + item.path ;
        return item ;
    })
    inspection_documents =  await inspection_documents.map(item=>{
        item.path = process.env.PUBLIC_BASE_URL+ '/' + item.path ;
        return item ;
    })

    //  Write code to send email to users 
    const mailTemplateContent = {
        "inspection_date": moment(response.inspection_date).format('MM/DD/YYYY'),
        "material_confirmed": response.onsite_material_confirmed ? 'CONFIRMED' : 'UNCONFIRMED',
        "crew_size":response.crew_size,
        "area_completed_onday": parseInt(response.area_completed_onday).toLocaleString(),
        "weather_condition":response.weather,
        "percentage_completion":response.completion_percentage,
        "report_description": response.work_description,
        "remarks":response.additional_remark,
        "documents_count":inspection_documents.length,
        "inspection_photos_count": inspection_photos.length,
        "inspection_video_count": inspection_videos.length,
        "google_photo_url":google_earth.length >0 ? "data:image/gif;base64,"+fs.readFileSync('./' + google_earth[0].path, 'base64') : '',
        "project_id":response.projectId._id,
        "project_name": response.projectId.name,
        "location": response.projectId.address_line + '  ' + response.projectId.city +  '  ' + response.projectId.state ,
        "project_size":parseInt(response.projectId.total_size).toLocaleString() ,
        "start_date": moment(response.project_start_date).format('MM/DD/YYYY'),
        "inspection_photos": inspection_photos ,
        "inspection_videos": inspection_videos,
        "inspection_documents": inspection_documents,
        "report_url": process.env.WEBSITE_URL,
    }
    
    console.log("mailTemplateContent ", mailTemplateContent)
    const htmlReportTemplate = `
    <html>
        <head>
            <title></title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
            <meta name="viewport" content="width=device-width, initial-scale=1">
                <meta http-equiv="X-UA-Compatible" content="IE=edge" />
                <style type="text/css">
                /* CLIENT-SPECIFIC STYLES */
                    body,
                    table,
                    td,
                    a {
                        -webkit - text - size - adjust: 100%;
                    -ms-text-size-adjust: 100%;
                }

                    table,
                    td {
                        mso - table - lspace: 0pt;
                    mso-table-rspace: 0pt;
                }

                    img {
                        -ms - interpolation - mode: bicubic;
                }

                    /* RESET STYLES */
                    img {
                        border: 0;
                    height: auto;
                    line-height: 100%;
                    outline: none;
                    text-decoration: none;
                }

                    table {
                        border - collapse: collapse !important;
                }

                    body {
                        height: 100% !important;
                    margin: 0 !important;
                    padding: 0 !important;
                    width: 100% !important;
                }

                    /* iOS BLUE LINKS */
                    a[x-apple-data-detectors] {
                        color: inherit !important;
                    text-decoration: none !important;
                    font-size: inherit !important;
                    font-family: inherit !important;
                    font-weight: inherit !important;
                    line-height: inherit !important;
                }

                    /* MOBILE STYLES */
                    @media screen and (max-width:600px) {
                        h1 {
                        font - size: 32px !important;
                    line-height: 32px !important;
                    }
                }

                    /* ANDROID CENTER FIX */
                    div[style*="margin: 16px 0;"] {
                        margin: 0 !important;
                }

                    .btn {
                        display: inline-block;
                    font-weight: 400;
                    color: #212529;
                    text-align: center;
                    vertical-align: middle;
                    -webkit-user-select: none;
                    -moz-user-select: none;
                    -ms-user-select: none;
                    user-select: none;
                    background-color: transparent;
                    border: 1px solid transparent;
                    border-top-color: transparent;
                    border-top-width: 1px;
                    border-right-color: transparent;
                    border-right-width: 1px;
                    border-bottom-color: transparent;
                    border-bottom-width: 1px;
                    border-left-color: transparent;
                    border-left-width: 1px;
                    padding: .375rem .75rem;
                    font-size: 1rem;
                    line-height: 1.5;
                    border-radius: .25rem;
                    transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
                }

                    .btn.btn-flat {
                        border - radius: 0;
                    border-width: 1px;
                    box-shadow: none;
                }

                    .btn-dark {
                        color: #fff;
                    background-color: #343a40;
                    border-color: #343a40;
                    box-shadow: none;
                }

                    .btn-block {
                        display: block;
                    width: 100%;
                }
                </style>
        </head>
        <body style="background-color: #f4f4f4; margin: 0 !important; padding: 0 !important;">
            <!-- HIDDEN PREHEADER TEXT -->
            <div
                style="display: none; font-size: 1px; color: #fefefe; line-height: 1px; font-family: 'Lato', Helvetica, Arial, sans-serif; max-height: 0px; max-width: 0px; opacity: 0; overflow: hidden;">
                Project progress report has been submited by inspector</div>
            <table border="0" cellpadding="0" cellspacing="0" width="100%">
                <!-- LOGO -->
                <tr>
                    <td bgcolor="#27316f" align="center">
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tr>
                                <td align="left" valign="top" style="padding: 20px 20px 20px 20px;">
                                    <img src="http://cdn.mcauto-images-production.sendgrid.net/0b2eb67a10355746/58d55aef-9e6b-4aa8-8c0b-adae64ab4070/217x80.png"
                                        width="150" height="120" style="display: block; border: 0px;" />
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td bgcolor="#e21e25" align="center" style="padding: 0px 10px 0px 10px;">
                        <table class="wrapper" role="module" data-type="image" border="0" cellpadding="0" cellspacing="0"
                            width="100%" style="table-layout: fixed;" data-muid="3Ypdby9Xfsf2rN27zTDEfN">
                            <tbody>
                                <tr>
                                    <td style="font-size:6px; line-height:10px; padding:0px 0px 0px 0px;" valign="top"
                                        align="center">
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tr>
                                <td bgcolor="#ffffff" align="center" valign="top"
                                    style="padding: 30px; border-radius: 4px 4px 0px 0px; color: #111111; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 48px; font-weight: 400; letter-spacing: 4px; line-height: 18px;">
                                    <h1 style="font-size: 28px; color: #27316f">Daily Progress Report</h1>
                                    <p style="font-size:14px">${mailTemplateContent.project_name}</p>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td bgcolor="#f4f4f4" align="center" style="padding: 0px 10px 0px 10px;">
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tr>
                                <td bgcolor="#ffffff" align="left"
                                    style="padding: 20px 30px 40px 30px; color: #666666; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 14px; font-weight: 400; line-height: 25px;">

                                    <p style="margin: 0;">
                                        ${mailTemplateContent.report_description}
                                    </p>
                                    <h2>Prepared For :</h2>
                                    <ul style="list-style:none">
                                        <li>
                                            <strong style="color:#27316f;">Project Name :</strong>
                                            <span style="margin-left:5px">${mailTemplateContent.project_name}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Start Date :</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.start_date}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Location :</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.location}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Project Size :</strong>
                                            <span style="margin-left:5px">
                                                Approximately  ${mailTemplateContent.project_size} Square Feet.
                                            </span>
                                        </li>
                                    </ul>
                                    <h2>Inspection Details:</h2>
                                    <ul style="list-style:none">
                                        <li>
                                            <strong style="color:#27316f;">Inspection Date:</strong>
                                            <span style="margin-left:5px"> ${mailTemplateContent.inspection_date}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Specified Material on Site:</strong>
                                            <span style="margin-left:5px">  ${mailTemplateContent.material_confirmed}.
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Crew Size :</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.crew_size}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Project Area Completed during Inspection :</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.area_completed_onday} Square Feet
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Weather Condition:</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.weather_condition}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Total Inspection Documents:</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.documents_count}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Total Inspection Photos:</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.inspection_photos_count}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Total Inspection Video:</strong>
                                            <span style="margin-left:5px">
                                                ${mailTemplateContent.inspection_video_count}
                                            </span>
                                        </li>
                                        <li>
                                            <strong style="color:#27316f;">Completion Progress :</strong>
                                            ${mailTemplateContent.percentage_completion}%
                                        </li>
                                    </ul>
                                    <p><strong>Comments: </strong>${mailTemplateContent.remarks}</p>
                                    <p>View Detailed progress projects report online at
                                        <a href="${mailTemplateContent.report_url}">${mailTemplateContent.report_url}</a>
                                    </p>
                                    <p style="text-align: center">
                                        <a href="${mailTemplateContent.report_url}" class="btn btn-flat btn-dark">View Detailed Progres Report</a>
                                    </p>
                                    <h2>Google Earth Photo :</h2>
                                    <img class="max-width" border="0"
                                        style="display:block; color:#000000; text-decoration:none; font-family:Helvetica, arial, sans-serif; font-size:16px; max-width:100% !important; width:100%; height:auto !important;"
                                        src="${mailTemplateContent.google_photo_url}" alt="" width="600" data-responsive="true"
                                        data-proportionally-constrained="false" />
                                    <h2>Inspection Photos :</h2>
                                    <ul style="list-style:none;">
                                        ${mailTemplateContent.inspection_photos.map(item =>
                                            `<li style="float:left; padding:5px; border:0.5px solid #ccc; width:200px; margin:5px">
                                                    <img style="display:block;  width:100%; height:200px" src=${item.base64Image}>
                                                    <p> ${item.description}</p>
                                                </li>`
                                        )}
                                    </ul>
                                </td>
                            </tr>
                            <tr>
                            </tr>
                        <tr>
                            <td bgcolor="#f4f4f4" align="center" style="padding: 30px 10px 0px 10px;">
                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <tr>
                                        <td bgcolor="#fff" align="center"
                                            style="padding: 30px 30px 30px 30px; border-radius: 4px 4px 4px 4px; color: #666666; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 18px; font-weight: 400; line-height: 25px;">
                                            <h2 style="font-size: 18px; font-weight: 400; color: #27316f; margin: 0;">Need more help?
                                            </h2>
                                            <p style="margin: 0;"><a href="https://roofinspections.report" target="_blank"
                                                style="color: #e21e25;">We&rsquo;re here to help you out</a></p>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td bgcolor="#f4f4f4" align="center" style="padding: 0px 10px 0px 10px;">
                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <tr>
                                        <td bgcolor="#f4f4f4" align="left"
                                            style="text-align: center; padding: 0px 30px 30px 30px; color: #666666; font-family: 'Lato', Helvetica, Arial, sans-serif; font-size: 14px; font-weight: 400; line-height: 18px;">
                                            <br>
                                                RoofInspections® is a Registered Trademark of and Copyright© 2023-2024 roofingprojects.com.
                                                All Rights Reserved.</p>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </body>

    </html>
   `;
    
    const fileNamePrefix = Date.now();    
    const fileDir = path.resolve('./public/uploads/reportPdf/' + fileNamePrefix + '_reports.pdf') 

    var options = { format: 'Letter' };
    pdf.create(htmlReportTemplate, options).toFile(fileDir, function(err, data) {
        if (err) return console.log(err);
        console.log(data); // { filename: '/app/businesscard.pdf' }
        return res.send(
            {
            is_error : false, 
            basePath: data.filename ,
            path: process.env.PUBLIC_BASE_URL+ '/public/uploads/reportPdf/'+ fileNamePrefix + '_reports.pdf'});
      });
    }).catch(err => {
        console.log("error", err)
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.reportId
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving report details with id " + req.params.reportId
        });
    });
};

exports.cleanPdfDocument = async( req, res)=>{
    mediaUtils.unlink(req.body.basePath);
    return res.send({is_error:false , message: " Report document deleted successfully"})
}

exports.validateReportId = async (req, res) => {
    reportModel.findOne({_id:req.params.id, is_deleted:false})
    .then(async response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.id
            });            
        }
        
        res.send({is_error : false, data: response});
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving report details with id " + req.params.id
        });
    });
};

exports.getAllinspectionPhotos = async (req, res) => {
    try {
        const report = await reportModel.find({is_deleted: false , projectId: req.params.id})
        .populate([{
            path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line'],
            populate: [{ path: 'assignedManufacturers', select:['first_name','last_name','company_name','email','role','company_logo'] }, 
            { path: 'assignedContractor', select:['first_name','last_name','company_name','email','role','company_logo'] },
            { path: 'assignedOwner', select:['first_name','last_name','company_name','email','role','company_logo'] },
            {path:'assignedForeman', select:['first_name','last_name','company_name', 'email','phone','company_logo']}
            ]
        }])
        .populate([{path:'inspector_id', select:['first_name','last_name']}])
        .populate([{path:'created_by', select:['first_name','last_name']}])
        .populate([{path:'updated_by', select:['first_name','last_name']}])
        .sort([["createdAt",-1]]);
        res.send({is_error : false, data: report});
    } catch (error) {
        console.log(error);
        return res.send({"is_error": true , "message": "An error occured : " + error});
    }
  };