const projectEstimatorFormModel = require('../model/project_estimator_assistance');

//   Get Associated Project Estimator Assistance
exports.getProjectEstimator= async (req, res) => {
    try {
        const responsedata = await projectEstimatorFormModel.findOne({project_id:req.params.project_id});
        return res.send({ "is_error": false, data: responsedata })
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured" + error });
    }
};

// Create Estimator Assistance for a Project
exports.createProjectEstimator = async (req, res) => {
    console.log("req.body", req.body)
    // Our Add user logic starts here
    try {
        // Validate user input
        if (!req.body.project_id ) {
            return res.status(400).send({ "is_error": true, "message": "Project Id is required." });
          }
          if (!req.body.line_items) {
            return res.status(400).send({ "is_error": true, "message": "Please Provide Estimator Items." });
          }
          if (req.body.line_items && req.body.line_items.length == 0) {
            return res.status(400).send({ "is_error": true, "message": "Estimator items cannot be empty." });
          }

        const bidTemplateExist = await projectEstimatorFormModel.find({ project_id : req.body.project_id });
        // check if bid form already created for a given project
        if (bidTemplateExist.length > 0) {
            return res.status(400).send({ "is_error": true, "message": "Project already has associated Estimator Assistance associated. Please modify the existing form if you wish to do modifications." });
        }

        // Create record in our database
        const record = await projectEstimatorFormModel.create({
            project_id: req.body.project_id , 
            line_items: req.body.line_items ? req.body.line_items : []
        });

        // return new record
        res.status(200).json({ is_error: false, data: record });
    } catch (err) {
        console.log(err);
        res.status(500).json({ is_error: true, data: {}, message: "Error While saving estimator assistance for a project. Please try again." + err });
    }
    // Our Add logic ends here
};

exports.findOne = async (req, res) => {
    projectEstimatorFormModel.findById(req.params.id)
        .then(responseData => {
            if (!responseData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Rcord not found with id " + req.params.userId
                });
            }
            res.send({ is_error: false, data: responseData });
        }).catch(err => {
            console.log("err", err)
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Record not found with id " + req.params.userId
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Record with id " + req.params.userId
            });
        });
};

exports.updateProjectEstimator = async (req, res) => {
     
    // Validate request
    if (!req.body.line_items) {
        return res.status(400).send({ "is_error": true, "message": "Please Provide Estimator Items." });
    }
    if (req.body.line_items && req.body.line_items.length == 0) {
    return res.status(400).send({ "is_error": true, "message": "Estimator items cannot be empty." });
    }
    const payload = {
        line_items: req.body.line_items ? req.body.line_items : []
    }

    // Find record and update it with the request body
    await projectEstimatorFormModel.findByIdAndUpdate(req.params.id, payload, { new: true })
        .then(result => {
            if (!result) {
                return res.status(404).send({
                    is_error: true,
                    message: "Record details not found."
                });
            }
            res.send({
                is_error: false,
                data: result
            });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Record details not found with provided Id."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating the record."
            });
        });
};