const projectModel = require('../model/projects');
const mediaModel = require('../model/projectMedia');

const opportunityPaymentModel = require('../model/opportunityPayment');
const bidSubmissionModel = require('../model/project_bid_submission');

const helper = require('../middleware/_helper');
const mediaUtils = require("../config/unlinkMedia");

// Create and Save a new project
exports.create = async (req, res) => {
    console.log("project Body data", req.body)
         // Our Add logic starts here
    try {

        // Get user input
        const { owner_id, building_id, name, address_line, country, state, city, zip_code, status } = req.body;

        // Validate user input
        if (!(owner_id && building_id && name)) {
            // delete all uploaded Project media files
            await deleteMedia(req);
            return res.status(400).send({ "is_error": true, "message": "All input ( Owner, Building & Project Name) are required." });
        }

        // Validate if record exist in our database
        const oldRecordExist = await projectModel.findOne({ name: req.body.name, owner_id: req.body.owner_id, building_id: req.body.building_id });
        console.log("old record", oldRecordExist)
        if (oldRecordExist) {
             // delete all uploaded building media files
             await deleteMedia(req);
             return res.status(409).send({ "is_error": true, "message": "Project already exist with same name for selected owner and building." });
        }

        const loggedInUser = helper.getCurrentUser(req.headers.authorization);
        console.log("loggedin user", loggedInUser)

        let payload = {
        owner_id: req.body.owner_id,
        building_id: req.body.building_id,
        name: req.body.name,
        description: req.body.description ? req.body.description : "",
        start_date: req.body.start_date,
        end_date: req.body.end_date,
        total_size: req.body.total_size,
        total_cost: 0,
        assignedManufacturers: req.body.assignedManufacturers ? JSON.parse(req.body.assignedManufacturers) : [],
        phone: req.body.phone ? req.body.phone : "",
        country: req.body.country ? req.body.country : "",
        state: req.body.state ? req.body.state : "",
        city: req.body.city ? req.body.city : "",
        zip_code: req.body.zip_code ? req.body.zip_code : "",
        address_line: req.body.address_line ? req.body.address_line : "",
        address_line2: req.body.address_line2 ? req.body.address_line2 : "",        
        project_notes: req.body.project_notes ? req.body.project_notes : "",
        project_status: req.body.project_status,
        status: req.body.status,
        created_by: loggedInUser.data._id,
        is_deleted: false,
        projectDescription: req.body.projectDescription ? JSON.parse(req.body.projectDescription) : [],
        bid_start_date: req.body.bid_start_date,
        bid_end_date: req.body.bid_end_date,
        bidder_fees: req.body.bidder_fees,
    }


        const propertyObj = new projectModel(payload);

        propertyObj.save()
        .then(async result => {
             // Preparing Media Object
            let media = [];

            const mediaRootPath = "public/uploads/" + req.body.owner_id + '/buildings/' + req.body.building_id + '/projects/';
            const mediaKey = Object.keys(req.files);
            mediaKey.forEach(async key => {
                if (req.files[key].length && req.files[key].length > 0) {
                    // multiple files
                    const MediaFiles = req.files[key];
                    await MediaFiles.forEach(async mediaFile => {
                    media.push({
                        path: mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename,
                        filename: mediaFile.filename,
                        ref_id: result._id,
                        type: mediaFile.fieldname
                    });
                    })

                } else {
                    console.log("Else condition block")
                }
            })
            if(!result){
                // delete all uploaded project media files
                await media.forEach(element => {
                    mediaUtils.unlink(element.path);
                });
                return res.status(500).json({ is_error: true, data: {}, message: "Error While Creating Project.Please try again."});
            }
                // store all images,documents and videos
                await mediaModel.insertMany(media);
                // return new property data
                return res.status(200).json({ is_error: false, data: result });
        })

    } catch (err) {
        console.log(err);
        // delete all uploaded Project media files
        await deleteMedia(req);
        return res.status(500).json({ is_error: true, data: {}, message: "Error While Creating Project.Please try again." + err });

    }
    // Our Add logic ends here
};

// Retrieve and return all projects from the database.
exports.findAll = async (req, res) => {
    // projectModel.updateMany({}, {'parent_id':null , bid_type: 'STANDARD' , associatedProjects:[]} , {new: true})
    // .then(async response => {
    //     console.log("Success")
    // })
    try {
        const loggedInUser = helper.getCurrentUser(req.headers.authorization);
        console.log("loggedInUser", loggedInUser)
        const projects = await projectModel.find({})
            .populate([{ path: 'assignedManufacturers', select: ['first_name', 'last_name', 'company_name', 'email', 'phone', 'company_logo'] }])
            .populate([{ path: 'owner_id', select: ['first_name', 'last_name', 'company_name', 'email', 'phone', 'company_logo'] }])
            .populate([{ path: 'building_id' }])
            // .populate([{ path: 'parent_id', select: ['name'] }])
            .populate([{ path: 'created_by', select: ['first_name', 'last_name'] }])
            .populate([{ path: 'updated_by', select: ['first_name', 'last_name'] }])
            .sort([["updatedAt", -1]]);
        res.send({ is_error: false, data: projects });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// Retrieve and return all projects from the database.
exports.getAllNotAssignedStdProjects = async (req, res) => {
    try {
        const loggedInUser = helper.getCurrentUser(req.headers.authorization);
        console.log("loggedInUser", loggedInUser)
        // const projects = await projectModel.find({parent_id: null ,bid_type:'STANDARD' })
        const projects = await projectModel.find({bid_type:'STANDARD'})
            .populate([{ path: 'assignedManufacturers', select: ['first_name', 'last_name', 'company_name', 'email', 'phone', 'company_logo'] }])
            .populate([{ path: 'owner_id', select: ['first_name', 'last_name', 'company_name', 'email', 'phone', 'company_logo'] }])
            .populate([{ path: 'building_id' }])
            .populate([{ path: 'created_by', select: ['first_name', 'last_name'] }])
            .populate([{ path: 'updated_by', select: ['first_name', 'last_name'] }])
            .sort([["name", 1]]);
        res.send({ is_error: false, data: projects });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// Find a project details
exports.findOne = async (req, res) => {

    projectModel.findById(req.params.id)
    .populate([{ path: "media", match: { deleted: false } }])
    .populate([{ path: 'parent_id', select: ['name'] }])
    .populate([{path:'associatedProjects'}])
        // .populate([{path:'assignedManufacturers', select:['first_name','last_name','company_name', 'email','phone','company_logo']}])
        // .populate([{path:'owner_id', select:['first_name','last_name','company_name', 'email','phone','company_logo']}])
        // .populate([{path:'building_id'}])
        // .populate([{path:'created_by', select:['first_name','last_name']}])
        // .populate([{path:'updated_by', select:['first_name','last_name']}])
        .then(async response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Project not found with id " + req.params.id
                });
            }
            // const projectMedia = await mediaModel.find({ ref_id: req.params.id, deleted: false });
            // console.log("projectMedia", projectMedia);
            // response.mediaFiles = projectMedia ;
            res.send({ is_error: false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Project not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Project details with id " + req.params.id
            });
        });
};

// Update a project
exports.update = async (req, res) => {
    console.log("req.params", JSON.parse(req.body.assignedManufacturers))
    // let payload = {
    //     owner_id: req.body.owner_id,
    //     building_id: req.body.building_id,
    //     name: req.body.name,
    //     description: req.body.description ? req.body.description : "",
    //     start_date: req.body.start_date,
    //     end_date: req.body.end_date,
    //     total_size: req.body.total_size,
    //     total_cost: 0,
    //     assignedManufacturers: req.body.assignedManufacturers ? JSON.parse(req.body.assignedManufacturers) : [],
    //     phone: req.body.phone ? req.body.phone : "",
    //     country: req.body.country ? req.body.country : "",
    //     state: req.body.state ? req.body.state : "",
    //     city: req.body.city ? req.body.city : "",
    //     zip_code: req.body.zip_code ? req.body.zip_code : "",
    //     address_line: req.body.address_line ? req.body.address_line : "",
    //     project_notes: req.body.project_notes ? req.body.project_notes : "",
    //     status: req.body.status,
    //     created_by: loggedInUser.data._id,
    //     is_deleted:false
    //   };

    // // Find project and update it with the request body
    // projectModel.findByIdAndUpdate(req.params.id, payload , {new: true})
    // .then(async response => {
    //     let media = [];
    //     const mediaRootPath = "public/uploads/" + req.body.owner_id + '/buildings/' + req.body.building_id + '/projects/';
    //     const mediaKey = Object.keys(req.files);
    //     mediaKey.forEach(async key => {
    //         if (req.files[key].length && req.files[key].length > 0) {
    //             // multiple files
    //             const projectMediaFiles = req.files[key];
    //             await projectMediaFiles.forEach(async mediaFile => {
    //                 media.push({
    //                     path: mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename,
    //                     filename: mediaFile.filename,
    //                     ref_id: response._id,
    //                     type: mediaFile.fieldname,
    //                     mimetype: mediaFile.mimetype,
    //                     extn: (mediaFile.filename.split('.').pop()).toLowerCase()
    //                 });
    //             })

    //         } else {
    //             console.log("Else condition block")
    //         }
    //     })

    //     if(!response) {
    //         // remove all recently uploaded images from directory
    //         media.forEach(element => {
    //             mediaUtils.unlink(element.path);
    //         });
    //         return res.status(404).send({
    //             is_error : true,
    //             message: "Project not found with id " + req.params.id
    //         });
    //     }
    //     // store all images,documents and videos
    //     await mediaModel.insertMany(media);
    //    // Remove all the removed media from directory and Media Collection
    //    if (req.body.existingFilesData) {
    //         const filesTobeRemoved = JSON.parse(req.body.existingFilesData);
    //         await filesTobeRemoved.forEach(element => {
    //             if(element.deleted){
    //                 mediaUtils.unlink(element.path);
    //                 // delete record from Media collection
    //                 mediaModel.findByIdAndUpdate(element._id,element).exec();
    //             }else{
    //                 // only update the records with updated data of description
    //                 mediaModel.findByIdAndUpdate(element._id,element).exec();
    //             }
    //         });
    //     }
    //     res.send( { is_error : false, data: response });
    // }).catch(err => {
    //     // delete all uploaded project media files from directory
    //     const mediaRootPath = "public/uploads/" + req.body.owner_id + '/buildings/' + req.body.building_id + '/projects/';
    //     const mediaKey = Object.keys(req.files);
    //     mediaKey.forEach(async key => {
    //         if (req.files[key].length && req.files[key].length > 0) {
    //             // multiple files
    //             const projectMediaFiles = req.files[key];
    //             await projectMediaFiles.forEach(async mediaFile => {
    //                 // call util method to remove file from location
    //                 mediaUtils.unlink(mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename);
    //             })
    //         }
    //     })

    //     if(err.kind === 'ObjectId') {
    //         return res.status(404).send({
    //             is_error : true,
    //             message: "Project not found with id " + req.params.id
    //         });                
    //     }
    //     return res.status(500).send({
    //         is_error : true,
    //         message: "Error updating Project details with id " + err
    //     });
    // });


    console.log("req.body", req.body);
    console.log("req.params", req.params)

    try {
        const loggedInUser = helper.getCurrentUser(req.headers.authorization);
        // Validate Request
        if (!(req.body.owner_id && req.body.building_id && req.body.name)) {
            // delete all uploaded building media files
            await deleteMedia(req);
            return res.status(400).send({ "is_error": true, "message": "All input ( Owner, Building & Project Name) are required." });
        }

        // Validate if record exist in our database
        const oldRecordExist = await projectModel.findOne({ _id: { $ne: req.params.id }, name: req.body.name, owner_id: req.body.owner_id , building_id: req.body.building_id });

        if (oldRecordExist) {
            // delete all uploaded building media files
            await deleteMedia(req);
            return res.status(409).send({ "is_error": true, "message": "Project already exist with same name for selected owner and building." });
        }

        // save and Hold the Existing Associated projects Array
        const currentProjectData = await projectModel.findOne({_id: req.params.id});

        let payload = {
            owner_id: req.body.owner_id,
            building_id: req.body.building_id,
            name: req.body.name,
            description: req.body.description ? req.body.description : "",
            start_date: req.body.start_date,
            end_date: req.body.end_date,
            total_size: req.body.total_size,
            total_cost: 0,
            assignedManufacturers: req.body.assignedManufacturers ? JSON.parse(req.body.assignedManufacturers) : [],
            phone: req.body.phone ? req.body.phone : "",
            country: req.body.country ? req.body.country : "",
            state: req.body.state ? req.body.state : "",
            city: req.body.city ? req.body.city : "",
            zip_code: req.body.zip_code ? req.body.zip_code : "",
            address_line: req.body.address_line ? req.body.address_line : "",
            address_line2: req.body.address_line2 ? req.body.address_line2 : "",
            project_notes: req.body.project_notes ? req.body.project_notes : "",
            project_status: req.body.project_status,
            status: req.body.status,
            created_by: loggedInUser.data._id,
            is_deleted: false,
            projectDescription: req.body.projectDescription ? JSON.parse(req.body.projectDescription) : [],
            bid_start_date: req.body.bid_start_date,
            bid_end_date: req.body.bid_end_date,
            bidder_fees: req.body.bidder_fees,
            bid_type: req.body.bid_type,
            parent_id: req.body.parent_id,
            associatedProjects: req.body.associatedProjects ? JSON.parse(req.body.associatedProjects) : []
        };

        // Find property and update it with the request body
        await projectModel.findByIdAndUpdate(req.params.id, payload, { new: true })
            .then(async result => {

                // Preparing Media Object
                let media = [];

                const mediaRootPath = "public/uploads/" + req.body.owner_id + '/buildings/' + req.body.building_id + '/projects/';
                const mediaKey = Object.keys(req.files);
                mediaKey.forEach(async key => {
                    if (req.files[key].length && req.files[key].length > 0) {
                        // multiple files
                        const MediaFiles = req.files[key];
                        await MediaFiles.forEach(async mediaFile => {
                            media.push({
                                path: mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename,
                                filename: mediaFile.filename,
                                ref_id: result._id,
                                type: mediaFile.fieldname
                            });
                        })

                    } else {
                        console.log("Else condition block")
                    }
                })
                if (!result) {
                    // delete all uploaded building media files
                    await media.forEach(element => {
                        mediaUtils.unlink(element.path);
                    });
                    return res.status(404).send({
                        is_error: true,
                        message: "Project details not found."
                    });
                }
                // store all images,documents and videos
                await mediaModel.insertMany(media);
                // Remove all the removed media from directory and Media Collection
                if (req.body.removed_items) {
                    const filesTobeRemoved = JSON.parse(req.body.removed_items);
                    await filesTobeRemoved.forEach(element => {
                        console.log("file tp be deletd", element)
                        mediaUtils.unlink(element.path);
                        // delete record from Media collection
                        mediaModel.deleteOne({ _id: element._id, filename: element.filename, ref_id: element.ref_id }).exec();
                    });
                }

                // On success , Add Parent Proect id ref to Each Associated projects

                if(result.associatedProjects && result.associatedProjects.length>0){

                    projectModel.updateMany({_id:{$in:result.associatedProjects}}, {'parent_id':result._id} , {new: true})
                    .then(async response => {
                        console.log("Success")
                    })

                }

                // On success , remove association of project Ids from old data

                if(currentProjectData.associatedProjects && currentProjectData.associatedProjects.length>0){

                    projectModel.updateMany({_id:{$in:currentProjectData.associatedProjects}}, {'parent_id':null} , {new: true})
                    .then(async response => {
                        console.log("Success")
                    })

                }


                res.send({
                    is_error: false,
                    data: result
                });
            })
    }
    catch (err) {
        console.log(err);
        // delete all uploaded building media files
        await deleteMedia(req);
        if (err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error: true,
                message: "Project details not found with provided Id."
            });
        }
        return res.status(500).send({
            is_error: true,
            message: "Error updating the Project details."
        });
    }
};

// Delete a project with the specified id in the request
exports.delete = (req, res) => {
    projectModel.findByIdAndRemove(req.params.id)
        .then(responseData => {
            if (!responseData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Project not found with id " + req.params.id
                });
            }
            res.send({ is_error: false, message: "Project deleted successfully!" });
        }).catch(err => {
            if (err.kind === 'ObjectId' || err.name === 'NotFound') {
                return res.status(404).send({
                    is_error: true,
                    message: "Project not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Could not delete Project with id " + req.params.id
            });
        });
};


// new-Set and Update Media Description of a Project by media Id
exports.updateMediaDescription = async (req, res) => {
    // console.log("req.body", req.body);
    if(req.body && req.body.existingMedia){
        const payloadData = [...req.body.existingMedia] ;
        // Updating Project Main Image in project collection table
        const updateSuccess = await projectModel.findByIdAndUpdate(req.params.id , {bannerImage: req.body.main_img_path}).exec();

        var counter = 0 ;
        for( i=0 ; i<= payloadData.length ; i++){
            // console.log("req.body", payloadData[i]);

            const data = {
                title: (payloadData[i] && payloadData[i]?.title) ? payloadData[i]?.title : '',
                description:( payloadData[i] && payloadData[i]?.description )? payloadData[i].description : '',
                isPublic: (payloadData[i] && payloadData[i]?.isPublic) ? payloadData[i].isPublic : false,
                isMainImage: (payloadData[i] && payloadData[i]?.isPublic) ? payloadData[i].isPublic : false,
                isMainImage: (payloadData[i] && payloadData[i]?.isMainImage) ? payloadData[i].isMainImage : false,
            };
            
            if(payloadData[i] && payloadData[i] != undefined){
                const updateSuccess = await mediaModel.findByIdAndUpdate(payloadData[i]?._id , data).exec();
                console.log("updated success", updateSuccess)
            }
            
            counter++;
        }

        // if(counter === req.body.existingMedia.length){
            return res.send({is_error : false, message: "Project Details has been saved sucessfully!"});
        // }

    }else{
        return res.status(500).send({
            is_error: true,
            message: "Please Provide the Data to Update."
        });
    }
    // mediaModel.find({ ref_id: req.params.id, deleted: false })
    //     .then(async response => {
    //         if (!response) {
    //             return res.status(404).send({
    //                 is_error: true,
    //                 message: "Project Media not found with id " + req.params.id
    //             });
    //         }
    //         res.send({ is_error: false, data: response, });
    //     }).catch(err => {
    //         if (err.kind === 'ObjectId') {
    //             return res.status(404).send({
    //                 is_error: true,
    //                 message: "Project Media not found with id " + req.params.id
    //             });
    //         }
    //         return res.status(500).send({
    //             is_error: true,
    //             message: "Error retrieving Project Media details with id " + req.params.id
    //         });
    //     });
};


// Retrieve and return all projects by property ID
exports.findAllByPropertyId = async (req, res) => {
    try {
        const loggedInUser = helper.getCurrentUser(req.headers.authorization);
        console.log("loggedInUser", loggedInUser)
        const projects = await projectModel.find({building_id: req.params.id})
            .populate([{ path: 'assignedManufacturers', select: ['first_name', 'last_name', 'company_name', 'email', 'phone', 'company_logo'] }])
            .populate([{ path: 'owner_id', select: ['first_name', 'last_name', 'company_name', 'email', 'phone', 'company_logo'] }])
            .populate([{ path: 'building_id' }])
            .populate([{ path: 'created_by', select: ['first_name', 'last_name'] }])
            .populate([{ path: 'updated_by', select: ['first_name', 'last_name'] }])
            .sort([["updatedAt", -1]]);
        res.send({ is_error: false, data: projects });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};



// Contractor Specific projects

// Retrieve and return all my purchased Projects
exports.contractorPurchasedProjects = async (req, res) => {
    try {

        let query = { purchasedBy: req.params.userId};
        if(req.query && req.query.status !=''){
                if(req.query.status === 'OPEN'){
                    query['status'] = true
                }
                if(req.query.status === 'CLOSED'){
                    query['status'] = false
                }
        }
        console.log("final query contractor purchased proects", query)

        const projects = await opportunityPaymentModel.find(query)
            .populate([{ path: 'project_id' }])
            .sort([["createdAt", -1]]);
            res.send({ is_error: false, data: projects });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// Retrieve and return all my Bidden Projects
exports.contractorBiddenProjects = async (req, res) => {
    try {

        let query = { submitted_by: req.params.userId};
        if(req.query && req.query.status !=''){
                if(req.query.status === 'OPEN'){
                    query['status'] = true
                }
                if(req.query.status === 'CLOSED'){
                    query['status'] = false
                }
        }
        console.log("final query", query)

        const projects = await bidSubmissionModel.find(query)
            .populate([{ path: 'project_id' }])
            .sort([["createdAt", -1]]);
            res.send({ is_error: false, data: projects });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// ########################   Old Methods- OLD FUNCTIONS NOT IN USE AS OF NOW ############################################

// Change project status
exports.changeStatus = async (req, res) => {
    const loggedInUser = helper.getCurrentUser(req.headers.authorization);

    await projectModel.findByIdAndUpdate(req.params.projectId, {
        project_status: req.body.project_status,
        updated_by: loggedInUser.data._id
    }, { new: true })
        .then(projectData => {
            if (!projectData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Invalid Project Details."
                });
            }
            const notifyMsg = req.body.status ? 'Opened' : 'Closed';
            res.send({ 'message': 'Project has been marked as' + ' ' + notifyMsg });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Project details not found with provided Id."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating the project status."
            });
        });
};

// Retrieve and return user assigned projects.
exports.getUserAssignedProjects = async (req, res) => {
    try {
        const loggedInUser = helper.getCurrentUser(req.headers.authorization);
        let query = { is_deleted: false };
        if (loggedInUser.data.role === 'INSPECTOR') {
            // query = {is_deleted: false}
            query = { $or: [{ assignedInspector: loggedInUser.data._id }, { created_by: loggedInUser.data._id }], is_deleted: false }
        } else if (loggedInUser.data.role === 'MANUFACTURER') {
            query = { is_deleted: false, assignedManufacturers: loggedInUser.data._id }
        } else if (loggedInUser.data.role === 'CONTRACTOR') {
            query = { is_deleted: false, assignedContractor: loggedInUser.data._id }
        } else if (loggedInUser.data.role === 'OWNER') {
            query = { is_deleted: false, assignedOwner: loggedInUser.data._id }
        } else if (loggedInUser.data.role === 'MANAGER') {
            query = { is_deleted: false, assignedManager: loggedInUser.data._id }
        }
        console.log("final Query", query)

        if (req.query.limit) {
            const limitCount = parseInt(req.query.limit);
            const currentpage = (req.query.page && req.query.page != '') ? parseInt(req.query.page) : 1;
            const recordsCount = await projectModel.find({ is_deleted: false }).count();

            const projects = await projectModel.find({ is_deleted: false })
                .populate([{ path: 'assignedContractor', select: ['first_name', 'last_name', 'company_name', 'email', 'phone', 'company_logo'] }])
                .populate([{ path: 'assignedInspector', select: ['first_name', 'last_name', 'company_name', 'email', 'phone', 'company_logo'] }])
                .populate([{ path: 'assignedOwner', select: ['first_name', 'last_name', 'company_name', 'email', 'phone', 'company_logo'] }])
                .populate([{ path: 'assignedManager', select: ['first_name', 'last_name', 'company_name', 'email', 'phone', 'company_logo'] }])
                .populate([{ path: 'assignedForeman', select: ['first_name', 'last_name', 'company_name', 'email', 'phone', 'company_logo'] }])
                .populate([{ path: 'created_by', select: ['first_name', 'last_name'] }])
                .populate([{ path: 'updated_by', select: ['first_name', 'last_name'] }])
                .sort([["updatedAt", -1]])
                .skip((+currentpage - 1) * limitCount)
                .limit(limitCount);
            const nextPage = parseInt(currentpage) + 1;
            const totalPages = Math.ceil(recordsCount / limitCount)
            res.send({ is_error: false, data: projects, metaData: { totalRecords: recordsCount, currentPage: currentpage, nextPage: nextPage, totalPage: totalPages } });
        }
        else {
            const recordsCount = await projectModel.find({ is_deleted: false }).count();

            const projects = await projectModel.find({ is_deleted: false })
                .populate([{ path: 'assignedContractor', select: ['first_name', 'last_name', 'company_name', 'email', 'phone', 'company_logo'] }])
                .populate([{ path: 'assignedInspector', select: ['first_name', 'last_name', 'company_name', 'email', 'phone', 'company_logo'] }])
                .populate([{ path: 'assignedOwner', select: ['first_name', 'last_name', 'company_name', 'email', 'phone', 'company_logo'] }])
                .populate([{ path: 'assignedManager', select: ['first_name', 'last_name', 'company_name', 'email', 'phone', 'company_logo'] }])
                .populate([{ path: 'assignedForeman', select: ['first_name', 'last_name', 'company_name', 'email', 'phone', 'company_logo'] }])

                .populate([{ path: 'created_by', select: ['first_name', 'last_name'] }])
                .populate([{ path: 'updated_by', select: ['first_name', 'last_name'] }])
                .sort([["updatedAt", -1]]);
            res.send({ is_error: false, data: projects, metaData: { totalRecords: recordsCount, currentPage: 1, nextPage: '', totalPage: 1 } });
        }
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// Find a project documents media by project id
exports.getProjectDocuments = async (req, res) => {

    mediaModel.find({ ref_id: req.params.id, deleted: false })
        .then(async response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Project Media not found with id " + req.params.id
                });
            }
            res.send({ is_error: false, data: response, });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Project Media not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Project Media details with id " + req.params.id
            });
        });
};


// Method will delete Media from the directory Path- SS
deleteMedia = async (req) => {
    // delete all uploaded project media files
    const mediaRootPath = "public/uploads/" + req.body.owner_id + '/buildings/' + req.body.building_id + '/projects/';;
    const mediaKey = Object.keys(req.files);
    console.log("Delete Media called with", mediaKey)
    console.log("mediaRootPath",mediaRootPath);

    mediaKey.forEach(async key => {
      if (req.files[key].length && req.files[key].length > 0) {
        // multiple files
        const MediaFiles = req.files[key];
        console.log("MediaFiles",MediaFiles);
        await MediaFiles.forEach(async mediaFile => {
          // call util method to remove file from location
          mediaUtils.unlink(mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename);
        })
      }
    })
}