const ownerTypeModel = require('../model/ownerTypes');

//   OwnerType Speciifc Functions

exports.getOwnerTypes = async (req, res) => {
    try {
        const responsedata = await ownerTypeModel.find({}).sort([["owner_type_name", 1]]);
        return res.send({ "is_error": false, data: responsedata })
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured" + error });
    }
};

// Create New OwnerType
exports.addOwnerType = async (req, res) => {
    console.log("req.body", req.body)
    // Our Add user logic starts here
    try {
        // Get user input
        const { owner_type_name} = req.body;

        // Validate user input
        if (!owner_type_name) {
            return res.status(400).send({ "is_error": true, "message": "Owner Type name is required" });
        }

        // Validate if record exist in our database
        const oldRecord = await ownerTypeModel.findOne({ owner_type_name: req.body.owner_type_name });

        if (oldRecord) {
            return res.status(409).send({ "is_error": true, "message": "Record Already Exist with Same Name." });
        }

        // Create record in our database
        const record = await ownerTypeModel.create({
            owner_type_name,
        });

        // return new record
        res.status(200).json({ is_error: false, data: record });
    } catch (err) {
        console.log(err);
        res.status(500).json({ is_error: true, data: {}, message: "Error While Creating owner type.Please try again." + err });

    }
    // Our Add logic ends here

};

exports.findOne = async (req, res) => {
    ownerTypeModel.findById(req.params.id)
        .then(userData => {
            if (!userData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Rcord not found with id " + req.params.userId
                });
            }
            res.send({ is_error: false, data: userData });
        }).catch(err => {
            console.log("err", err)
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Record not found with id " + req.params.userId
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Record with id " + req.params.userId
            });
        });
};

exports.updateOwnerType = async (req, res) => {
     
    // Get user input
     const { owner_type_name} = req.body;

    // Validate Request
    if (!owner_type_name) {
        return res.status(400).send({ "is_error": true, "message": "All inputs are required." });
    }
    // Validate if record exist in our database
    const oldRecord = await ownerTypeModel.find({ owner_type_name: req.body.owner_type_name, _id: { $ne: req.params.id } });
    console.log("old user", oldRecord)
    if (oldRecord.length > 0) {
        return res.status(409).send({ "is_error": true, "message": "Record already exist with same name." });
    }
    // Find record and update it with the request body
    await ownerTypeModel.findByIdAndUpdate(req.params.id, {
        owner_type_name: req.body.owner_type_name,
    }, { new: true })
        .then(result => {
            if (!result) {
                return res.status(404).send({
                    is_error: true,
                    message: "Record details not found."
                });
            }
            res.send({
                is_error: false,
                data: result
            });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Record details not found with provided Id."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Record updating the account details."
            });
        });
};

// Delete a Owner type  with the specified id in the request
exports.delete = (req, res) => {
    ownerTypeModel.findByIdAndRemove(req.params.id)
    .then(responseData => {
        if(!responseData) {
            return res.status(404).send({
                is_error : true,
                message: "Owner type not found with id " + req.params.id
            });
        }
        res.send({is_error : false, message: "Owner type deleted successfully!"});
    }).catch(err => {
        if(err.kind === 'ObjectId' || err.name === 'NotFound') {
            return res.status(404).send({
                is_error : true,
                message: "Owner type not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Could not delete Owner type with id " + req.params.id
        });
    });
};