const projectModel = require('../../model/projects');
const userModel = require('../../model/user');

const opportunityPaymentModel = require('../../model/opportunityPayment');
const bidSubmissionModel = require('../../model/project_bid_submission');


const helper = require('../../middleware/_helper');


// Retrieve and return all projects from the database.
exports.findAll = async (req, res) => {
    // projectModel.updateMany({}, {'size_unit':'Sq.Ft.'} , {new: true})
    // .then(async response => {
    //     console.log("Success")
    // })
    try {
        const loggedInUser = helper.getCurrentUser(req.headers.authorization);
        console.log("loggedInUser", loggedInUser)
        const ownerLocationDetails = await userModel.findById(loggedInUser.data._id);
        // let query = { is_deleted: false , country: contractorLocationDetails.country , state: contractorLocationDetails.state};
        let query = { is_deleted: false , project_status: true ,  parent_id: null ,owner_id: loggedInUser.data._id };

        if(req.query && req.query.status !=''){
                if(req.query.status === 'OPEN'){
                    query['status'] = true
                }
                if(req.query.status === 'CLOSED'){
                    query['status'] = false
                }
        }
        console.log("final query", query)

        const projects = await projectModel.find(query)
            .populate([{ path: 'assignedManufacturers', select: ['first_name', 'last_name', 'company_name', 'email', 'phone', 'company_logo'] }])
            .populate([{ path: 'owner_id', select: ['first_name', 'last_name', 'company_name', 'email', 'phone', 'company_logo'] }])
            .populate([{ path: 'building_id' }])
            .populate([{ path: 'created_by', select: ['first_name', 'last_name'] }])
            .populate([{ path: 'updated_by', select: ['first_name', 'last_name'] }])
            .populate([{ path: "buyers", match: { deleted: false } }])
            .sort([["updatedAt", -1]]);
            console.log("Found projects",projects.length )
        res.send({ is_error: false, data: projects });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// Find a project details
exports.findOne = async (req, res) => {

    const loggedInUser = helper.getCurrentUser(req.headers.authorization);
    console.log("loggedInUser", loggedInUser)
    const userId = loggedInUser.data._id;

    let mediaQuery = { deleted: false , project_status: true };

    projectModel.findOne({_id:req.params.id , owner_id: userId})
    .populate([{ path: "media", match: mediaQuery }])
        // .populate([{path:'assignedProjects', select:['first_name','last_name','company_name', 'email','phone','company_logo']}])
        // .populate([{path:'owner_id', select:['first_name','last_name','company_name', 'email','phone','company_logo']}])
        .populate([{path:'associatedProjects'}])
        // .populate({
        //     path: 'associatedProjects',
        //     // Get child templates of templates - populate the 'Child template' array for every Template
        //     populate: { path: 'building_id' },
        //     populate: ({
        //         path: 'assignedManufacturers',
        //         select: ['first_name', 'last_name', 'company_name', 'email', 'phone', 'company_logo']
        //     })
        // })
        // .populate([{path:'created_by', select:['first_name','last_name']}])
        // .populate([{path:'updated_by', select:['first_name','last_name']}])
        .then(async response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Project not found with id " + req.params.id
                });
            }
            // const isBuyer = (isOpportunityPurchased.length > 0) ? true : false ;
            // const isBuyer = (isAvailableInBuyerList.length > 0) ? true : false ;
            res.send({ is_error: false, data: response , verifiedBuyer: true });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Project not found with id " + req.params.id
                });
            }
            console.log(err)
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Project details with id " + req.params.id
            });
        });
};

// Retrieve and return all my purchased Projects
exports.myPurchasedProjects = async (req, res) => {
    try {
        const loggedInUser = helper.getCurrentUser(req.headers.authorization);
        console.log("loggedInUser", loggedInUser)
        let query = { purchasedBy: loggedInUser.data._id};
        if(req.query && req.query.status !=''){
                if(req.query.status === 'OPEN'){
                    query['status'] = true
                }
                if(req.query.status === 'CLOSED'){
                    query['status'] = false
                }
        }
        console.log("final query", query)

        const projects = await opportunityPaymentModel.find(query)
            .populate([{ path: 'project_id' }])
            .sort([["createdAt", -1]]);
            res.send({ is_error: false, data: projects });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// Retrieve and return all my Bidden Projects
exports.myBiddenProjects = async (req, res) => {
    try {
        const loggedInUser = helper.getCurrentUser(req.headers.authorization);
        console.log("loggedInUser", loggedInUser)
        let query = { submitted_by: loggedInUser.data._id};
        if(req.query && req.query.status !=''){
                if(req.query.status === 'OPEN'){
                    query['status'] = true
                }
                if(req.query.status === 'CLOSED'){
                    query['status'] = false
                }
        }
        console.log("final query", query)

        const projects = await bidSubmissionModel.find(query)
            .populate([{ path: 'project_id' }])
            .sort([["createdAt", -1]]);
            res.send({ is_error: false, data: projects });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};


