const paymentIntentModel = require('../../model/payment_intent');
const transactionModel = require('../../model/transactions');
const opportunityPaymentModel = require('../../model/opportunityPayment');

const projectModel = require('../../model/projects');
const userModel = require('../../model/user');

const helper = require('../../middleware/_helper');

exports.makePayment = async (req, res) => {
    try {
      const obj = { _id: req.body.id };
      const loggedInUser = helper.getCurrentUser(req.headers.authorization);
      const userId = loggedInUser.data._id;
        // const userId = '656b20d6bc4f67e4b6ceec1d';
      // check if user already purchased this project or not.
      const userHasAlreadyPurchased = await opportunityPaymentModel.find({ purchasedBy: userId, project_id: req.body.id });
      // check if user already purchased thie project
      if (userHasAlreadyPurchased.length > 0) {
        return res.status(409).send({
            is_error: true,
            message: "You have already purchased this opportunity."
        });
      }
      const result = await projectModel.findOne(obj);

      if (result) {
        console.log("now Good to go for intitiate payment Intent", result);

        const payload = {
            project_id: req.body.id,
            purchasedBy: userId,
            amount: result.bidder_fees,
            currency: 'usd',
            payment_status: 'SUCCESS'
        }

        const oppObj = new opportunityPaymentModel(payload);

        // Save Opportunity Payment to database
        oppObj.save()
          .then(async returnResponse => {
              console.log("Opp payment details has been saved in DB record");
            // now Save the Contractor ID in Project Colletions as verified Buyers
            //  if consolidated bid type then update all associated projects with contractor id in all projects
            if(result.bid_type === 'CONSOLIDATED'){
              if(result.associatedProjects && result.associatedProjects.length>0){

                projectModel.updateMany({_id:{$in:result.associatedProjects}}, { $addToSet: { opportunityBuyers: userId } } , {new: true})
                .then(async response => {
                    console.log("Success")
                })
              }
            }

            // If Std Bid type then go with update the single project with contractor id
            const responsedata = await projectModel.findOneAndUpdate({_id:req.body.id},{ $addToSet: { opportunityBuyers: userId } });

            // Return a 200 response to acknowledge receipt of the event
            res.send({ data: returnResponse, message: "Payment Successfull. Please Submit Your Bid Now." });
          }).catch(err => {
              console.log("Booking records save error", err);
            res.status(500).send({
              is_error: true,
              message: err.message || "Some error occurred while processing your payment request."
            });
          });

      } else {
        return res.status(500).send({
            is_error: true,
            message: "Sorry, There is no project opportunity found. Please try again."
        });
      }
  
    } catch (error) {
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
}