const masterLineItemModel = require('../model/master_line_item');

//   Get all Master Bid Line Items

exports.getMasterLineItems = async (req, res) => {
    try {
        const responsedata = await masterLineItemModel.find({}).sort([["title", 1]]);
        return res.send({ "is_error": false, data: responsedata })
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured" + error });
    }
};

// Create New Bid Line Items
exports.addMasterLineItem = async (req, res) => {
    console.log("req.body", req.body)
    // Our Add user logic starts here
    try {
        // Get user input
        const { title , description, default_value} = req.body;

        // Validate user input
        if (!title) {
            return res.status(400).send({ "is_error": true, "message": "Title name is required" });
        }

        // Validate if record exist in our database
        const oldRecord = await masterLineItemModel.findOne({ title: req.body.title });

        if (oldRecord) {
            return res.status(409).send({ "is_error": true, "message": "Record Already Exist with Same Name." });
        }

        // Create record in our database
        const record = await masterLineItemModel.create({
            title,
            description,
            default_value
        });

        // return new record
        res.status(200).json({ is_error: false, data: record });
    } catch (err) {
        console.log(err);
        res.status(500).json({ is_error: true, data: {}, message: "Error While Creating Bid Line Items. Please try again." + err });

    }
    // Our Add logic ends here
};

exports.findOne = async (req, res) => {
    masterLineItemModel.findById(req.params.id)
        .then(responseData => {
            if (!responseData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Rcord not found with id " + req.params.userId
                });
            }
            res.send({ is_error: false, data: responseData });
        }).catch(err => {
            console.log("err", err)
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Record not found with id " + req.params.userId
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Record with id " + req.params.userId
            });
        });
};

exports.updateMasterLineItem = async (req, res) => {
     
    // Get user input
     const { title, description ,default_value} = req.body;

    // Validate Request
    if (!title) {
        return res.status(400).send({ "is_error": true, "message": "All inputs are required." });
    }
    // Validate if record exist in our database
    const oldRecord = await masterLineItemModel.find({ title: req.body.title, _id: { $ne: req.params.id } });
    console.log("old user", oldRecord)
    if (oldRecord.length > 0) {
        return res.status(409).send({ "is_error": true, "message": "Record already exist with same name." });
    }
    // Find record and update it with the request body
    await masterLineItemModel.findByIdAndUpdate(req.params.id, {
        title: req.body.title,
        description: req.body.description,
        default_value: req.body.default_value
    }, { new: true })
        .then(result => {
            if (!result) {
                return res.status(404).send({
                    is_error: true,
                    message: "Record details not found."
                });
            }
            res.send({
                is_error: false,
                data: result
            });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Record details not found with provided Id."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating the record."
            });
        });
};


// Delete a Master Line Item  with the specified id in the request
exports.delete = (req, res) => {
    masterLineItemModel.findByIdAndRemove(req.params.id)
    .then(responseData => {
        if(!responseData) {
            return res.status(404).send({
                is_error : true,
                message: "Master Line Item not found with id " + req.params.id
            });
        }
        res.send({is_error : false, message: "Master Line Item  deleted successfully!"});
    }).catch(err => {
        if(err.kind === 'ObjectId' || err.name === 'NotFound') {
            return res.status(404).send({
                is_error : true,
                message: "Master Line Item not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Could not delete Master Line Item with id " + req.params.id
        });
    });
};