const intakeFormModel = require('../model/intakeForms');
const mediaModel = require('../model/projectMedia');

const helper = require('../middleware/_helper');
const mediaUtils = require("../config/unlinkMedia");

// Create and Save a new project
exports.create = (req, res) => {
    console.log("project Body data", req.body)
    // Validate request
    // if (!(req.body.name && req.body.description && req.body.start_date && req.body.end_date && req.body.total_cost && req.body.total_size && req.body.country && req.body.state && req.body.city)) {
    //     return res.status(400).send({"is_error": true , "message": "All input is required"});
    //   }

    const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);

    let payload = {
        name: req.body.name,
        description: req.body.description ? req.body.description : "",
        start_date: req.body.start_date,
        end_date: req.body.end_date,
        total_size: req.body.total_size,
        total_cost: req.body.total_cost,
        assignedManufacturers: req.body.assignedManufacturers ? JSON.parse(req.body.assignedManufacturers) : [],
        assignedContractor: req.body.assignedContractor,
        assignedOwner: req.body.assignedOwner,
        assignedInspector: req.body.assignedInspector,
        // assignedManager: req.body.assignedManager ? JSON.parse(req.body.assignedManager) : [],
        phone: req.body.phone ? req.body.phone : "",
        country: req.body.country ? req.body.country : "",
        state: req.body.state ? req.body.state : "",
        city: req.body.city ? req.body.city : "",
        zip_code: req.body.zip_code ? req.body.zip_code : "",
        address_line: req.body.address_line ? req.body.address_line : "",
        project_notes: req.body.project_notes ? req.body.project_notes : "",
        is_active: req.body.is_active,
        created_by: loggedInUser.data.user_id,
        deleted:false
      }

      if(req.body.assignedManager){
        payload['assignedManager'] = JSON.parse(req.body.assignedManager) ;
      }
    // Create project payload
    const project = new intakeFormModel(payload);

    // Save Project in the database
    project.save()
    .then(async data => {
        let media = [];
        const mediaRootPath = "public/uploads/projects/";
        const mediaKey = Object.keys(req.files);
        mediaKey.forEach(async key => {
            if (req.files[key].length && req.files[key].length > 0) {
                // multiple files
                const projectMediaFiles = req.files[key];
                await projectMediaFiles.forEach(async mediaFile => {
                    media.push({
                        path: mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename,
                        filename: mediaFile.filename,
                        ref_id: data._id,
                        type: mediaFile.fieldname,
                        mimetype: mediaFile.mimetype,
                        extn: (mediaFile.filename.split('.').pop()).toLowerCase()
                    });
                })

            } else {
                console.log("Else condition block")
            }
        })
        // store all images,documents and videos
        await mediaModel.insertMany(media);

        res.send({is_error : false, data: data });
    }).catch(err => {
        // delete all uploaded project media files from directory
        const mediaRootPath = "public/uploads/projects/";
        const mediaKey = Object.keys(req.files);
        mediaKey.forEach(async key => {
            if (req.files[key].length && req.files[key].length > 0) {
                // multiple files
                const projectMediaFiles = req.files[key];
                await projectMediaFiles.forEach(async mediaFile => {
                    // call util method to remove file from location
                    mediaUtils.unlink(mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename);
                })
            }
        })
        return res.status(500).send({
            is_error : true,
            message: err.message || "Some error occurred while creating the project."
        });
    });
};

// Retrieve and return all projects from the database.
exports.findAll = async (req, res) => {
    intakeFormModel.updateMany({}, {'size_unit':'Sq.Ft.'} , {new: true})
    .then(async response => {
        console.log("Success")
    })
    try {
        const projects = await intakeFormModel.find({})
        .populate([{path:'assignedManufacturers', select:['first_name','last_name','company_name', 'email','phone']}])
        .populate([{path:'assignedContractor', select:['first_name','last_name','company_name', 'email','phone']}])
        .populate([{path:'assignedInspector', select:['first_name','last_name','company_name', 'email','phone']}])
        .populate([{path:'assignedOwner', select:['first_name','last_name','company_name', 'email','phone']}])
        .populate([{path:'assignedManager', select:['first_name','last_name','company_name', 'email','phone']}])
        .populate([{path:'created_by', select:['first_name','last_name']}])
        .populate([{path:'updated_by', select:['first_name','last_name']}])
        .sort([["updatedAt",-1]]);
        res.send({is_error : false, data: projects});
    } catch (error) {
        console.log(error);
        return res.send({"is_error": true , "message": "An error occured : " + error});
    }
  };

// Find a project details
exports.findOne = async (req, res) => {

    intakeFormModel.findById(req.params.id)
    .populate([{path:'assignedManufacturers', select:['first_name','last_name','company_name', 'email','phone']}])
    .populate([{path:'assignedContractor', select:['first_name','last_name','company_name', 'email','phone']}])
    .populate([{path:'assignedInspector', select:['first_name','last_name','company_name', 'email','phone']}])
    .populate([{path:'assignedOwner', select:['first_name','last_name','company_name', 'email','phone']}])
    .populate([{path:'assignedManager', select:['first_name','last_name','company_name', 'email','phone']}])
    .populate([{path:'created_by', select:['first_name','last_name']}])
    .populate([{path:'updated_by', select:['first_name','last_name']}])
    .then(async response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Project not found with id " + req.params.id
            });            
        }
        const projectMedia = await mediaModel.find({ref_id: req.params.id, deleted: false});
        console.log("projectMedia", projectMedia);
        response.mediaFiles = projectMedia ;
        res.send({is_error : false, data: response, mediaFiles: projectMedia });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Project not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving Project details with id " + req.params.id
        });
    });
};

// Update a project
exports.update = (req, res) => {
    // console.log("req.body", req.files);
    console.log("req.params", JSON.parse(req.body.assignedManufacturers))
    const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
    let payload = {
        name: req.body.name,
        description: req.body.description ? req.body.description : "",
        start_date: req.body.start_date,
        end_date: req.body.end_date,
        total_size: req.body.total_size,
        total_cost: req.body.total_cost,
        assignedManufacturers: req.body.assignedManufacturers ? JSON.parse(req.body.assignedManufacturers) : [],
        assignedContractor: req.body.assignedContractor,
        assignedOwner: req.body.assignedOwner,
        assignedInspector: req.body.assignedInspector,
        // assignedManager: req.body.assignedManager ? JSON.parse(req.body.assignedManager) : [],
        phone: req.body.phone ? req.body.phone : "",
        country: req.body.country ? req.body.country : "",
        state: req.body.state ? req.body.state : "",
        city: req.body.city ? req.body.city : "",
        zip_code: req.body.zip_code ? req.body.zip_code : "",
        address_line: req.body.address_line ? req.body.address_line : "",
        project_notes: req.body.project_notes ? req.body.project_notes : "",
        is_active: req.body.is_active,
        updated_by: loggedInUser.data.user_id,
        deleted: false
      };
      if(req.body.assignedManager){
        payload['assignedManager'] = JSON.parse(req.body.assignedManager) ;
      }
     console.log("payload",payload)
     const existingFilesData = JSON.parse(req.body.existingFilesData);
     console.log("existingFilesData", existingFilesData)

    // Find project and update it with the request body
    intakeFormModel.findByIdAndUpdate(req.params.id, payload , {new: true})
    .then(async response => {
        let media = [];
        const mediaRootPath = "public/uploads/projects/";
        const mediaKey = Object.keys(req.files);
        mediaKey.forEach(async key => {
            if (req.files[key].length && req.files[key].length > 0) {
                // multiple files
                const projectMediaFiles = req.files[key];
                await projectMediaFiles.forEach(async mediaFile => {
                    media.push({
                        path: mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename,
                        filename: mediaFile.filename,
                        ref_id: response._id,
                        type: mediaFile.fieldname,
                        mimetype: mediaFile.mimetype,
                        extn: (mediaFile.filename.split('.').pop()).toLowerCase()
                    });
                })

            } else {
                console.log("Else condition block")
            }
        })

        if(!response) {
            // remove all recently uploaded images from directory
            media.forEach(element => {
                mediaUtils.unlink(element.path);
            });
            return res.status(404).send({
                is_error : true,
                message: "Project not found with id " + req.params.id
            });
        }
        // store all images,documents and videos
        await mediaModel.insertMany(media);
       // Remove all the removed media from directory and Media Collection
       if (req.body.existingFilesData) {
            const filesTobeRemoved = JSON.parse(req.body.existingFilesData);
            await filesTobeRemoved.forEach(element => {
                if(element.deleted){
                    mediaUtils.unlink(element.path);
                    // delete record from Media collection
                    mediaModel.findByIdAndUpdate(element._id,element).exec();
                }else{
                    // only update the records with updated data of description
                    mediaModel.findByIdAndUpdate(element._id,element).exec();
                }
            });
        }
        res.send( { is_error : false, data: response });
    }).catch(err => {
        // delete all uploaded project media files from directory
        const mediaRootPath = "public/uploads/projects/";
        const mediaKey = Object.keys(req.files);
        mediaKey.forEach(async key => {
            if (req.files[key].length && req.files[key].length > 0) {
                // multiple files
                const projectMediaFiles = req.files[key];
                await projectMediaFiles.forEach(async mediaFile => {
                    // call util method to remove file from location
                    mediaUtils.unlink(mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename);
                })
            }
        })

        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Project not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error updating Project details with id " + err
        });
    });
};

// Delete a project with the specified id in the request
exports.delete = (req, res) => {
    intakeFormModel.findByIdAndRemove(req.params.id)
    .then(responseData => {
        if(!responseData) {
            return res.status(404).send({
                is_error : true,
                message: "Project not found with id " + req.params.id
            });
        }
        res.send({is_error : false, message: "Project deleted successfully!"});
    }).catch(err => {
        if(err.kind === 'ObjectId' || err.name === 'NotFound') {
            return res.status(404).send({
                is_error : true,
                message: "Project not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Could not delete Project with id " + req.params.id
        });
    });
};

// Change project status
exports.changeStatus = async (req, res) => {
    const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);

    await intakeFormModel.findByIdAndUpdate(req.params.projectId, {
        is_active: req.body.is_active,
        updated_by: loggedInUser.data.user_id
    }, { new: true })
        .then(projectData => {
            if (!projectData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Invalid Project Details."
                });
            }
            const notifyMsg = req.body.is_active ? 'Opened' : 'Closed';
            res.send({'message': 'Project has been marked as' +' '+ notifyMsg });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Project details not found with provided Id."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating the project status."
            });
        });
};

// Retrieve and return user assigned projects.
exports.getUserAssignedProjects = async (req, res) => {
    try {
        const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
        let query = {is_deleted: false } ;
        if(loggedInUser.data.role === 'INSPECTOR'){
                // query = {is_deleted: false}
            query = {$or:[{assignedInspector: loggedInUser.data.user_id} , {created_by: loggedInUser.data.user_id }], is_deleted:false}
        }else if(loggedInUser.data.role === 'MANUFACTURER'){
            query = {is_deleted: false, assignedManufacturers: loggedInUser.data.user_id}
        }else if(loggedInUser.data.role === 'CONTRACTOR'){
            query = {is_deleted: false, assignedContractor: loggedInUser.data.user_id}
        }else if(loggedInUser.data.role === 'OWNER'){
            query = {is_deleted: false, assignedOwner: loggedInUser.data.user_id}
        }else if(loggedInUser.data.role === 'MANAGER'){
            query = {is_deleted: false, assignedManager: loggedInUser.data.user_id}
        }
        console.log("final Query", query)

        if (req.query.limit) {
            const limitCount = parseInt(req.query.limit);
            const projects = await intakeFormModel.find(query)
            .populate([{path:'assignedContractor', select:['first_name','last_name','company_name', 'email','phone']}])
            .populate([{path:'assignedInspector', select:['first_name','last_name','company_name', 'email','phone']}])
            .populate([{path:'assignedOwner', select:['first_name','last_name','company_name', 'email','phone']}])
            .populate([{path:'assignedManager', select:['first_name','last_name','company_name', 'email','phone']}])
            .populate([{path:'created_by', select:['first_name','last_name']}])
            .populate([{path:'updated_by', select:['first_name','last_name']}])
            .sort([["updatedAt",-1]])
            .limit(limitCount);
            res.send({is_error : false, data: projects});
        }
        else {
            const projects = await intakeFormModel.find(query)
            .populate([{path:'assignedContractor', select:['first_name','last_name','company_name', 'email','phone']}])
            .populate([{path:'assignedInspector', select:['first_name','last_name','company_name', 'email','phone']}])
            .populate([{path:'assignedOwner', select:['first_name','last_name','company_name', 'email','phone']}])
            .populate([{path:'assignedManager', select:['first_name','last_name','company_name', 'email','phone']}])
            .populate([{path:'created_by', select:['first_name','last_name']}])
            .populate([{path:'updated_by', select:['first_name','last_name']}])
            .sort([["updatedAt",-1]]);
            res.send({is_error : false, data: projects});
        }
    } catch (error) {
        console.log(error);
        return res.send({"is_error": true , "message": "An error occured : " + error});
    }
  };

// Find a project documents media by project id
exports.getProjectDocuments = async (req, res) => {

    mediaModel.find({ref_id: req.params.id , deleted: false})
    .then(async response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Project Media not found with id " + req.params.id
            });            
        }
        res.send({is_error : false, data: response,});
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Project Media not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving Project Media details with id " + req.params.id
        });
    });
};