const FaqModel = require('../model/faq');

//   Get all FAQs

exports.getFAQs = async (req, res) => {
    try {
        const responsedata = await FaqModel.find({}).sort([["title", 1]]);
        return res.send({ "is_error": false, data: responsedata })
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured" + error });
    }
};

// Create FAQs
exports.addFAQs = async (req, res) => {
    console.log("req.body", req.body)
    // Our Add faq logic starts here
    try {
        // Get user input
        const { title , description} = req.body;

        // Validate user input
        if (!title) {
            return res.status(400).send({ "is_error": true, "message": "Title name is required" });
        }

        // Validate if record exist in our database
        const oldRecord = await FaqModel.findOne({ title: req.body.title });

        if (oldRecord) {
            return res.status(409).send({ "is_error": true, "message": "Record Already Exist with Same Name." });
        }

        // Create record in our database
        const record = await FaqModel.create({
            title,
            description
        });

        // return new record
        res.status(200).json({ is_error: false, data: record });
    } catch (err) {
        console.log(err);
        res.status(500).json({ is_error: true, data: {}, message: "Error While saving FAQs. Please try again." + err });

    }
    // Our Add logic ends here
};

exports.findOne = async (req, res) => {
    FaqModel.findById(req.params.id)
        .then(responseData => {
            if (!responseData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Rcord not found with id " + req.params.userId
                });
            }
            res.send({ is_error: false, data: responseData });
        }).catch(err => {
            console.log("err", err)
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Record not found with id " + req.params.userId
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Record with id " + req.params.userId
            });
        });
};

exports.updateFAQs = async (req, res) => {
     
    // Get user input
     const { title, description } = req.body;

    // Validate Request
    if (!title) {
        return res.status(400).send({ "is_error": true, "message": "All inputs are required." });
    }
    // Validate if record exist in our database
    const oldRecord = await FaqModel.find({ title: req.body.title, _id: { $ne: req.params.id } });
    console.log("old user", oldRecord)
    if (oldRecord.length > 0) {
        return res.status(409).send({ "is_error": true, "message": "Record already exist with same name." });
    }
    // Find record and update it with the request body
    await FaqModel.findByIdAndUpdate(req.params.id, {
        title: req.body.title,
        description: req.body.description
    }, { new: true })
        .then(result => {
            if (!result) {
                return res.status(404).send({
                    is_error: true,
                    message: "Record details not found."
                });
            }
            res.send({
                is_error: false,
                data: result
            });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Record details not found with provided Id."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating the record."
            });
        });
};


// Delete FAQs
exports.delete = (req, res) => {
    FaqModel.findByIdAndRemove(req.params.id)
    .then(responseData => {
        if(!responseData) {
            return res.status(404).send({
                is_error : true,
                message: "FAQ not found with id " + req.params.id
            });
        }
        res.send({is_error : false, message: "FAQ deleted successfully!"});
    }).catch(err => {
        if(err.kind === 'ObjectId' || err.name === 'NotFound') {
            return res.status(404).send({
                is_error : true,
                message: "FAQ not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Could not delete FAQ with id " + req.params.id
        });
    });
};