const questionModel = require('../../model/questionAnswers');
const projectModel = require('../../model/projects');
const userModel = require('../../model/user');
const helper = require('../../middleware/_helper');


exports.submitQuestion = async (req, res) => {
    try {
        const loggedInUser = helper.getCurrentUser(req.headers.authorization);
        const userId = loggedInUser.data._id;

        const contractorDetails = await userModel.findOne({ _id: userId , deleted:false});
        const projectDetails = await projectModel.findOne({ _id: req.body.project_id});
        const rpcManagers = await userModel.find({ role: 'RPC_MANAGER', deleted:false})
        .select("-__v -createdAt -updatedAt -password -otp -mobile_no -phone_no -profile_pic -city -state -country -zip_code");
        var RPCManagersEmails = await rpcManagers.map(function (details) {
            return details['email'];
        });

        console.log("rpc manager emails", RPCManagersEmails)

        if(!projectDetails){
            return response.badRequest(res, 400, "Please check the project details. We are unable to reterive project details.");
        }
        const addQuesPayload = new questionModel(
            {
                question_text:req.body.question_text,
                created_by:userId,
                project_id:req.body.project_id,
                publish_status: false
            });
        addQuesPayload.save()
        .then(async data => {
            if (data){
                // const emailData = {
                //     msg: {
                //       to: RPCManagersEmails, // all rpc managers emails
                //       from: 'Winston@roofingprojects.com', // Use the email address or domain you verified above
                //       template_id: EMAIL_TEMPLATES.NEW_QUESTION_SUBMIT_TEMPLATE_ID,
                //       dynamic_template_data:{
                //         "first_name":contractorDetails ? contractorDetails.first_name :"Guest User",
                //         "last_name":contractorDetails ? contractorDetails.last_name :"Unregistered",
                //         "project_name":projectDetails ? projectDetails.project_question_text : 'Project Details Not Available',
                //         "question_text": req.body.question_text ? req.body.question_text : 'Question details not available.'
                //     }
                //     }
                //   };
                //   mail.sendMailWithTemplate(emailData);
                return res.send({ "is_error": false, data: data }) ;
            }
            else{
                return res.status(500).json({ is_error: true, data: {}, message: "Error While submit your question.Please try again."});
            }
        }).catch(err => {
            return res.status(500).send({
                message: err.message || "Some error occurred while submit your Question."
            });
        });
    } catch (e) {
        console.log(e)
        return res.send({ "is_error": true, "message": "An error occured" + e });

    }
}


exports.getProjectSpecificQuestions = async (req, res) => {
    try {
        if(req.params.id && req.params.id !=''){
            const filter = { project_id: req.params.id , publish_status: true };
            const result = await questionModel.find(filter)
            .populate([{path:'created_by' ,select: ['first_name', 'last_name', 'company_name', 'role'] } ])
            .sort({createdAt:-1});
            return res.send({ "is_error": false, data: result })

        }else{
            return res.status(409).send({ "is_error": true, "message": "Please provide the correct project reference." });
        }
        
    } catch (error) {
        return res.send({ "is_error": true, "message": "An error occured" + error });
    }
}

exports.getMyaskedQuestions = async (req, res) => {
    try {
        const loggedInUser = helper.getCurrentUser(req.headers.authorization);
        if(req.params.id && req.params.id !=''){
            const filter = { project_id: req.params.id , created_by: loggedInUser.data._id};
            const result = await questionModel.find(filter)
            .sort({createdAt:-1});
            return res.send({ "is_error": false, data: result })

        }else{
            return res.status(409).send({ "is_error": true, "message": "Please provide the correct project reference." });
        }
        
    } catch (error) {
        return res.send({ "is_error": true, "message": "An error occured" + error });
    }
}

// Delete Question
exports.delete = (req, res) => {
    questionModel.findByIdAndRemove(req.params.id)
    .then(responseData => {
        if(!responseData) {
            return res.status(404).send({
                is_error : true,
                message: "Record not found with id " + req.params.id
            });
        }
        res.send({is_error : false, message: "Your Question has been deleted successfully!"});
    }).catch(err => {
        if(err.kind === 'ObjectId' || err.name === 'NotFound') {
            return res.status(404).send({
                is_error : true,
                message: "Question not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Could not delete Question with id " + req.params.id
        });
    });
};