const bidSubmissionModel = require('../../model/project_bid_submission');
const opportunityPaymentModel = require('../../model/opportunityPayment');

const helper = require('../../middleware/_helper');


//   Get All the Bid submissions of Loggedin contractor

exports.myBidSubmissionList = async (req, res) => {
    try {
        const loggedInUser = helper.getCurrentUser(req.headers.authorization);
        const userId = loggedInUser.data._id;
        const responsedata = await bidSubmissionModel.find({submitted_by: userId});
        return res.send({ "is_error": false, data: responsedata })
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured" + error });
    }
};

//   Get Bid submission details of Loggedin contractor

exports.myProjectBidSubmissionDetails = async (req, res) => {
    try {
        const loggedInUser = helper.getCurrentUser(req.headers.authorization);
        const userId = loggedInUser.data._id;
        const responsedata = await bidSubmissionModel.findOne({submitted_by: userId, project_id:req.params.project_id});
        return res.send({ "is_error": false, data: responsedata })
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured" + error });
    }
};

// Save and Submit Project Bid
exports.submitBid = async (req, res) => {
    console.log("req.body", req.body);
    // return res.send("success");
    // Our Add user logic starts here
    try {
        const loggedInUser = helper.getCurrentUser(req.headers.authorization);
        const userId = loggedInUser.data._id;
        // Validate user input
        if (!req.body.project_id ) {
            return res.status(400).send({ "is_error": true, "message": "Project Id is required" });
          }
          if (!req.body.line_items) {
            return res.status(400).send({ "is_error": true, "message": "Bid Form Line Items are required" });
          }
          if (req.body.line_items && req.body.line_items.length == 0) {
            return res.status(400).send({ "is_error": true, "message": "Bid Form Line items cannot be empty." });
          }

        const isAlreadySubmitted = await bidSubmissionModel.find({ submitted_by: userId, project_id : req.body.project_id });
        // check if bid already submitted  by contractor for a selected project
        if (isAlreadySubmitted.length > 0) {
            return res.status(400).send({ "is_error": true, "message": "You have already submitted the Bid on this project. Please modify the existing submission if you wish to do modifications." });
        }

        // Create record in our database
        const record = await bidSubmissionModel.create({
            project_id: req.body.project_id , 
            line_items: req.body.line_items,
            submitted_by: userId,
            selected_manufacturer: '656be6378da1296d6e47bb26',
            line_items_total: req.body.line_items_total,
            total_bid_amount: req.body.total_bid_amount,
            total_bid_amount_in_words: req.body.total_bid_amount_in_words,
            is_draft: true
        });
        
        const responsedata = await opportunityPaymentModel.findOneAndUpdate({purchasedBy: userId, project_id:req.body.project_id},{bid_submitted:true});

        // return new record
        res.status(200).json({ is_error: false, data: record });
    } catch (err) {
        console.log(err);
        res.status(500).json({ is_error: true, data: {}, message: "Error While submitting your Bid. Please try again." + err });

    }
    // Our Add logic ends here
};


exports.updateBid = async (req, res) => {
     
    const loggedInUser = helper.getCurrentUser(req.headers.authorization);
    const userId = loggedInUser.data._id;
    // Validate user input
    if (!req.body.project_id ) {
        return res.status(400).send({ "is_error": true, "message": "Project Id is required" });
        }
        if (!req.body.line_items) {
        return res.status(400).send({ "is_error": true, "message": "Bid Form Line Items are required" });
        }
        if (req.body.line_items && req.body.line_items.length == 0) {
        return res.status(400).send({ "is_error": true, "message": "Bid Form Line items cannot be empty." });
        }

    const payload = {
        line_items: req.body.line_items,
        selected_manufacturer: '656be6378da1296d6e47bb26',
        line_items_total: req.body.line_items_total,
        total_bid_amount: req.body.total_bid_amount,
        total_bid_amount_in_words: req.body.total_bid_amount_in_words,
    }

    // Find record and update it with the request body
    await bidSubmissionModel.findByIdAndUpdate(req.params.id, payload, { new: true })
        .then(result => {
            if (!result) {
                return res.status(404).send({
                    is_error: true,
                    message: "Record details not found."
                });
            }
            res.send({
                is_error: false,
                data: result
            });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Record details not found with provided Id."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating the record."
            });
        });
};