const mongoose = require("mongoose");
const reportModel = require('../model/reports');
const mediaModel = require('../model/reportsMedia');
const projectModel = require('../model/projects');

const User = require('../model/user');
const communicationMessageModel = require('../model/communication_messages');

const emailCtrl = require('./email.controller');
const email_templates = require('../config/email_template_ids');

const helper = require('../middleware/_helper');


// Send Communication Message to selected user and save to DB
exports.sendMessage = async (req, res) => {
    console.log("req.body", req.body)
    if(!req.body.id){
        return res.status(400).send({ "is_error": true, "message": "Please select the correct report." });
    }
    if(req.body.to_users && req.body.to_users.length == 0){
        return res.status(400).send({ "is_error": true, "message": "Please select the email recipient" });
    }
    reportModel.findOne({_id:req.body.id})
    .populate([
        {
            path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line','total_size'],
            populate: { path: 'assignedOwner', select:['first_name','last_name','company_name','company_logo'] }
        }
    ])
    .populate([{path:'inspector_id', select:['first_name','last_name']}])
    .populate([{path:'created_by', select:['first_name','last_name']}])
    .populate([{path:'updated_by', select:['first_name','last_name']}])
    .then(async response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Sorry Message could not send .Invalid Report id" + req.body.id
            });            
        }

    // All good now save the records to communication collection
    
    // Validate if user exist in our database
    const userExist = await User.findOne({ email: req.body.sender_email.toLowerCase() });
    // Get touserIds
    var ToUserIds = await req.body.to_users.map(function (user) {
        return user['_id'];
      });
    // Create user in our database
    const payload = {
        sender_name: req.body.sender_name,
        sender_email: req.body.sender_email,
        senderId: userExist ? userExist._id : null,
        toUserIds: ToUserIds,
        reportId: req.body.id,
        message_title: req.body.message_title,
        message_description: req.body.message_description
      };

    console.log("payload", payload)

     // Create a Message object
     const MsgObj = new communicationMessageModel(payload);

    // Save Message in the database
    MsgObj.save()
    .then(async(data) => {
       
    }).catch(err => {
        return res.status(500).send({
            is_error : true,
            message: err.message || "Some error occurred while sending your message."
        });
    });
    // Send Email to all selected Recepients
    var userEmails = await req.body.to_users.map(function (user) {
        return user['email'];
      });
    userEmails.push('shivam201065@gmail.com')
        //  Write code to send email to users 
        const mailTemplateContent = {
            "subject": req.body.message_title,
            "message_title": req.body.message_title,
            "message_description": req.body.message_description ? (req.body.message_description).replace(/(?:\r\n|\r|\n)/g, '<br>') : '',
            "sender_name": userExist ? (userExist.first_name + ' ' + userExist. last_name) : req.body.sender_name,
            "sender_role": userExist ? userExist.role: 'GUEST USER',
            "to_users_details": [],
            "report_name": response.report_title,
            "communication_message_link": process.env.WEBSITE_URL + '/inspection/communication/' + response._id
        }
    console.log("mailTemplateContent ", mailTemplateContent)
        const emailData = {
            msg: {
                to: userEmails,
                from: process.env.SUPPORT_EMAIL, // Use the email address or domain you verified above
                template_id: email_templates.COMMUNICATION_MESSAGE_DETAILS_EMAIL,
                dynamic_template_data: mailTemplateContent
            },
            userDetails: {}
        }
        // send Email to User with report details.
        emailCtrl.sendEmail(emailData);
    return res.send({is_error : false, data: {} , message: "Your message has been sent successfully."});

    }).catch(err => {
        console.log("error", err)
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Report details not found for" + req.body.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving Report details with id " + req.body.id
        });
    });
};

// Retrieve all messages by reportID
exports.getCommunicationByreportId = async (req, res) => {
    try {
        // const communicationMessageList = await communicationMessageModel.find({reportId: req.params.id})
        // .populate([{path:'senderId', select:['first_name','last_name','email', 'phone']}])
        // .populate([{path:'reportId', select:['report_title']}])
        // .populate([{path:'toUserIds', select:['first_name','last_name','email', 'phone']}])
        // .sort([["createdAt",-1]]);

        const communicationMessageList =   await communicationMessageModel.aggregate([
            { $match: {  'reportId': mongoose.Types.ObjectId(req.params.id) } },
            {
                $lookup: {
                  from: "users",
                  localField: "senderId",
                  foreignField: "_id",
                  as: "sender_details",
                },
              },
              {
                $unwind: { path: "$senderId", preserveNullAndEmptyArrays: true },
              },
              {
                $lookup: {
                  from: "users",
                  localField: "toUserIds",
                  foreignField: "_id",
                  as: "to_users_details",
                },
              },
              {
                $lookup: {
                  from: "reports",
                  localField: "reportId",
                  foreignField: "_id",
                  as: "report_details",
                },
              },
            {
                $group:{ 
                    _id:{$dateToString:{format: "%Y-%m-%d", date: "$createdAt"}},
                    messages: { $push: "$$ROOT" }
                }
            },
            {
                $sort:{_id:-1}
              }
            // {$project: {date: '$_id', senderId: 1,  toUserIds: 1,  message_title: 1,  message_description: 1, _id: 1 ,'sender_details._id':1, 'sender_details.first_name':1 , 'sender_details.last_name':1 }}
          ]) 

        return res.send({"is_error":false , data:communicationMessageList})
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured" + error });
    }
  };

// Find a single Message details
exports.getMessageDetails = async (req, res) => {
    communicationMessageModel.findOne({_id:req.params.id})
    .populate([{path:'senderId', select:['first_name','last_name','email', 'phone']}])
    .populate([{path:'reportId', select:['report_title']}])
    .populate([{path:'toUserIds', select:['first_name','last_name','email', 'phone']}])
    .then(async response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Message Details not found with id " + req.params.id
            });            
        }
        res.send({is_error : false, data: response });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Message Details not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving Message details with id " + req.params.id
        });
    });
};

// Delete communication Message
exports.delete = (req, res) => {
    // reportModel.findByIdAndRemove(req.params.id)
    reportModel.findByIdAndUpdate(req.params.id, {is_deleted: true})
    .then(responseData => {
        if(!responseData) {
            return res.status(404).send({
                is_error : true,
                message: "Report Details not found with id " + req.params.id
            });
        }
        res.send({is_error : false, message: "Report deleted successfully!"});
    }).catch(err => {
        if(err.kind === 'ObjectId' || err.name === 'NotFound') {
            return res.status(404).send({
                is_error : true,
                message: "Report Details not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Could not delete Report with id " + req.params.id
        });
    });
};

exports.getProjectStackeholders = async ( req, res) => {
    reportModel.findOne({_id:req.params.id, is_deleted:false})
    .populate([
        {
            path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line'],
            populate: [
                { path: 'assignedManufacturers', select:['first_name','last_name','company_name','email','role','company_logo'] }, 
                { path: 'assignedContractor', select:['first_name','last_name','company_name','email','role','company_logo'] },
                { path: 'assignedOwner', select:['first_name','last_name','company_name','email','role','company_logo'] },
                { path: 'assignedManager', select:['first_name','last_name','company_name','email','role','company_logo'] },
                {path:'assignedForeman', select:['first_name','last_name','company_name', 'email','phone','company_logo']}
            ],
        }
    ])
    .then(async response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.id
            });            
        }
        const ownerList = (response && response.projectId) ? response.projectId.assignedOwner : null;
        const contractorList = (response && response.projectId) ? response.projectId.assignedContractor : null;
        const manufacturerList = (response && response.projectId) ? response.projectId.assignedManufacturers : [];
        const managerList = (response && response.projectId && response.projectId.assignedManager ) ? response.projectId.assignedManager : [];
        let allStakeholderList = [...manufacturerList];
        if(ownerList != null){allStakeholderList.push(ownerList);}
        if(contractorList != null){allStakeholderList.push(contractorList);}
        console.log("allStakeholderList", allStakeholderList)
        res.send({is_error : false, data: allStakeholderList });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving report details with id " + req.params.id
        });
    });
}
