const buildingTypeModel = require('../model/buildingTypes');

//   BuildingType Speciifc Functions

exports.getBuildingTypes = async (req, res) => {
    try {
        const responsedata = await buildingTypeModel.find({}).sort([["building_type_name", 1]]);
        return res.send({ "is_error": false, data: responsedata })
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured" + error });
    }
};

// Create New BuildingType
exports.addBuildingType = async (req, res) => {
    console.log("req.body", req.body)
    // Our Add user logic starts here
    try {
        // Get user input
        const { building_type_name} = req.body;

        // Validate user input
        if (!building_type_name) {
            return res.status(400).send({ "is_error": true, "message": "Building Type name is required" });
        }

        // Validate if record exist in our database
        const oldRecord = await buildingTypeModel.findOne({ building_type_name: req.body.building_type_name });

        if (oldRecord) {
            return res.status(409).send({ "is_error": true, "message": "Record Already Exist with Same Name." });
        }

        // Create record in our database
        const record = await buildingTypeModel.create({
            building_type_name,
        });

        // return new record
        res.status(200).json({ is_error: false, data: record });
    } catch (err) {
        console.log(err);
        res.status(500).json({ is_error: true, data: {}, message: "Error While Creating Building Type.Please try again." + err });

    }
    // Our Add logic ends here
};

exports.findOne = async (req, res) => {
    buildingTypeModel.findById(req.params.id)
        .then(userData => {
            if (!userData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Rcord not found with id " + req.params.userId
                });
            }
            res.send({ is_error: false, data: userData });
        }).catch(err => {
            console.log("err", err)
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Record not found with id " + req.params.userId
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Record with id " + req.params.userId
            });
        });
};

exports.updateBuildingType = async (req, res) => {
     
    // Get user input
     const { building_type_name} = req.body;

    // Validate Request
    if (!building_type_name) {
        return res.status(400).send({ "is_error": true, "message": "All inputs are required." });
    }
    // Validate if record exist in our database
    const oldRecord = await buildingTypeModel.find({ building_type_name: req.body.building_type_name, _id: { $ne: req.params.id } });
    console.log("old user", oldRecord)
    if (oldRecord.length > 0) {
        return res.status(409).send({ "is_error": true, "message": "Record already exist with same name." });
    }
    // Find record and update it with the request body
    await buildingTypeModel.findByIdAndUpdate(req.params.id, {
        building_type_name: req.body.building_type_name,
    }, { new: true })
        .then(result => {
            if (!result) {
                return res.status(404).send({
                    is_error: true,
                    message: "Record details not found."
                });
            }
            res.send({
                is_error: false,
                data: result
            });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Record details not found with provided Id."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Record updating the account details."
            });
        });
};


// Delete a Building type  with the specified id in the request
exports.delete = (req, res) => {
    buildingTypeModel.findByIdAndRemove(req.params.id)
    .then(responseData => {
        if(!responseData) {
            return res.status(404).send({
                is_error : true,
                message: "Property type not found with id " + req.params.id
            });
        }
        res.send({is_error : false, message: "Property type deleted successfully!"});
    }).catch(err => {
        if(err.kind === 'ObjectId' || err.name === 'NotFound') {
            return res.status(404).send({
                is_error : true,
                message: "Property type not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Could not delete Property type with id " + req.params.id
        });
    });
};