var slugify = require('slugify')
var mongoose = require('mongoose');

const buildingModel = require('../model/buildings');
const mediaModel = require('../model/buildingMedia');

const path = require("path");
var fs = require("fs");
const fse = require('fs-extra')
const helper = require('../middleware/_helper');
const mediaUtils = require("../config/unlinkMedia");

//   Buildng/Property Speciifc Functions

exports.getBuildings = async (req, res) => {
    try {
        const query = {} ;
        if(req.query && req.query.owner && req.query.owner !=''){
            query['owner_id'] = mongoose.Types.ObjectId(req.query.owner) ;
        }
        const buildingData = await buildingModel.find(query)
        .populate({
            path: 'owner_id'
        })
        .populate({
            path: 'building_type'
        })
        .sort([["updatedAt", -1]]);

        return res.send({ "is_error": false, data: buildingData })
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured" + error });
    }
};

// Create New Building
exports.addBuilding = async (req, res) => {

    console.log("req.body", req.body);

    // Our Add logic starts here
    try {
        // Get user input
        const { owner_id, building_type, name, total_size, address_line,address_line2, country, state, city, zip_code, status } = req.body;

        // Validate user input
        if (!(owner_id && building_type && name)) {
            // delete all uploaded building media files
            await deleteMedia(req);
            return res.status(400).send({ "is_error": true, "message": "All input ( Owner, Property Type & Property Name) are required." });
        }

        // Validate if record exist in our database
        const oldRecordExist = await buildingModel.findOne({ slug: slugify(req.body.name.toLowerCase()), owner_id: req.body.owner_id });
        console.log("old record", oldRecordExist)
        if (oldRecordExist) {
             // delete all uploaded building media files
             await deleteMedia(req);
            return res.status(409).send({ "is_error": true, "message": "Property Already Exist." });
        }

        const propertyObj = new buildingModel({
            owner_id,
            building_type,
            name,
            slug: slugify(req.body.name.toLowerCase()),
            total_size,
            address_line,
            address_line2,
            country,
            state,
            city,
            zip_code,
            status
        });

        propertyObj.save()
        .then(async result => {
             // Preparing Media Object
            let media = [];

            const mediaRootPath = "public/uploads/" + req.body.owner_id + '/buildings/';
            const mediaKey = Object.keys(req.files);
            mediaKey.forEach(async key => {
                if (req.files[key].length && req.files[key].length > 0) {
                    // multiple files
                    const MediaFiles = req.files[key];
                    await MediaFiles.forEach(async mediaFile => {
                    media.push({
                        path: mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename,
                        filename: mediaFile.filename,
                        ref_id: result._id,
                        type: mediaFile.fieldname
                    });
                    })

                } else {
                    console.log("Else condition block")
                }
            })
            if(!result){
                // delete all uploaded building media files
                await media.forEach(element => {
                    mediaUtils.unlink(element.path);
                });
                return res.status(500).json({ is_error: true, data: {}, message: "Error While Creating Property.Please try again."});
            }
                // store all images,documents and videos
                await mediaModel.insertMany(media);
                // return new property data
                return res.status(200).json({ is_error: false, data: result });
        })
        // .catch(err => {
        //     console.log(err);
        //     // delete all uploaded building media files
        //     await deleteMedia(req);
        //    return res.status(500).json({ is_error: true, data: {}, message: "Error While Creating Property.Please try again." + err });
        // })

    } catch (err) {
        console.log(err);
        // delete all uploaded building media files
        await deleteMedia(req);
        return res.status(500).json({ is_error: true, data: {}, message: "Error While Creating Property.Please try again." + err });

    }
    // Our Add logic ends here

};

exports.findOne = async (req, res) => {
    buildingModel.findById(req.params.id)
        .then(result => {
            if (!result) {
                return res.status(404).send({
                    is_error: true,
                    message: "Property not found with id " + req.params.id
                });
            }
            res.send({ is_error: false, data: result });
        }).catch(err => {
            console.log("err", err)
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Property not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Property with id " + req.params.id
            });
        });
};

exports.getBuildingDetails = async (req, res) => {
    buildingModel.findById(req.params.id)
    .populate([{ path: "building_type"}])
    .populate([{ path: "owner_id" ,  select:['first_name','last_name']}])
    .populate([{ path: "media", match: { deleted: false } }])
        .then(result => {
            if (!result) {
                return res.status(404).send({
                    is_error: true,
                    message: "Property not found with id " + req.params.id
                });
            }
            res.send({ is_error: false, data: result });
        }).catch(err => {
            console.log("err", err)
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Property not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Property with id " + req.params.id
            });
        });
};

exports.updateBuilding = async (req, res) => {
    console.log("req.body", req.body);
    console.log("req.params", req.params)

    try{
        // Validate Request
    if (!(req.body.owner_id && req.body.building_type && req.body.name)) {
        // delete all uploaded building media files
        await deleteMedia(req);
        return res.status(400).send({ "is_error": true, "message": "All input ( Owner, Property Type & Property Name) are required." });
    }

    // Validate if record exist in our database
    const oldRecordExist = await buildingModel.findOne({ _id: { $ne: req.params.id }, slug: slugify(req.body.name.toLowerCase()), owner_id: req.body.owner_id });

    if (oldRecordExist) {
        // delete all uploaded building media files
        await deleteMedia(req);
        return res.status(409).send({ "is_error": true, "message": "Property Already Exist." });
    }

    // Find property and update it with the request body
    await buildingModel.findByIdAndUpdate(req.params.id, {
        owner_id: req.body.owner_id,
        building_type: req.body.building_type,
        name: req.body.name,
        slug: slugify(req.body.name.toLowerCase()),
        total_size: req.body.total_size,
        address_line: req.body.address_line,
        address_line2: req.body.address_line2,
        country: req.body.country,
        state: req.body.state,
        city: req.body.city,
        zip_code: req.body.zip_code,
        status: req.body.status
    }, { new: true })
        .then(async result => {

             // Preparing Media Object
             let media = [];

             const mediaRootPath = "public/uploads/" + req.body.owner_id + '/buildings/';
             const mediaKey = Object.keys(req.files);
             mediaKey.forEach(async key => {
                 if (req.files[key].length && req.files[key].length > 0) {
                     // multiple files
                     const MediaFiles = req.files[key];
                     await MediaFiles.forEach(async mediaFile => {
                     media.push({
                         path: mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename,
                         filename: mediaFile.filename,
                         ref_id: result._id,
                         type: mediaFile.fieldname
                     });
                     })
 
                 } else {
                     console.log("Else condition block")
                 }
             })
             if(!result){
                 // delete all uploaded building media files
                 await media.forEach(element => {
                     mediaUtils.unlink(element.path);
                 });
                 return res.status(404).send({
                    is_error: true,
                    message: "Property details not found."
                });
             }
            // store all images,documents and videos
            await mediaModel.insertMany(media);
             // Remove all the removed media from directory and Media Collection
            if (req.body.removed_items) {
                const filesTobeRemoved = JSON.parse(req.body.removed_items);
                await filesTobeRemoved.forEach(element => {
                    console.log("file tp be deletd",element)
                mediaUtils.unlink(element.path);
                // delete record from Media collection
                // mediaModel.delete({ _id: element._id, filename: element.filename, ref_id: element.ref_id }).exec();
                mediaModel.deleteOne({ _id: element._id, filename: element.filename, ref_id: element.ref_id }).exec();
                });
            }
            res.send({
                is_error: false,
                data: result
            });
        })
    }
    catch(err){
        console.log(err);
        // delete all uploaded building media files
        await deleteMedia(req);
        if (err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error: true,
                message: "Property details not found with provided Id."
            });
        }
        return res.status(500).send({
            is_error: true,
            message: "Error updating the Property details."
        });
    }
};

// Method will delete Media from the directory Path- SS
deleteMedia = async (req) => {
    // delete all uploaded building media files
    const mediaRootPath = "public/uploads/" + req.body.owner_id + '/buildings/';
    const mediaKey = Object.keys(req.files);
    console.log("Delete Media called with", mediaKey)
    console.log("mediaRootPath",mediaRootPath);

    mediaKey.forEach(async key => {
      if (req.files[key].length && req.files[key].length > 0) {
        // multiple files
        const MediaFiles = req.files[key];
        console.log("MediaFiles",MediaFiles);
        await MediaFiles.forEach(async mediaFile => {
          // call util method to remove file from location
          mediaUtils.unlink(mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename);
        })
      }
    })
  }