const bidSubmissionModel = require('../model/project_bid_submission');
const opportunityPaymentModel = require('../model/opportunityPayment');

//   Get All the Bid submissions of a Project

exports.getProjectBidSubmission = async (req, res) => {
    try {
        const responsedata = await bidSubmissionModel.find({project_id:req.params.project_id})
        // .populate([{path:'submitted_by', select:['first_name','last_name']}])
        .populate([{path:'project_id'}])
        .populate([{path:'submitted_by'}])
        .sort([["total_bid_amount",1]])
        return res.send({ "is_error": false, data: responsedata })
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured" + error });
    }
};

//   Get Bid submission details of individual Bid Submission

exports.getProjectBidSubmissionDetails = async (req, res) => {
    try {
        const responsedata = await bidSubmissionModel.findById(req.params.id);
        return res.send({ "is_error": false, data: responsedata })
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured" + error });
    }
};