require("dotenv").config();
require("./config/database").connect();
const express = require("express");
const bodyParser = require('body-parser');
const cors = require("cors");

const authRoute = require("./routes/auth");
const adminRoute = require("./routes/adminRoute");
const contractorRoute = require("./routes/contractorRoute");
const ownerRoute = require("./routes/ownerRoute");

const usersRoute = require("./routes/users");
const projectRoute = require("./routes/projects");
const reportsRoute = require("./routes/reports");
const communicationRoute = require("./routes/communication_message");
const publicRoute = require("./routes/public_route");


const path = require("path");

const app = express();

express.static(path.join(process.cwd(), "./public"))
// parse requests of content-type - application/x-www-form-urlencoded
app.use(bodyParser.urlencoded({ extended: true }));
// parse requests of content-type - application/json
app.use(bodyParser.json());

app.use(express.json());
app.use(cors());

app.use('/public', express.static('public'));
app.get("/", express.static(path.join(__dirname, "./public")));

app.use("/api/v1", authRoute);
app.use("/api/v1/admin", adminRoute);
app.use("/api/v1/contractor", contractorRoute);
app.use("/api/v1/owner", ownerRoute);


app.use("/api/users", usersRoute);
app.use("/api/projects", projectRoute);
app.use("/api/reports", reportsRoute);
app.use("/api/communication", communicationRoute);
app.use("/api/web", publicRoute);


module.exports = app;