const { State, Role, User,ReRoofApproach } = require("../models");
const { states, roles ,ReRoofApproachData } = require("../constants/seederData");
const bcrypt = require("bcryptjs");

const seedState = async () => {
    console.log("*********** Checking State Data in database ************");
    var counts = await State.count();
    if (counts < 1) {
        console.log(
            "*********** State Not exist Add States into database. Please wait ************"
        );
        await State.deleteMany({});
        try {
            const inserted = await State.insertMany(states);
            if (inserted) {
                console.log(
                    "*********** states successfully added into database ************"
                );
            } else {
                console.log(
                    "*********** Unable to add states into database. please restart application ************",
                );
            }
        } catch (e) {
            console.log(
                "*********** Unable to add states into database. please try again ************",
                e
            );
        }
    } else {
        console.log(
            "*********** states are already exists. Skipping data seeding... ************"
        );
    }
};

const seedRole = async () => {
    console.log("*********** Checking Roles Data in database ************");
    var counts = await Role.count();
    if (counts < 5) {
        console.log(
            "*********** Roles Not exist Add Roofing Roles into database. Please wait ************"
        );
        await Role.deleteMany({});
        try {
            const inserted = await Role.insertMany(roles);
            if (inserted) {
                console.log(
                    "*********** Roles successfully added into database ************",
                );
            } else {
                console.log(
                    "*********** Unable to add roles into database. please restart application ************",
                );
            }
        } catch (e) {
            console.log(
                "*********** Unable to add roles into database. please try again ************",e
            );
        }
    } else {
        console.log(
            "*********** Roles are already exists skipping data seeding ************"
        );
    }
};

const seedAdmin = async () => {
    console.log("******** Checking Admin *************");
    var counts = await User.find({
        role: "ADMIN"
    }).count();
    let password = "12345678";
    password = bcrypt.hashSync(password, 3);
    if (counts < 1) {
        let user = new User({
            first_name: "Roofing",
            last_name: "Admin",
            email: "admin@roofingprojects.com",
            password,
            role: "ADMIN",
            city:"Banglore",
            state: "KA",
            country: "INDIA",
            zip_code: 1234567,
            mobile_no:123457988,
            user_id: "ADMIN#123"
        });
        try {
            user = await user.save();
            console.log("************ admin created. Please change your login password ************")
        } catch (e) {
            console.log("unable to create admin.....", e);
        }
    }
};

// const seedReRoofApproach = async () => {
//     console.log("************ CHecking Re Roofing ************************");
//     var counts = await ReRoofApproach.count();
//     if (counts < 1) {
//         const inserted = await ReRoofApproach.insertMany(ReRoofApproachData);
//         if(inserted){
//             console.log("******************* ReRoof Added ******************");
//         }
//     }else{
//         console.log("**************** ReRoof Already Exists. Skipping data seeding ***********");
//     }
// }

module.exports = {
    seedState,
    seedRole,
    seedAdmin
};
