const sgMail = require("@sendgrid/mail");
module.exports = {
  sendMail: function async(to, subject, text, filename, content) {
    // sgMail.setApiKey(process.env.SENDGRID_API_KEY);
    sgMail.setApiKey(process.env.NEW_SENDGRID_API_KEY);
    const msg = {
      to: to, //Change to your recipient
      from: process.env.SUPPORT_EMAIL, //Change to your verified sender
      subject: subject,
      html: text,
    };

    if (filename && content) {
      msg.files = [{
        filename: filename,
        content: content
      }]
    }

    sgMail
      .sendMultiple(msg)
      .then(() => {
        console.log("Email sent");
      })
      .catch((error) => {
        console.error(error);
      });
  },

  sendMailWithTemplate: function async(emailData) {
    console.log(emailData)
    emailData.msg.from =  process.env.SUPPORT_EMAIL ;
    sgMail.setApiKey(process.env.NEW_SENDGRID_API_KEY);
    sgMail
      .sendMultiple(emailData.msg)
      .then(() => {
        console.log("Email sent with template");
      })
      .catch((error) => {
        console.error(error);
      });
  },
};
