require("dotenv").config();
const jwt = require("jsonwebtoken");

const getJwtToken = (payload) => {
  const token = jwt.sign(
    payload,
    process.env.TOKEN_SECRET,
    {
      expiresIn: '24h',
    }
  );
  return token;
};

const validateJwtToken = (payload) => {
  let response = {}
  jwt.verify(payload, process.env.TOKEN_SECRET, (err, decoded) => {
    if (err) {
      response.status = false;
      response.payload = {};
    } else {
      response.status = true;
      response.payload = decoded;
    }
    return response;
  })
}

const getLoggedInUser = async (token) => {
  try {
    const decoded = jwt.verify(token, process.env.TOKEN_SECRET);
    return ({status: true, payload: decoded});
  } catch (err) {
    return ({status: false, payload:{}});
  }
};

module.exports = {
  getJwtToken,
  validateJwtToken,
  getLoggedInUser
}
