const express = require("express");
const webRouter = express.Router();
const { validateRequest, validateToken, validate } = require("../middlewares/");
const { AuthController, CMSPageController, TermController, FaqController } = require("../controllers");
const { Auth } = require("../mobile");

var multer = require("multer");
const { storage } = require("../config/multer.config");
// Multer configurations
var upload = multer({ storage: storage });

// User Authentication Routes
webRouter.post("/login", AuthController.login);
webRouter.post("/signup", upload.fields([{ name: "company_logo" }]), AuthController.signup);
webRouter.post("/contact-us", AuthController.contactUs);
webRouter.post("/forgetPassword", AuthController.forgetPassword);
webRouter.post("/verify/token", AuthController.verifyToken);
webRouter.post("/reset/password", AuthController.resetPassword);
webRouter.get("/get-user", [validateToken.verify], AuthController.getUserById);
webRouter.get("/logout", AuthController.logout);
// Mobile Routes
webRouter.post("/reset-password", [validate.resetPassword], Auth.resetPassword);
webRouter.put("/edit/user", [validateToken.verify], upload.fields([{ name: "image" }]), Auth.updateUserById);
webRouter.put("/update/profilepic", [validateToken.verify], upload.fields([{ name: "profile_pic" }]), Auth.updateProfilePicture);
webRouter.post("/forget-password", Auth.forgetPassword);
webRouter.post("/verify/otp", Auth.verifyEmail);
webRouter.get("/pages/:slug", CMSPageController.findPageBySlug);

webRouter.get("/term/view/all", TermController.viewAll);
webRouter.get("/faq/view/all", FaqController.viewAll);

webRouter.post("/login_new", AuthController.login_new);



module.exports = webRouter;