const express = require("express");
const SharedRouter = express.Router();
const { SharedController, NotificationsSettingsCtrl } = require("../controllers");
const { validateToken, mustBe } = require("../middlewares");

var multer = require("multer");
const { storage } = require("../config/multer.config");

// Multer configurations
var upload = multer({ storage: storage });

// Contractor Global middleware
SharedRouter.use([
  validateToken.verify,
  mustBe.active,
]);

// User Profile Management
SharedRouter.get("/profile/view", SharedController.getProfileDetails);
SharedRouter.put("/password/update", SharedController.changePassword);
SharedRouter.put("/profile/update", upload.fields([{ name: "profile_pic" }]),SharedController.updateProfile);

SharedRouter.get("/notification/settings/all", NotificationsSettingsCtrl.findAll);
SharedRouter.put("/notification/settings/update", NotificationsSettingsCtrl.update);

SharedRouter.get("/notification/all", SharedController.getAllNotifications);
SharedRouter.get("/notification/unread", SharedController.getMyUnreadNotifications);
SharedRouter.get("/notification/my-notifications", SharedController.getMyNotifications);
SharedRouter.post("/notification/markAsRead", SharedController.markNotificationAsRead);



SharedRouter.post("/notification/create", SharedController.addNotifications);


module.exports = SharedRouter;
