const express = require("express");
const rpcRouter = express.Router();
const { validateToken, validateContractor, validateRvalue } = require("../middlewares/");
const { RPCManagement, Owner, Manufacturer, Building, Project, Contractor, Estimator, RoofType, MaterialType, NewRoofType, RValueController, WindUplift, BidController, RoofApproach, MediaDocuments, Inspection, OwnerTypeController, BuildingTypeController, FaqController, InvoiceController, ConvensionalBid,ProjectCategoryController, BidFormTemplateCtrl, BidSubmissionCtrl, MasterLineItemsCtrl,MasterProjectDescriptionCtrl, BidInvitationCtrl, GraphReportCtrl, SharedController, DashboardController } = require("../controllers");
const { ProjectController } = require('../mobile');

var multer = require("multer");
const { storage } = require("../config/multer.config");
// Multer configurations
var upload = multer({ storage: storage });

//Question Answer management Routes
// RPC Global middleware
rpcRouter.use([
  validateToken.verify,
  // mustBe.active,
  // mustBe.rpcManager,
]);

// Get user permissions and module details
rpcRouter.post("/users/permissions", SharedController.getuserPermission);

rpcRouter.post("/post/answer", ProjectController.addAnswer);
rpcRouter.get("/projects/getAll/questionAnswers", ProjectController.viewAllQuestionsAndAnswers);

// RPC Global middleware
// rpcRouter.use([
//   authorization.hasPermission,
// ]);

// RPC  Dashboard Route- shivam
rpcRouter.get("/getDashboardData", DashboardController.getDashboardData);

// RPC Management Routes
rpcRouter.post("/rpc-management/create",  upload.fields([{ name: "company_logo" }]) , RPCManagement.addRPC);
rpcRouter.get("/rpc-management/read/all", RPCManagement.getAll_RPC);
rpcRouter.get("/rpc-management/getOne", RPCManagement.viewRPC);
rpcRouter.put("/rpc-management/update", upload.fields([{ name: "company_logo" }]), RPCManagement.updateRPC);
rpcRouter.delete("/rpc-management/delete/", RPCManagement.deleteRPC); // ?id=
rpcRouter.post("/rpc-management/update/status", RPCManagement.updateRPCstatus);
rpcRouter.get("/rpc-management/search", RPCManagement.searchRPCManager); //?value=
rpcRouter.post("/rpc-management/view/:id", RPCManagement.viewRPC);

// Owner Management Routes
rpcRouter.post("/owner/create",upload.fields([{ name: "company_logo" }]), Owner.add);
rpcRouter.get("/owner/view", Owner.viewOne); // ?id=
rpcRouter.get("/owner/view/all", Owner.viewAll);
rpcRouter.put("/owner/update",upload.fields([{ name: "company_logo" }]), Owner.update);
rpcRouter.delete("/owner/delete/:id", Owner.deleteOwner); //?id=
rpcRouter.get("/owner/view/search", Owner.search); //?id=value
rpcRouter.post("/owner/update/status", Owner.updatestatus);

// Manufacturer Management Routes
rpcRouter.post("/manufacturer/create",upload.fields([{ name: "company_logo" }]), Manufacturer.add);
rpcRouter.get("/manufacturer/view/all", Manufacturer.viewAll);
rpcRouter.put("/manufacturer/update",upload.fields([{ name: "company_logo" }]), Manufacturer.update);
rpcRouter.delete("/manufacturer/delete/:id", Manufacturer.deleteManufacturer); //?id=

// Building Management Routes
rpcRouter.post("/building/create", upload.fields([{ name: "building_videos" }, { name: "building_images" }, { name: "building_documents" }]), Building.add);
rpcRouter.get("/building/view/all", Building.viewAll);
rpcRouter.get("/building/get/all", Building.getAllBuildings);
rpcRouter.get("/building/view", Building.viewOne); // ?id=value
rpcRouter.put("/building/update", upload.fields([{ name: "building_videos" }, { name: "building_images" }, { name: "building_documents" }]), Building.update);
rpcRouter.delete("/building/delete/", Building.deleteOne);
rpcRouter.delete("/building/delete/document", Building.deleteDocument);
rpcRouter.delete("/building/delete/:id", Building.deleteBuilding); //?id=

// Project Management Routes
rpcRouter.post("/project/create", upload.fields([{ name: "roof_drawings" }, { name: "images" }, { name: "standard_contract" }, { name: "insurance" }, { name: "videos" }, { name: "detail_drawings" }, { name: "specifications" }]), Project.add);
rpcRouter.get("/project/view/all", Project.viewAll);
rpcRouter.get("/project/view", Project.viewOne); // /?id=
rpcRouter.get("/project/details", Project.details);
rpcRouter.put("/project/update", upload.fields([{ name: "roof_drawings" }, { name: "images" }, { name: "standard_contract" }, { name: "insurance" }, { name: "videos" }, { name: "detail_drawings" }, { name: "specifications" }]), Project.update);
rpcRouter.delete("/project/delete/:id", Project.deleteProject); //?id=
rpcRouter.post("/project/addUpdateEstimator", Project.addUpdateEstimatorAssitance);
rpcRouter.put("/project/bids/change-period", Project.changeBidPeriod);


// Contractor Management Routes
rpcRouter.post("/contractor/create",upload.fields([{ name: "company_logo" }]), Contractor.addContractor);
rpcRouter.get("/contractor/view/all", Contractor.viewAllContractor);
rpcRouter.get("/contractor/view", Contractor.viewContractor); // /?id=
rpcRouter.put("/contractor/update", upload.fields([{ name: "company_logo" }]),Contractor.updateContractor);
rpcRouter.delete("/contractor/delete/:id", Contractor.deleteContractor); //?id=
rpcRouter.post("/contractor/update/status", Contractor.updateContractorStatus);

// Material Type Management Routes
rpcRouter.post("/material/create", MaterialType.add);
rpcRouter.get("/material/view/all", MaterialType.viewAll);
rpcRouter.get("/material/view", MaterialType.viewOne); // /?id=
rpcRouter.put("/material/update", MaterialType.update);
rpcRouter.delete("/material/delete/:id", MaterialType.deleteMaterialType); //?id=
rpcRouter.post("/material/update/status", MaterialType.updateStatus);


// New Roof Type Management Routes
rpcRouter.post("/newrooftype/create", NewRoofType.add);
rpcRouter.get("/newrooftype/view/all", NewRoofType.viewAll);
rpcRouter.get("/newrooftype/view", NewRoofType.viewOne); // /?id=
rpcRouter.put("/newrooftype/update", NewRoofType.update);
rpcRouter.delete("/newrooftype/delete/:id", NewRoofType.deleteNewRoofType); //?id=
rpcRouter.post("/newrooftype/update/status", NewRoofType.updateStatus);

//Roofing Management System Routes
rpcRouter.post("/roofType/create", RoofType.add);
rpcRouter.put("/roofType/update", RoofType.update);
rpcRouter.get("/roofType/view/all", RoofType.viewAll);
rpcRouter.get("/roofType/view", RoofType.viewOne); // /?id=
rpcRouter.delete("/roofType/delete/:id", RoofType.deleteRoofType);
rpcRouter.post("/roofType/update/status", RoofType.updateRoofStatus);


//Roofing Approach Management System Routes
rpcRouter.post("/roofApproach/create", RoofApproach.add);
rpcRouter.put("/roofApproach/update", RoofApproach.update);
rpcRouter.get("/roofApproach/view/all", RoofApproach.viewAll);
rpcRouter.get("/roofApproach/view", RoofApproach.viewRvalue); // ?id=
rpcRouter.delete("/roofApproach/delete/:id", RoofApproach.deleteRoofApproach);
rpcRouter.post("/roofApproach/update/status", RoofApproach.updateStatus);

//R-Value Management Routes
rpcRouter.post("/r-value/create", [validateRvalue.addRvalue], RValueController.addRValue);
rpcRouter.delete("/r-value/delete/:id", RValueController.deleteRValue); //?id=
rpcRouter.put("/r-value/update", RValueController.updateRValue);
rpcRouter.get("/r-value/view/all", RValueController.viewAllRValue);
rpcRouter.get("/r-value/view", RValueController.viewRvalue); // ?id=
rpcRouter.post("/r-value/update/status", RValueController.updateRvaluestatus);

//Owner Type Management Routes
rpcRouter.post("/owner-type/create", OwnerTypeController.add);
rpcRouter.delete("/owner-type/delete/:id", OwnerTypeController.deleteOwnerType); //?id=
rpcRouter.put("/owner-type/update", OwnerTypeController.update);
rpcRouter.get("/owner-type/view/all", OwnerTypeController.viewAll);
rpcRouter.get("/owner-type/view", OwnerTypeController.viewOwnerType); // ?id=
rpcRouter.post("/owner-type/update/status", OwnerTypeController.updateOwnerTypestatus);

//Building Type Management Routes
rpcRouter.post("/building-type/create", BuildingTypeController.add);
rpcRouter.delete("/building-type/delete/:id", BuildingTypeController.deleteBuildingType); //?id=
rpcRouter.put("/building-type/update", BuildingTypeController.update);
rpcRouter.get("/building-type/view/all", BuildingTypeController.viewAll);
rpcRouter.get("/building-type/view", BuildingTypeController.viewBuildingType); // ?id=
rpcRouter.post("/building-type/update/status", BuildingTypeController.updateBuildingTypestatus);

// Wind Uplift Management Routes
rpcRouter.post("/windUplift/create", WindUplift.add);
rpcRouter.get("/windUplift/view/all", WindUplift.viewAll);
rpcRouter.get("/windUplift/view", WindUplift.viewOne); // /?id=
rpcRouter.put("/windUplift/update", WindUplift.update);
rpcRouter.delete("/windUplift/delete/:id", WindUplift.deleteWindUplift); //?id=
rpcRouter.post("/windUplift/update/status", WindUplift.updateWindUpliftStatus);

// Bid Routes 
rpcRouter.post("/bids/view/all", BidController.allBidByProjectId);
rpcRouter.get("/bids/view", BidController.viewBid);
rpcRouter.put("/bids/change-status", BidController.changeStatus);
rpcRouter.put("/bids/change-period", BidController.changeBidPeriod);
rpcRouter.post("/bids/add-contractor", BidController.addContrator);
rpcRouter.post("/bids/send-invite", BidController.sendInvitationToContrator);
rpcRouter.post("/bids/make-bid-winner", BidController.makeBidWinner);
rpcRouter.get("/bidden/projects", BidController.biddenprojects);
rpcRouter.get("/bidden/view/all", BidController.viewAllBids);
rpcRouter.post("/sendEmailTo/bidders", BidController.sendEmailtoBidders);
rpcRouter.post("/bidders/list", BidController.getBiddersByProjectId);
// Media Routes 
rpcRouter.post("/media/create", upload.fields([{ name: "roof_drawings" }, { name: "images" }, { name: "standard_contract" }, { name: "insurance" }, { name: "videos" }, { name: "detail_drawings" }, { name: "specifications" }]), MediaDocuments.addMedia);
rpcRouter.delete("/media/delete/:id", MediaDocuments.deleteDocument);

// Inspection Routes 
rpcRouter.post("/inspection/create", upload.fields([{ name: "inspection_images" }, { name: "inspection_documents" }, { name: "inspection_videos" }]), Inspection.add);
rpcRouter.get("/inspection/view/all", Inspection.viewAll);
rpcRouter.put("/inspection/update", upload.fields([{ name: "inspection_images" }, { name: "inspection_documents" }, { name: "inspection_videos" }]) , Inspection.update);
rpcRouter.delete("/inspection/delete/:id", Inspection.deleteInspection); //?id=
rpcRouter.get("/inspection/view", Inspection.viewOne);

// FAQ Routes
rpcRouter.post("/faq/create", FaqController.add);
rpcRouter.get("/faq/view/all", FaqController.viewAll);
rpcRouter.put("/faq/update", FaqController.update);
rpcRouter.delete("/faq/delete/:id", FaqController.deleteFaq); //?id=


// Invoices
rpcRouter.post("/invoice/generate", InvoiceController.createInvoice);
rpcRouter.get("/invoice/download", InvoiceController.downloadInvoice)
rpcRouter.post("/invoice/mail", InvoiceController.mailInvoice);
rpcRouter.get("/invoices", InvoiceController.getListOfProjectWithInvoices);

// convensional Bid route
rpcRouter.post("/convensional-bid/create", ConvensionalBid.create);
rpcRouter.get("/convensional-bid/get/all", ConvensionalBid.getAll);
rpcRouter.get("/convensional-bid/get", ConvensionalBid.getOne);
rpcRouter.put("/convensional-bid/update", ConvensionalBid.update);
rpcRouter.delete("/convensional-bid/delete/:id", ConvensionalBid.deleteBid); //?id=

// convensional Bid route
rpcRouter.post("/estimator/create", Estimator.add);
rpcRouter.get("/estimator/get/all", Estimator.viewAll);
rpcRouter.get("/estimator/get", Estimator.viewOne);
rpcRouter.put("/estimator/update", Estimator.update);
rpcRouter.delete("/estimator/delete/:id", Estimator.deleteEstimator);

// Project category/ Subcategory Routes
rpcRouter.post("/project/category/create", ProjectCategoryController.addCategory);
rpcRouter.post("/project/subcategory/create", ProjectCategoryController.addSubCategory);
rpcRouter.put("/project/category/update", ProjectCategoryController.update);
rpcRouter.get("/project/category/view/all", ProjectCategoryController.getAllCategories);
rpcRouter.get("/project/subcategory/view/all", ProjectCategoryController.getAllSubCategories);
rpcRouter.get('/project/subcategory/:cat_id', ProjectCategoryController.getSubCategoriesByCatId);
rpcRouter.delete("/project/category/delete/:id", ProjectCategoryController.deleteCategory);
rpcRouter.delete("/project/subcategory/delete/:id", ProjectCategoryController.deleteSubCategory);

// Project specific Bid Form Template Routes
rpcRouter.post("/project/bidForm/create", BidFormTemplateCtrl.create);
rpcRouter.get("/project/viewBidForm/:project_id", BidFormTemplateCtrl.getProjectBidForm);

rpcRouter.put("/project/bidForm/update", BidFormTemplateCtrl.updateBidForm);
rpcRouter.get("/project/bidSubmission/list/:project_id", BidSubmissionCtrl.getAllBids);
rpcRouter.post("/project/bidSubmission/award", BidSubmissionCtrl.awardBid);



// Master Line Items  Management - related to bid Form Line items Master Database 
rpcRouter.get("/masterLineItems/list", MasterLineItemsCtrl.viewAll);
rpcRouter.post("/masterLineItems/create", MasterLineItemsCtrl.add);
rpcRouter.put("/masterLineItems/update", MasterLineItemsCtrl.updateLineItem);

// Master Project Description Management - Master project description DB
rpcRouter.get("/masterProjectDescription/list", MasterProjectDescriptionCtrl.fullData);
rpcRouter.get("/masterProjectDescription/list-pagination", MasterProjectDescriptionCtrl.viewAll);
rpcRouter.post("/masterProjectDescription/create", MasterProjectDescriptionCtrl.add);
rpcRouter.put("/masterProjectDescription/update", MasterProjectDescriptionCtrl.updateMasterProjectDescritpion);

rpcRouter.post("/bid-invitation/send", BidInvitationCtrl.sendBidInvitation);
rpcRouter.post("/bid-invitation/list", BidInvitationCtrl.getAllInvitationByProjectId);
rpcRouter.post("/send_email_to_bidders", BidInvitationCtrl.sendEmailtoBidders);

//Graph Reports Module - Templates creation
rpcRouter.post("/graph_reports/create", GraphReportCtrl.create);
rpcRouter.put("/graph_reports/update", GraphReportCtrl.updateGraphTemplate);
rpcRouter.get("/graph_reports/list", GraphReportCtrl.getGraphreportsTemplateList);
rpcRouter.delete("/graph_reports/delete/:id", GraphReportCtrl.deleteReport); //?id=

module.exports = rpcRouter;