const express = require("express");
const ownerRouter = express.Router();
const { OwnerPortalController, DashboardController, BidSubmissionCtrl } = require("../controllers");
const {
  validateToken,
  mustBe,
  authorization,
  session,
} = require("../middlewares");

var multer = require("multer");
const { storage } = require("../config/multer.config");

// Multer configurations
var upload = multer({ storage: storage });

// Contractor Global middleware
ownerRouter.use([
  validateToken.verify,
  // session.isSessionActive,
  mustBe.active,
  mustBe.owner,
]);
// ownerRouter.use([authorization.hasPermission]);
ownerRouter.get("/project/view", OwnerPortalController.getProjectDetails);
ownerRouter.get("/project/view/all", OwnerPortalController.myProjects);
ownerRouter.get("/project/bidSubmission/list/:project_id", BidSubmissionCtrl.getAllBids);

// // Owner Profile Management
// ownerRouter.get("/profile/view", OwnerPortalController.getProfileDetails);
// ownerRouter.put("/password/update", OwnerPortalController.changePassword);
// ownerRouter.put("/profile/update", upload.fields([{ name: "profile_pic" }]),OwnerPortalController.updateProfile);

// Owner Dashboard Route
ownerRouter.get("/getDashboardData", DashboardController.getOwnerDashboardData);

module.exports = ownerRouter;
