const { moduleCtr } = require("../controllers");
const { validateToken } = require("../middlewares/");
const express = require("express");
const router = express.Router();

router.get("/",
    moduleCtr.getItems
);

/**
 * Post item route (insert new module)
 */
router.post(
    "/",
    validateToken.verify,
    moduleCtr.createItem
);

/*
 * Get item route
 */
router.post(
    "/detail",
    validateToken.verify,
    moduleCtr.getItem
);

/*
 * Update item route
 */

router.patch(
    "/:id",
    validateToken.verify,
    moduleCtr.updateItem
);
/*
 * Delete multi/single item route
 */
router.post(
    "/delete",
    validateToken.verify,
    moduleCtr.softDeleteItems
);

/*
 * Update multi item route
 */
router.post(
    "/multi",
    validateToken.verify,
    moduleCtr.updateMultiItem
);

module.exports = router;
