const express = require("express");
const manufacturerRouter = express.Router();
const { DashboardController, ManufacturerPortalController } = require("../controllers");
const {
  validateToken,
  mustBe
} = require("../middlewares");

// Contractor Global middleware
manufacturerRouter.use([
  validateToken.verify,
  // session.isSessionActive,
  mustBe.active,
//   mustBe.manufacturer,
]);
// manufacturerRouter.get("/project/view", OwnerPortalController.getProjectDetails);
manufacturerRouter.get("/project/view/all", ManufacturerPortalController.myProjects);
// Owner Dashboard Route
manufacturerRouter.get("/getDashboardData", DashboardController.getManufacturerDashboardData);

module.exports = manufacturerRouter;
